/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.smc.model;

import com.jfirer.baseutil.smc.SmcHelper;
import com.jfirer.baseutil.smc.model.ClassModel;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodModel {
    private AccessLevel accessLevel;
    private Class<?> returnType;
    private Class<?>[] paramterTypes;
    private boolean[] paramterFinals;
    private String[] paramterNames;
    private Class<?>[] throwables;
    private String methodName;
    private String body;
    private ClassModel classModel;

    public MethodModel(ClassModel classModel) {
        this.classModel = classModel;
    }

    public MethodModel(Method method, ClassModel classModel) {
        this.classModel = classModel;
        int modifiers = method.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            this.accessLevel = AccessLevel.PUBLIC;
        } else if (Modifier.isPrivate(modifiers)) {
            this.accessLevel = AccessLevel.PRIVATE;
        } else if (Modifier.isProtected(modifiers)) {
            this.accessLevel = AccessLevel.PROTECTED;
        }
        this.methodName = method.getName();
        this.returnType = method.getReturnType();
        this.paramterTypes = method.getParameterTypes();
        this.throwables = method.getExceptionTypes();
    }

    public MethodModel(MethodModel methodModel) {
        this.methodName = methodModel.methodName;
        this.accessLevel = methodModel.accessLevel;
        this.paramterTypes = methodModel.paramterTypes;
        this.throwables = methodModel.throwables;
        this.returnType = methodModel.returnType;
    }

    public String toString() {
        String[] tmp;
        StringBuilder cache = new StringBuilder();
        switch (this.accessLevel) {
            case PUBLIC: {
                cache.append("public ");
                break;
            }
            case PRIVATE: {
                cache.append("private ");
                break;
            }
            case PROTECTED: {
                cache.append("protected ");
                break;
            }
            default: {
                cache.append("public ");
            }
        }
        cache.append(SmcHelper.getReferenceName(this.returnType, this.classModel)).append(' ').append(this.methodName).append('(');
        if (this.paramterTypes != null && this.paramterTypes.length > 0) {
            Class<?> each;
            int i;
            boolean hasComma = false;
            if (this.paramterFinals == null || this.paramterFinals.length == 0) {
                for (i = 0; i < this.paramterTypes.length; ++i) {
                    each = this.paramterTypes[i];
                    if (this.paramterNames != null) {
                        cache.append(SmcHelper.getReferenceName(each, this.classModel)).append(" ").append(this.paramterNames[i]).append(',');
                    } else {
                        cache.append(SmcHelper.getReferenceName(each, this.classModel)).append(" $").append(i).append(',');
                    }
                    hasComma = true;
                }
            } else {
                for (i = 0; i < this.paramterTypes.length; ++i) {
                    each = this.paramterTypes[i];
                    if (this.paramterFinals[i]) {
                        cache.append("final ");
                    }
                    cache.append(SmcHelper.getReferenceName(each, this.classModel)).append(" ").append(this.paramterNames[i]).append(',');
                    hasComma = true;
                }
            }
            if (hasComma) {
                cache.setLength(cache.length() - 1);
            }
        }
        cache.append(')');
        if (this.throwables != null && this.throwables.length != 0) {
            cache.append(" throws ");
            for (Class<?> each : this.throwables) {
                cache.append(SmcHelper.getReferenceName(each, this.classModel)).append(',');
            }
            cache.setLength(cache.length() - 1);
        }
        cache.append(" \r\n\t{\r\n");
        for (String each : tmp = this.body.split("\r\n")) {
            cache.append("\t\t").append(each).append("\r\n");
        }
        cache.append("\t}\r\n");
        return cache.toString();
    }

    public int hashCode() {
        return this.methodName.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodModel)) {
            return false;
        }
        MethodModel target = (MethodModel)o;
        if (this.accessLevel != target.accessLevel) {
            return false;
        }
        if (!this.methodName.equals(target.methodName)) {
            return false;
        }
        if (this.paramterTypes.length != target.paramterTypes.length) {
            return false;
        }
        for (int i = 0; i < this.paramterTypes.length; ++i) {
            Class<?> class1 = this.paramterTypes[i];
            Class<?> class2 = target.paramterTypes[i];
            if (class1 == class2) continue;
            return false;
        }
        return true;
    }

    public MethodModelKey generateKey() {
        MethodModelKey key = new MethodModelKey();
        key.accessLevel = this.accessLevel;
        key.methodName = this.methodName;
        MethodModelKey.access$202(key, this.paramterTypes);
        return key;
    }

    public String generateInvoke() {
        StringBuilder cache = new StringBuilder();
        cache.append(this.methodName).append('(');
        boolean hasComma = false;
        for (int i = 0; i < this.paramterTypes.length; ++i) {
            if (this.paramterNames != null) {
                cache.append(this.paramterNames[i]).append(',');
            } else {
                cache.append("$" + i).append(',');
            }
            hasComma = true;
        }
        if (hasComma) {
            cache.setLength(cache.length() - 1);
        }
        cache.append(')');
        return cache.toString();
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Class<?>[] getParamterTypes() {
        return this.paramterTypes;
    }

    public void setParamterTypes(Class<?> ... paramterTypes) {
        this.paramterTypes = paramterTypes;
    }

    public Class<?>[] getThrowables() {
        return this.throwables;
    }

    public void setThrowables(Class<?> ... throwables) {
        this.throwables = throwables;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setParamterFinals(boolean ... paramterFinals) {
        this.paramterFinals = paramterFinals;
    }

    public void setParamterNames(String ... paramterNames) {
        this.paramterNames = paramterNames;
    }

    public static class MethodModelKey {
        private AccessLevel accessLevel;
        private Class<?>[] paramterTypes;
        private String methodName;

        public MethodModelKey() {
        }

        public MethodModelKey(Method method) {
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                this.accessLevel = AccessLevel.PUBLIC;
            } else if (Modifier.isPrivate(modifiers)) {
                this.accessLevel = AccessLevel.PRIVATE;
            } else if (Modifier.isProtected(modifiers)) {
                this.accessLevel = AccessLevel.PROTECTED;
            }
            this.methodName = method.getName();
            this.paramterTypes = method.getParameterTypes();
        }

        public int hashCode() {
            return this.methodName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodModelKey)) {
                return false;
            }
            MethodModelKey target = (MethodModelKey)o;
            if (this.accessLevel != target.accessLevel) {
                return false;
            }
            if (!this.methodName.equals(target.methodName)) {
                return false;
            }
            if (this.paramterTypes.length != target.paramterTypes.length) {
                return false;
            }
            for (int i = 0; i < this.paramterTypes.length; ++i) {
                Class<?> class1 = this.paramterTypes[i];
                Class<?> class2 = target.paramterTypes[i];
                if (class1 == class2) continue;
                return false;
            }
            return true;
        }

        public void setAccessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
        }

        public void setParamterTypes(Class<?>[] paramterTypes) {
            this.paramterTypes = paramterTypes;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        static /* synthetic */ Class[] access$202(MethodModelKey x0, Class[] x1) {
            x0.paramterTypes = x1;
            return x1;
        }
    }

    public static enum AccessLevel {
        PUBLIC,
        PRIVATE,
        PROTECTED;

    }
}

