/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.node;

import com.jfirer.jfireel.expression.node.CalculateNode;

public interface MethodNode
extends CalculateNode {
    public void setArgsNodes(CalculateNode[] var1);

    public static class MethodNodeUtil {
        public static final void convertArgs(Object[] args, ConvertType[] convertTypes) {
            block9: for (int i = 0; i < args.length; ++i) {
                Object argeValue = args[i];
                switch (convertTypes[i]) {
                    case INT: {
                        if (argeValue instanceof Integer) continue block9;
                        args[i] = ((Number)argeValue).intValue();
                        continue block9;
                    }
                    case LONG: {
                        if (argeValue instanceof Long) continue block9;
                        args[i] = ((Number)argeValue).longValue();
                        continue block9;
                    }
                    case SHORT: {
                        if (argeValue instanceof Short) continue block9;
                        args[i] = ((Number)argeValue).shortValue();
                        continue block9;
                    }
                    case FLOAT: {
                        if (argeValue instanceof Float) continue block9;
                        args[i] = Float.valueOf(((Number)argeValue).floatValue());
                        continue block9;
                    }
                    case DOUBLE: {
                        if (argeValue instanceof Double) continue block9;
                        args[i] = ((Number)argeValue).doubleValue();
                        continue block9;
                    }
                    case BYTE: {
                        if (argeValue instanceof Byte) continue block9;
                        args[i] = ((Number)argeValue).byteValue();
                        continue block9;
                    }
                    case CHARACTER: 
                    case BOOLEAN: 
                    case OTHER: {
                        continue block9;
                    }
                }
            }
        }

        public static final ConvertType[] buildConvertTypes(Class<?>[] parameterTypes) {
            ConvertType[] convertTypes = new ConvertType[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                convertTypes[i] = parameterTypes[i] == Integer.TYPE || parameterTypes[i] == Integer.class ? ConvertType.INT : (parameterTypes[i] == Short.TYPE || parameterTypes[i] == Short.TYPE ? ConvertType.SHORT : (parameterTypes[i] == Long.TYPE || parameterTypes[i] == Long.class ? ConvertType.LONG : (parameterTypes[i] == Float.TYPE || parameterTypes[i] == Float.class ? ConvertType.FLOAT : (parameterTypes[i] == Double.TYPE || parameterTypes[i] == Double.class ? ConvertType.DOUBLE : (parameterTypes[i] == Byte.TYPE || parameterTypes[i] == Byte.class ? ConvertType.BYTE : (parameterTypes[i] == Boolean.TYPE || parameterTypes[i] == Boolean.class ? ConvertType.BOOLEAN : ConvertType.OTHER))))));
            }
            return convertTypes;
        }

        public static final boolean isWrapType(Class<?> primitiveType, Class<?> arge) {
            if (primitiveType == Integer.TYPE) {
                return arge == Integer.class || arge == Long.class;
            }
            if (primitiveType == Short.TYPE) {
                return arge == Integer.class || arge == Long.class;
            }
            if (primitiveType == Long.TYPE) {
                return arge == Integer.class || arge == Long.class;
            }
            if (primitiveType == Boolean.TYPE) {
                return arge == Boolean.class;
            }
            if (primitiveType == Float.TYPE) {
                return arge == Float.class || arge == Double.class;
            }
            if (primitiveType == Double.TYPE) {
                return arge == Float.class || arge == Double.class;
            }
            if (primitiveType == Character.TYPE) {
                return arge == Character.class;
            }
            if (primitiveType == Byte.TYPE) {
                return arge == Integer.class || arge == Long.class;
            }
            return false;
        }
    }

    public static enum ConvertType {
        INT,
        LONG,
        SHORT,
        FLOAT,
        DOUBLE,
        BYTE,
        BOOLEAN,
        CHARACTER,
        OTHER;

    }
}

