/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.node.impl;

import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.token.Token;
import com.jfirer.jfireel.expression.token.TokenType;
import java.util.List;
import java.util.Map;

public class BracketNode
implements CalculateNode {
    private CalculateNode beanNode;
    private CalculateNode valueNode;
    private ValueType type;

    public BracketNode(CalculateNode beanNode, CalculateNode valueNode) {
        this.beanNode = beanNode;
        this.valueNode = valueNode;
        this.type = valueNode.type() == Token.STRING ? ValueType.STRING : (valueNode.type() == Token.NUMBER ? ValueType.NUMBER : ValueType.RUNTIME);
    }

    @Override
    public Object calculate(Map<String, Object> variables) {
        Object value = this.valueNode.calculate(variables);
        if (value == null) {
            return null;
        }
        switch (this.type) {
            case STRING: {
                return this.returnMapValue(variables, (String)value);
            }
            case NUMBER: {
                return this.returnArrayOrListValue(variables, (Number)value);
            }
            case RUNTIME: {
                if (value instanceof String) {
                    return this.returnMapValue(variables, (String)value);
                }
                if (value instanceof Number) {
                    return this.returnArrayOrListValue(variables, (Number)value);
                }
                throw new IllegalArgumentException(value.getClass().getName());
            }
        }
        throw new UnsupportedOperationException();
    }

    private Object returnArrayOrListValue(Map<String, Object> variables, Number value) {
        Object beanValue = this.beanNode.calculate(variables);
        if (beanValue == null) {
            return null;
        }
        if (beanValue instanceof List) {
            return ((List)beanValue).get(value.intValue());
        }
        if (beanValue instanceof Object[]) {
            return ((Object[])beanValue)[value.intValue()];
        }
        if (beanValue instanceof int[]) {
            return ((int[])beanValue)[value.intValue()];
        }
        if (beanValue instanceof long[]) {
            return ((long[])beanValue)[value.intValue()];
        }
        if (beanValue instanceof short[]) {
            return ((short[])beanValue)[value.intValue()];
        }
        if (beanValue instanceof float[]) {
            return Float.valueOf(((float[])beanValue)[value.intValue()]);
        }
        if (beanValue instanceof double[]) {
            return ((double[])beanValue)[value.intValue()];
        }
        if (beanValue instanceof boolean[]) {
            return ((boolean[])beanValue)[value.intValue()];
        }
        if (beanValue instanceof char[]) {
            return Character.valueOf(((char[])beanValue)[value.intValue()]);
        }
        if (beanValue instanceof byte[]) {
            return ((byte[])beanValue)[value.intValue()];
        }
        throw new IllegalArgumentException(beanValue.getClass().getName());
    }

    private Object returnMapValue(Map<String, Object> variables, String value) {
        return ((Map)this.beanNode.calculate(variables)).get(value);
    }

    @Override
    public TokenType type() {
        return Token.BRACKET;
    }

    @Override
    public String literals() {
        return this.beanNode.literals() + "[" + this.valueNode.literals() + "]";
    }

    public String toString() {
        return this.literals();
    }

    static enum ValueType {
        STRING,
        NUMBER,
        RUNTIME;

    }
}

