/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.node.impl;

import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.token.Token;
import com.jfirer.jfireel.expression.token.TokenType;
import java.util.Map;

public class KeywordNode
implements CalculateNode {
    private Object keywordValue;

    public KeywordNode(String literals) {
        if (literals.equalsIgnoreCase("true")) {
            this.keywordValue = Boolean.TRUE;
        } else if (literals.equalsIgnoreCase("false")) {
            this.keywordValue = Boolean.FALSE;
        } else if (literals.equalsIgnoreCase("null")) {
            this.keywordValue = null;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Object calculate(Map<String, Object> variables) {
        return this.keywordValue;
    }

    @Override
    public TokenType type() {
        return Token.CONSTANT;
    }

    public String toString() {
        return "KeywordNode [keywordValue=" + this.keywordValue + "]";
    }

    @Override
    public String literals() {
        if (this.keywordValue != null) {
            return this.keywordValue.toString();
        }
        return "NULL";
    }
}

