/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.template.parser.impl;

import com.jfirer.jfireel.exception.IllegalFormatException;
import com.jfirer.jfireel.expression.Expression;
import com.jfirer.jfireel.template.ScanMode;
import com.jfirer.jfireel.template.Template;
import com.jfirer.jfireel.template.execution.Execution;
import com.jfirer.jfireel.template.execution.impl.IfExecution;
import com.jfirer.jfireel.template.parser.Invoker;
import com.jfirer.jfireel.template.parser.Parser;
import java.util.Deque;

public class IfParser
extends Parser {
    @Override
    public int parse(String sentence, int offset, Deque<Execution> executions, Template template, StringBuilder cache, Invoker next) {
        if (template.getMode() != ScanMode.EXECUTION) {
            return next.scan(sentence, offset, executions, template, cache);
        }
        int origin = offset;
        if (this.getChar(offset = this.skipWhiteSpace(offset, sentence), sentence) != 'i' || this.getChar(offset + 1, sentence) != 'f') {
            return next.scan(sentence, origin, executions, template, cache);
        }
        if ('(' != this.getChar(offset = this.skipWhiteSpace(offset + 2, sentence), sentence)) {
            throw new IllegalFormatException("IF\u6761\u4ef6\u6ca1\u6709\u4ee5(\u5f00\u59cb\u8fdb\u884c\u5305\u56f4", sentence.substring(0, offset));
        }
        int leftBracketIndex = offset;
        if ((offset = this.findEndRightBracket(sentence, offset)) == -1) {
            throw new IllegalFormatException("if\u6761\u4ef6\u6ca1\u6709\u7528)\u5305\u56f4", sentence.substring(0, leftBracketIndex));
        }
        String ifLiterals = sentence.substring(leftBracketIndex + 1, offset);
        Expression expression = Expression.parse(ifLiterals);
        IfExecution execution = new IfExecution(expression);
        executions.push(execution);
        ++offset;
        offset = this.findMethodBodyBegin(sentence, offset);
        return offset;
    }
}

