/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tispark.statistics;

import com.google.common.primitives.UnsignedLong;
import com.pingcap.tidb.tipb.CMSketch;
import com.pingcap.tidb.tipb.CMSketchRow;
import com.pingcap.tikv.expression.ByItem;
import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.Constant;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.meta.TiTimestamp;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.statistics.Bucket;
import com.pingcap.tikv.statistics.ColumnStatistics;
import com.pingcap.tikv.statistics.Histogram;
import com.pingcap.tikv.statistics.IndexStatistics;
import com.pingcap.tikv.types.BytesType;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tispark.statistics.StatisticsDTO;
import com.pingcap.tispark.statistics.StatisticsHelper$;
import com.pingcap.tispark.statistics.StatisticsManager$;
import com.pingcap.tispark.statistics.StatisticsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class StatisticsHelper$ {
    public static final StatisticsHelper$ MODULE$;
    private Logger logger;
    private final Seq<String> metaRequiredCols;
    private final Seq<String> histRequiredCols;
    private final Seq<String> bucketRequiredCols;
    private volatile boolean bitmap$0;

    static {
        new StatisticsHelper$();
    }

    private Logger logger$lzycompute() {
        StatisticsHelper$ statisticsHelper$ = this;
        synchronized (statisticsHelper$) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    private final Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Seq<String> metaRequiredCols() {
        return this.metaRequiredCols;
    }

    private Seq<String> histRequiredCols() {
        return this.histRequiredCols;
    }

    private Seq<String> bucketRequiredCols() {
        return this.bucketRequiredCols;
    }

    public boolean isManagerReady() {
        return StatisticsManager$.MODULE$.metaTable() != null && StatisticsManager$.MODULE$.bucketTable() != null && StatisticsManager$.MODULE$.histTable() != null;
    }

    public StatisticsDTO extractStatisticsDTO(Row row, TiTableInfo table, boolean loadAll, ArrayBuffer<Object> neededColIds, TiTableInfo histTable) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (row.fieldCount() < 6) {
            return null;
        }
        if (row.getLong(0) != table.getId()) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table id not match ", "!=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)row.getLong(0)), BoxesRunTime.boxToLong((long)table.getId())})));
            return null;
        }
        boolean isIndex = row.getLong(1) > 0L;
        long histID = row.getLong(2);
        long distinct = row.getLong(3);
        long nullCount = row.getLong(4);
        long histVer = row.getUnsignedLong(5);
        byte[] cMSketch = this.com$pingcap$tispark$statistics$StatisticsHelper$$checkColExists(histTable, "cm_sketch") ? row.getBytes(6) : null;
        Buffer indexInfos = (Buffer)Buffer$.MODULE$.empty();
        Buffer colInfos = (Buffer)Buffer$.MODULE$.empty();
        boolean needed = true;
        if (!loadAll && !neededColIds.contains((Object)BoxesRunTime.boxToLong((long)histID))) {
            needed = false;
        }
        if (isIndex) {
            indexInfos = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(table.getIndices()).filter((Function1)new Serializable(histID){
                public static final long serialVersionUID = 0L;
                private final long histID$1;

                public final boolean apply(TiIndexInfo x$1) {
                    return x$1.getId() == this.histID$1;
                }
                {
                    this.histID$1 = histID$1;
                }
            });
            if (indexInfos.isEmpty()) {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find index histogram id ", " in table info ", "[", "] now. It may be deleted."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)histID), table.getName(), BoxesRunTime.boxToLong((long)table.getId())})));
                needed = false;
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), null);
            } else {
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)BytesType.BLOB);
            }
        } else {
            colInfos = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(table.getColumns()).filter((Function1)new Serializable(histID){
                public static final long serialVersionUID = 0L;
                private final long histID$1;

                public final boolean apply(TiColumnInfo x$2) {
                    return x$2.getId() == this.histID$1;
                }
                {
                    this.histID$1 = histID$1;
                }
            });
            if (colInfos.isEmpty()) {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find column histogram id ", " in table info ", "[", "] now. It may be deleted."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)histID), table.getName(), BoxesRunTime.boxToLong((long)table.getId())})));
                needed = false;
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), null);
            } else {
                tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)((TiColumnInfo)colInfos.head()).getType());
            }
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            int indexFlag = tuple2._1$mcI$sp();
            DataType dataType = (DataType)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)indexFlag), (Object)dataType);
            int indexFlag2 = tuple24._1$mcI$sp();
            DataType dataType2 = (DataType)tuple24._2();
            return needed ? new StatisticsDTO(histID, indexFlag2, distinct, histVer, nullCount, dataType2, cMSketch, indexInfos.nonEmpty() ? (TiIndexInfo)indexInfos.head() : null, colInfos.nonEmpty() ? (TiColumnInfo)colInfos.head() : null) : null;
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean shouldUpdateHistogram(ColumnStatistics statistics, StatisticsResult result) {
        if (statistics == null || result == null) {
            return false;
        }
        return this.shouldUpdateHistogram(statistics.getHistogram(), result.histogram());
    }

    public boolean shouldUpdateHistogram(IndexStatistics statistics, StatisticsResult result) {
        if (statistics == null || result == null) {
            return false;
        }
        return this.shouldUpdateHistogram(statistics.getHistogram(), result.histogram());
    }

    public boolean shouldUpdateHistogram(Histogram oldHis, Histogram newHis) {
        UnsignedLong newVersion;
        if (oldHis == null || newHis == null) {
            return false;
        }
        UnsignedLong oldVersion = UnsignedLong.fromLongBits((long)oldHis.getLastUpdateVersion());
        return oldVersion.compareTo(newVersion = UnsignedLong.fromLongBits((long)newHis.getLastUpdateVersion())) < 0;
    }

    public StatisticsResult extractStatisticResult(long histId, Iterator<Row> rows, Seq<StatisticsDTO> requests) {
        StatisticsResult statisticsResult;
        Seq matches = (Seq)requests.filter((Function1)new Serializable(histId){
            public static final long serialVersionUID = 0L;
            private final long histId$1;

            public final boolean apply(StatisticsDTO x$4) {
                return x$4.colId() == this.histId$1;
            }
            {
                this.histId$1 = histId$1;
            }
        });
        if (matches.nonEmpty()) {
            com.pingcap.tikv.statistics.CMSketch cMSketch;
            StatisticsDTO matched = (StatisticsDTO)matches.head();
            long totalCount = 0L;
            ArrayBuffer buckets = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (rows.hasNext()) {
                BoxedUnit boxedUnit;
                boolean isRequestIndex;
                Row row = (Row)rows.next();
                boolean isRowIndex = row.getLong(1) > 0L;
                boolean bl = isRequestIndex = matched.isIndex() > 0;
                if (isRequestIndex == isRowIndex) {
                    long count = row.getLong(4);
                    long repeats = row.getLong(5);
                    Key lowerBound = null;
                    Key upperBound = null;
                    lowerBound = Key.toRawKey((byte[])row.getBytes(6));
                    upperBound = Key.toRawKey((byte[])row.getBytes(7));
                    boxedUnit = buckets.$plus$eq((Object)new Bucket(totalCount += count, repeats, lowerBound, upperBound));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            Histogram histogram = Histogram.newBuilder().setId(matched.colId()).setNDV(matched.distinct()).setNullCount(matched.nullCount()).setLastUpdateVersion(matched.version()).setBuckets(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)buckets)).build();
            byte[] rawData = matched.rawCMSketch();
            if (rawData == null || rawData.length <= 0) {
                cMSketch = null;
            } else {
                CMSketch sketch = CMSketch.parseFrom((byte[])rawData);
                com.pingcap.tikv.statistics.CMSketch result = com.pingcap.tikv.statistics.CMSketch.newCMSketch((int)sketch.getRowsCount(), (int)sketch.getRows(0).getCountersCount());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sketch.getRowsCount()).foreach$mVc$sp((Function1)new Serializable(sketch, result){
                    public static final long serialVersionUID = 0L;
                    private final CMSketch sketch$1;
                    public final com.pingcap.tikv.statistics.CMSketch result$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        CMSketchRow row = this.sketch$1.getRows(i);
                        this.result$1.setCount(0L);
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.getCountersCount()).foreach$mVc$sp((Function1)new Serializable(this, row, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.1 $outer;
                            private final CMSketchRow row$1;
                            private final int i$1;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                int counter = this.row$1.getCounters(j);
                                this.$outer.result$1.getTable()[this.i$1][j] = counter;
                                this.$outer.result$1.setCount(this.$outer.result$1.getCount() + (long)counter);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.row$1 = row$1;
                                this.i$1 = i$1;
                            }
                        });
                    }
                    {
                        this.sketch$1 = sketch$1;
                        this.result$1 = result$1;
                    }
                });
                cMSketch = result;
            }
            com.pingcap.tikv.statistics.CMSketch cMSketch2 = cMSketch;
            statisticsResult = new StatisticsResult(histId, histogram, cMSketch2, matched.idxInfo(), matched.colInfo());
        } else {
            statisticsResult = null;
        }
        return statisticsResult;
    }

    public boolean com$pingcap$tispark$statistics$StatisticsHelper$$checkColExists(TiTableInfo table, String column) {
        return JavaConversions$.MODULE$.asScalaBuffer(table.getColumns()).exists((Function1)new Serializable(column){
            public static final long serialVersionUID = 0L;
            private final String column$1;

            public final boolean apply(TiColumnInfo x$5) {
                return x$5.matchName(this.column$1);
            }
            {
                this.column$1 = column$1;
            }
        });
    }

    private TiDAGRequest buildRequest(TiTableInfo tableInfo, Seq<String> requiredCols, long targetTblId, TiTimestamp startTs) {
        return TiDAGRequest.Builder.newBuilder().setFullTableScan(tableInfo).addFilter((Expression)ComparisonBinaryExpression.equal((Expression)ColumnRef.create((String)"table_id"), (Expression)Constant.create((Object)BoxesRunTime.boxToLong((long)targetTblId)))).addRequiredCols(JavaConversions$.MODULE$.seqAsJavaList((Seq)requiredCols.filter((Function1)new Serializable(tableInfo){
            public static final long serialVersionUID = 0L;
            private final TiTableInfo tableInfo$1;

            public final boolean apply(String x$6) {
                return StatisticsHelper$.MODULE$.com$pingcap$tispark$statistics$StatisticsHelper$$checkColExists(this.tableInfo$1, x$6);
            }
            {
                this.tableInfo$1 = tableInfo$1;
            }
        }))).setStartTs(startTs).build(TiDAGRequest.PushDownType.NORMAL);
    }

    public TiDAGRequest buildHistogramsRequest(TiTableInfo histTable, long targetTblId, TiTimestamp startTs) {
        return this.buildRequest(histTable, this.histRequiredCols(), targetTblId, startTs);
    }

    public TiDAGRequest buildMetaRequest(TiTableInfo metaTable, long targetTblId, TiTimestamp startTs) {
        return this.buildRequest(metaTable, this.metaRequiredCols(), targetTblId, startTs);
    }

    public TiDAGRequest buildBucketRequest(TiTableInfo bucketTable, long targetTblId, TiTimestamp startTs) {
        return TiDAGRequest.Builder.newBuilder().setFullTableScan(bucketTable).addFilter((Expression)ComparisonBinaryExpression.equal((Expression)ColumnRef.create((String)"table_id"), (Expression)Constant.create((Object)BoxesRunTime.boxToLong((long)targetTblId)))).setLimit(Integer.MAX_VALUE).addOrderBy(ByItem.create((Expression)ColumnRef.create((String)"bucket_id"), (boolean)false)).addRequiredCols(JavaConversions$.MODULE$.seqAsJavaList((Seq)this.bucketRequiredCols().filter((Function1)new Serializable(bucketTable){
            public static final long serialVersionUID = 0L;
            private final TiTableInfo bucketTable$1;

            public final boolean apply(String x$7) {
                return StatisticsHelper$.MODULE$.com$pingcap$tispark$statistics$StatisticsHelper$$checkColExists(this.bucketTable$1, x$7);
            }
            {
                this.bucketTable$1 = bucketTable$1;
            }
        }))).setStartTs(startTs).build(TiDAGRequest.PushDownType.NORMAL);
    }

    private StatisticsHelper$() {
        MODULE$ = this;
        this.metaRequiredCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version", "table_id", "modify_count", "count"}));
        this.histRequiredCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table_id", "is_index", "hist_id", "distinct_count", "null_count", "version", "cm_sketch"}));
        this.bucketRequiredCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table_id", "is_index", "hist_id", "bucket_id", "count", "repeats", "lower_bound", "upper_bound"}));
    }
}

