/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tispark.statistics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.pingcap.tikv.Snapshot;
import com.pingcap.tikv.TiSession;
import com.pingcap.tikv.catalog.Catalog;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.statistics.ColumnStatistics;
import com.pingcap.tikv.statistics.IndexStatistics;
import com.pingcap.tikv.statistics.TableStatistics;
import com.pingcap.tispark.statistics.StatisticsDTO;
import com.pingcap.tispark.statistics.StatisticsHelper$;
import com.pingcap.tispark.statistics.StatisticsResult;
import com.pingcap.tispark.statistics.estimate.DefaultTableSizeEstimator$;
import com.pingcap.tispark.statistics.estimate.TableSizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class StatisticsManager$ {
    public static final StatisticsManager$ MODULE$;
    private TiSession session;
    private Snapshot snapshot;
    private Catalog catalog;
    private String dbPrefix;
    private TableSizeEstimator tableSizeEstimator;
    private TiTableInfo metaTable;
    private TiTableInfo histTable;
    private TiTableInfo bucketTable;
    private Logger logger;
    private final Cache<Long, TableStatistics> statisticsMap;
    private boolean initialized;
    private volatile boolean bitmap$0;

    static {
        new StatisticsManager$();
    }

    private Logger logger$lzycompute() {
        StatisticsManager$ statisticsManager$ = this;
        synchronized (statisticsManager$) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    private TiSession session() {
        return this.session;
    }

    private void session_$eq(TiSession x$1) {
        this.session = x$1;
    }

    private Snapshot snapshot() {
        return this.snapshot;
    }

    private void snapshot_$eq(Snapshot x$1) {
        this.snapshot = x$1;
    }

    private Catalog catalog() {
        return this.catalog;
    }

    private void catalog_$eq(Catalog x$1) {
        this.catalog = x$1;
    }

    private String dbPrefix() {
        return this.dbPrefix;
    }

    private void dbPrefix_$eq(String x$1) {
        this.dbPrefix = x$1;
    }

    private TableSizeEstimator tableSizeEstimator() {
        return this.tableSizeEstimator;
    }

    private void tableSizeEstimator_$eq(TableSizeEstimator x$1) {
        this.tableSizeEstimator = x$1;
    }

    public TiTableInfo metaTable() {
        return this.metaTable;
    }

    public void metaTable_$eq(TiTableInfo x$1) {
        this.metaTable = x$1;
    }

    public TiTableInfo histTable() {
        return this.histTable;
    }

    public void histTable_$eq(TiTableInfo x$1) {
        this.histTable = x$1;
    }

    public TiTableInfo bucketTable() {
        return this.bucketTable;
    }

    public void bucketTable_$eq(TiTableInfo x$1) {
        this.bucketTable = x$1;
    }

    private final Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private final Cache<Long, TableStatistics> statisticsMap() {
        return this.statisticsMap;
    }

    public synchronized void loadStatisticsInfo(TiTableInfo table, Seq<String> columns) {
        Predef$.MODULE$.require(table != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "TableInfo should not be null";
            }
        });
        if (StatisticsHelper$.MODULE$.isManagerReady()) {
            long tblId = table.getId();
            java.util.List tblCols = table.getColumns();
            boolean loadAll = columns == null || columns.isEmpty();
            ObjectRef neededColIds = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
            if (!loadAll) {
                ((IterableLike)columns.distinct()).foreach((Function1)new Serializable(table, tblCols, neededColIds){
                    public static final long serialVersionUID = 0L;
                    private final TiTableInfo table$1;
                    private final java.util.List tblCols$1;
                    private final ObjectRef neededColIds$1;

                    public final ArrayBuffer<Object> apply(String col) {
                        boolean isColValid = JavaConversions$.MODULE$.asScalaBuffer(this.tblCols$1).exists((Function1)new Serializable(this, col){
                            public static final long serialVersionUID = 0L;
                            private final String col$1;

                            public final boolean apply(TiColumnInfo x$1) {
                                return x$1.matchName(this.col$1);
                            }
                            {
                                this.col$1 = col$1;
                            }
                        });
                        if (isColValid) {
                            return ((ArrayBuffer)this.neededColIds$1.elem).$plus$eq((Object)BoxesRunTime.boxToLong((long)((TiColumnInfo)JavaConversions$.MODULE$.asScalaBuffer(this.tblCols$1).find((Function1)new Serializable(this, col){
                                public static final long serialVersionUID = 0L;
                                private final String col$1;

                                public final boolean apply(TiColumnInfo x$2) {
                                    return x$2.matchName(this.col$1);
                                }
                                {
                                    this.col$1 = col$1;
                                }
                            }).get()).getId()));
                        }
                        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " cannot be found in table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col, this.table$1.getName()})));
                    }
                    {
                        this.table$1 = table$1;
                        this.tblCols$1 = tblCols$1;
                        this.neededColIds$1 = neededColIds$1;
                    }
                });
            }
            TableStatistics tblStatistic = this.statisticsMap().asMap().containsKey(BoxesRunTime.boxToLong((long)tblId)) ? (TableStatistics)this.statisticsMap().getIfPresent((Object)BoxesRunTime.boxToLong((long)tblId)) : new TableStatistics(tblId);
            this.loadStatsFromStorage(tblId, tblStatistic, table, loadAll, (ArrayBuffer<Object>)((ArrayBuffer)neededColIds.elem));
            return;
        }
        this.logger().warn("Some of the statistics information table are not loaded properly, make sure you have executed analyze table command before these information could be used by TiSpark.");
    }

    public Iterator<Row> readDAGRequest(TiDAGRequest req, long physicalId) {
        return JavaConversions$.MODULE$.asScalaIterator(this.snapshot().tableRead(req, physicalId));
    }

    private void loadStatsFromStorage(long tblId, TableStatistics tblStatistic, TiTableInfo table, boolean loadAll, ArrayBuffer<Object> neededColIds) {
        this.loadMetaToTblStats(tblId, tblStatistic);
        TiDAGRequest req = StatisticsHelper$.MODULE$.buildHistogramsRequest(this.histTable(), tblId, this.session().getTimestamp());
        Iterator<Row> rows = this.readDAGRequest(req, this.histTable().getId());
        if (rows.isEmpty()) {
            return;
        }
        Iterator requests = rows.map((Function1)new Serializable(table, loadAll, neededColIds){
            public static final long serialVersionUID = 0L;
            private final TiTableInfo table$2;
            private final boolean loadAll$1;
            private final ArrayBuffer neededColIds$2;

            public final StatisticsDTO apply(Row x$3) {
                return StatisticsHelper$.MODULE$.extractStatisticsDTO(x$3, this.table$2, this.loadAll$1, (ArrayBuffer<Object>)this.neededColIds$2, StatisticsManager$.MODULE$.histTable());
            }
            {
                this.table$2 = table$2;
                this.loadAll$1 = loadAll$1;
                this.neededColIds$2 = neededColIds$2;
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StatisticsDTO x$4) {
                return x$4 != null;
            }
        });
        Seq<StatisticsResult> results = this.statisticsResultFromStorage(tblId, (Seq<StatisticsDTO>)requests.toSeq());
        results.foreach((Function1)new Serializable(tblStatistic){
            public static final long serialVersionUID = 0L;
            private final TableStatistics tblStatistic$1;

            public final void apply(StatisticsResult x$5) {
                StatisticsManager$.MODULE$.com$pingcap$tispark$statistics$StatisticsManager$$putOrUpdateTblStats(this.tblStatistic$1, x$5);
            }
            {
                this.tblStatistic$1 = tblStatistic$1;
            }
        });
        this.statisticsMap().put((Object)Predef$.MODULE$.long2Long(tblId), (Object)tblStatistic);
    }

    public void com$pingcap$tispark$statistics$StatisticsManager$$putOrUpdateTblStats(TableStatistics tblStatistic, StatisticsResult result) {
        ColumnStatistics oldColSts;
        if (result.hasIdxInfo()) {
            IndexStatistics oldIdxSts = tblStatistic.getIndexHistMap().putIfAbsent(Predef$.MODULE$.long2Long(result.histId()), new IndexStatistics(result.histogram(), result.cMSketch(), result.idxInfo()));
            if (StatisticsHelper$.MODULE$.shouldUpdateHistogram(oldIdxSts, result)) {
                oldIdxSts.setHistogram(result.histogram());
                oldIdxSts.setCmSketch(result.cMSketch());
                oldIdxSts.setIndexInfo(result.idxInfo());
            }
        } else if (result.hasColInfo() && StatisticsHelper$.MODULE$.shouldUpdateHistogram(oldColSts = tblStatistic.getColumnsHistMap().putIfAbsent(Predef$.MODULE$.long2Long(result.histId()), new ColumnStatistics(result.histogram(), result.cMSketch(), (long)result.histogram().totalRowCount(), result.colInfo())), result)) {
            oldColSts.setHistogram(result.histogram());
            oldColSts.setCmSketch(result.cMSketch());
            oldColSts.setColumnInfo(result.colInfo());
        }
    }

    private void loadMetaToTblStats(long tableId, TableStatistics tableStatistics) {
        TiDAGRequest req = StatisticsHelper$.MODULE$.buildMetaRequest(this.metaTable(), tableId, this.session().getTimestamp());
        Iterator<Row> rows = this.readDAGRequest(req, this.metaTable().getId());
        if (rows.isEmpty()) {
            return;
        }
        Row row = (Row)rows.next();
        tableStatistics.setVersion(row.getUnsignedLong(0));
        tableStatistics.setModifyCount(row.getLong(2));
        tableStatistics.setCount(row.getUnsignedLong(3));
    }

    private Seq<StatisticsResult> statisticsResultFromStorage(long tableId, Seq<StatisticsDTO> requests) {
        TiDAGRequest req = StatisticsHelper$.MODULE$.buildBucketRequest(this.bucketTable(), tableId, this.session().getTimestamp());
        Iterator<Row> rows = this.readDAGRequest(req, this.bucketTable().getId());
        if (rows.isEmpty()) {
            return Nil$.MODULE$;
        }
        return ((TraversableOnce)((TraversableLike)rows.toList().groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row x$6) {
                return x$6.getLong(2);
            }
        }).flatMap((Function1)new Serializable(requests){
            public static final long serialVersionUID = 0L;
            private final Seq requests$1;

            public final ArrayOps<StatisticsResult> apply(Tuple2<Object, List<Row>> t) {
                long histId = t._1$mcJ$sp();
                List rowsById = (List)t._2();
                Tuple2 tuple2 = rowsById.partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Row x$7) {
                        return x$7.getLong(1) > 0L;
                    }
                });
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    List idxRows = (List)tuple2._1();
                    List colRows = (List)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)idxRows, (Object)colRows);
                    List idxRows2 = (List)tuple23._1();
                    List colRows2 = (List)tuple23._2();
                    Tuple2 tuple24 = this.requests$1.partition((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(StatisticsDTO x$9) {
                            return x$9.isIndex() > 0;
                        }
                    });
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        Seq idxReq = (Seq)tuple24._1();
                        Seq colReq = (Seq)tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)idxReq, (Object)colReq);
                        Seq idxReq2 = (Seq)tuple26._1();
                        Seq colReq2 = (Seq)tuple26._2();
                        return Predef$.MODULE$.refArrayOps((Object[])new StatisticsResult[]{StatisticsHelper$.MODULE$.extractStatisticResult(histId, (Iterator<Row>)idxRows2.iterator(), (Seq<StatisticsDTO>)idxReq2), StatisticsHelper$.MODULE$.extractStatisticResult(histId, (Iterator<Row>)colRows2.iterator(), (Seq<StatisticsDTO>)colReq2)});
                    }
                    throw new MatchError((Object)tuple24);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.requests$1 = requests$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StatisticsResult x$11) {
                return x$11 != null;
            }
        })).toSeq();
    }

    public TableStatistics getTableStatistics(long id) {
        return (TableStatistics)this.statisticsMap().getIfPresent((Object)BoxesRunTime.boxToLong((long)id));
    }

    public long estimatedRowCount(TiTableInfo table) {
        return this.tableSizeEstimator().estimatedCount(table);
    }

    public long estimateTableSize(TiTableInfo table) {
        return this.tableSizeEstimator().estimatedTableSize(table);
    }

    public void setEstimator(TableSizeEstimator estimator) {
        this.tableSizeEstimator_$eq(estimator);
    }

    public boolean initialized() {
        return this.initialized;
    }

    public void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    public void initialize(TiSession tiSession) {
        this.session_$eq(tiSession);
        this.snapshot_$eq(tiSession.createSnapshot());
        this.catalog_$eq(tiSession.getCatalog());
        this.dbPrefix_$eq(tiSession.getConf().getDBPrefix());
        this.tableSizeEstimator_$eq(DefaultTableSizeEstimator$.MODULE$);
        this.metaTable_$eq(this.catalog().getTable(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "mysql"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dbPrefix()})), "stats_meta"));
        this.histTable_$eq(this.catalog().getTable(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "mysql"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dbPrefix()})), "stats_histograms"));
        this.bucketTable_$eq(this.catalog().getTable(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "mysql"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dbPrefix()})), "stats_buckets"));
        this.statisticsMap().invalidateAll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initStatisticsManager(TiSession tiSession) {
        if (this.initialized()) return;
        StatisticsManager$ statisticsManager$ = this;
        synchronized (statisticsManager$) {
            BoxedUnit boxedUnit;
            if (this.initialized()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.initialize(tiSession);
                this.initialized_$eq(true);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void reset() {
        this.initialized_$eq(false);
    }

    private StatisticsManager$() {
        MODULE$ = this;
        this.statisticsMap = CacheBuilder.newBuilder().build();
        this.initialized = false;
    }
}

