/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tispark.utils;

import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.ExpressionBlacklist;
import com.pingcap.tikv.expression.visitor.MetaResolver;
import com.pingcap.tikv.expression.visitor.SupportedExpressionValidator;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.types.BitType;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tispark.BasicExpression$;
import com.pingcap.tispark.TiConfigConst$;
import com.pingcap.tispark.TiDBRelation;
import com.pingcap.tispark.utils.TiConverter$;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateMode;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Complete$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.PromotedSum$;
import org.apache.spark.sql.catalyst.expressions.aggregate.SpecialSum;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.expressions.aggregate.SumNotNullable$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.aggregate.SortAggregateExec;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.tikv.kvproto.Kvrpcpb;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class TiUtil$ {
    public static final TiUtil$ MODULE$;

    static {
        new TiUtil$();
    }

    public boolean isSupportedAggregate(AggregateExpression aggExpr, TiDBRelation tiDBRelation, ExpressionBlacklist blacklist) {
        SpecialSum specialSum;
        Option<org.apache.spark.sql.catalyst.expressions.Expression> option;
        SpecialSum specialSum2;
        Option<org.apache.spark.sql.catalyst.expressions.Expression> option2;
        AggregateFunction aggregateFunction = aggExpr.aggregateFunction();
        boolean bl = aggregateFunction instanceof Average ? true : (aggregateFunction instanceof Sum ? true : (aggregateFunction instanceof SpecialSum && !(option2 = SumNotNullable$.MODULE$.unapply(specialSum2 = (SpecialSum)aggregateFunction)).isEmpty() ? true : (aggregateFunction instanceof SpecialSum && !(option = PromotedSum$.MODULE$.unapply(specialSum = (SpecialSum)aggregateFunction)).isEmpty() ? true : (aggregateFunction instanceof Count ? true : (aggregateFunction instanceof Min ? true : aggregateFunction instanceof Max)))));
        boolean bl2 = bl ? !aggExpr.isDistinct() && aggExpr.aggregateFunction().children().forall((Function1)new Serializable(tiDBRelation, blacklist){
            public static final long serialVersionUID = 0L;
            private final TiDBRelation tiDBRelation$1;
            private final ExpressionBlacklist blacklist$1;

            public final boolean apply(org.apache.spark.sql.catalyst.expressions.Expression x$1) {
                return TiUtil$.MODULE$.isSupportedBasicExpression(x$1, this.tiDBRelation$1, this.blacklist$1);
            }
            {
                this.tiDBRelation$1 = tiDBRelation$1;
                this.blacklist$1 = blacklist$1;
            }
        }) : false;
        return bl2;
    }

    public boolean isSupportedBasicExpression(org.apache.spark.sql.catalyst.expressions.Expression expr, TiDBRelation tiDBRelation, ExpressionBlacklist blacklist) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            boolean bl;
            Object object = new Object();
            try {
                if (!BasicExpression$.MODULE$.isSupportedExpression(expr, RegionStoreClient.RequestTypes.REQ_TYPE_DAG)) {
                    return false;
                }
                bl = BoxesRunTime.unboxToBoolean((Object)BasicExpression$.MODULE$.convertToTiExpr(expr).fold((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                }, (Function1)new Serializable(tiDBRelation, blacklist, object){
                    public static final long serialVersionUID = 0L;
                    private final TiDBRelation tiDBRelation$2;
                    private final ExpressionBlacklist blacklist$2;
                    private final Object nonLocalReturnKey1$1;

                    public final Nothing$ apply(Expression expr) {
                        MetaResolver.resolve((Expression)expr, (TiTableInfo)this.tiDBRelation$2.table());
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, SupportedExpressionValidator.isSupportedExpression((Expression)expr, (ExpressionBlacklist)this.blacklist$2));
                    }
                    {
                        this.tiDBRelation$2 = tiDBRelation$2;
                        this.blacklist$2 = blacklist$2;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                }));
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public boolean isPushDownSupported(org.apache.spark.sql.catalyst.expressions.Expression expr, TiDBRelation source) {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            boolean bl;
            Object object = new Object();
            try {
                HashMap nameTypeMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                JavaConversions$.MODULE$.asScalaBuffer(source.table().getColumns()).foreach((Function1)new Serializable(nameTypeMap){
                    public static final long serialVersionUID = 0L;
                    private final HashMap nameTypeMap$1;

                    public final void apply(TiColumnInfo info) {
                        this.nameTypeMap$1.update((Object)info.getName(), (Object)info.getType());
                    }
                    {
                        this.nameTypeMap$1 = nameTypeMap$1;
                    }
                });
                if (expr.children().isEmpty()) {
                    AttributeReference attributeReference;
                    org.apache.spark.sql.catalyst.expressions.Expression expression = expr;
                    if (expression instanceof AttributeReference && nameTypeMap.contains((Object)(attributeReference = (AttributeReference)expression).name())) {
                        DataType head = (DataType)Option$.MODULE$.option2Iterable(nameTypeMap.get((Object)attributeReference.name())).head();
                        return !(head instanceof BitType);
                    }
                    if (expression instanceof Literal) {
                        Literal literal = (Literal)expression;
                        return literal.value() != null;
                    }
                    return true;
                }
                expr.children().foreach((Function1)new Serializable(source, object){
                    public static final long serialVersionUID = 0L;
                    private final TiDBRelation source$1;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(org.apache.spark.sql.catalyst.expressions.Expression expr) {
                        if (TiUtil$.MODULE$.isPushDownSupported(expr, this.source$1)) {
                            return;
                        }
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey2$1, false);
                    }
                    {
                        this.source$1 = source$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public boolean isSupportedFilter(org.apache.spark.sql.catalyst.expressions.Expression expr, TiDBRelation source, ExpressionBlacklist blacklist) {
        return this.isSupportedBasicExpression(expr, source, blacklist) && this.isPushDownSupported(expr, source);
    }

    public boolean isSupportedGroupingExpr(NamedExpression expr, TiDBRelation source, ExpressionBlacklist blacklist) {
        return this.isSupportedBasicExpression((org.apache.spark.sql.catalyst.expressions.Expression)expr, source, blacklist) && this.isPushDownSupported((org.apache.spark.sql.catalyst.expressions.Expression)expr, source);
    }

    public StructType getSchemaFromTable(TiTableInfo table) {
        StructField[] fields = new StructField[table.getColumns().size()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), table.getColumns().size()).foreach$mVc$sp((Function1)new Serializable(table, fields){
            public static final long serialVersionUID = 0L;
            private final TiTableInfo table$1;
            private final StructField[] fields$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TiColumnInfo col = (TiColumnInfo)this.table$1.getColumns().get(i);
                boolean notNull = col.getType().isNotNull();
                Metadata metadata = new MetadataBuilder().putString("name", col.getName()).build();
                this.fields$1[i] = new StructField(col.getName(), TiConverter$.MODULE$.toSparkDataType(col.getType()), !notNull, metadata);
            }
            {
                this.table$1 = table$1;
                this.fields$1 = fields$1;
            }
        });
        return new StructType(fields);
    }

    /*
     * WARNING - void declaration
     */
    public TiConfiguration sparkConfToTiConf(SparkConf conf) {
        void var2_2;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        TiConfiguration tiConf = TiConfiguration.createDefault((String)conf.get(TiConfigConst$.MODULE$.PD_ADDRESSES()));
        Object object = conf.contains(TiConfigConst$.MODULE$.GRPC_FRAME_SIZE()) ? tiConf.setMaxFrameSize(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.GRPC_FRAME_SIZE()))).toInt()) : BoxedUnit.UNIT;
        if (conf.contains(TiConfigConst$.MODULE$.GRPC_TIMEOUT())) {
            tiConf.setTimeout(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.GRPC_TIMEOUT()))).toInt());
            boxedUnit2 = tiConf.setTimeoutUnit(TimeUnit.SECONDS);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (conf.contains(TiConfigConst$.MODULE$.META_RELOAD_PERIOD())) {
            tiConf.setMetaReloadPeriod(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.META_RELOAD_PERIOD()))).toInt());
            boxedUnit = tiConf.setMetaReloadPeriodUnit(TimeUnit.SECONDS);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (conf.contains(TiConfigConst$.MODULE$.INDEX_SCAN_BATCH_SIZE())) {
            tiConf.setIndexScanBatchSize(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.INDEX_SCAN_BATCH_SIZE()))).toInt());
        }
        if (conf.contains(TiConfigConst$.MODULE$.INDEX_SCAN_CONCURRENCY())) {
            tiConf.setIndexScanConcurrency(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.INDEX_SCAN_CONCURRENCY()))).toInt());
        }
        if (conf.contains(TiConfigConst$.MODULE$.TABLE_SCAN_CONCURRENCY())) {
            tiConf.setTableScanConcurrency(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.TABLE_SCAN_CONCURRENCY()))).toInt());
        }
        if (conf.contains(TiConfigConst$.MODULE$.REQUEST_ISOLATION_LEVEL())) {
            String isolationLevel = conf.get(TiConfigConst$.MODULE$.REQUEST_ISOLATION_LEVEL());
            if (isolationLevel.equals(TiConfigConst$.MODULE$.SNAPSHOT_ISOLATION_LEVEL())) {
                tiConf.setIsolationLevel(Kvrpcpb.IsolationLevel.SI);
            } else {
                tiConf.setIsolationLevel(Kvrpcpb.IsolationLevel.RC);
            }
        }
        if (conf.contains(TiConfigConst$.MODULE$.REQUEST_COMMAND_PRIORITY())) {
            Kvrpcpb.CommandPri priority = Kvrpcpb.CommandPri.valueOf((String)conf.get(TiConfigConst$.MODULE$.REQUEST_COMMAND_PRIORITY()));
            tiConf.setCommandPriority(priority);
        }
        if (conf.contains(TiConfigConst$.MODULE$.SHOW_ROWID())) {
            tiConf.setShowRowId(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.SHOW_ROWID()))).toBoolean());
        }
        if (conf.contains(TiConfigConst$.MODULE$.DB_PREFIX())) {
            tiConf.setDBPrefix(conf.get(TiConfigConst$.MODULE$.DB_PREFIX()));
        }
        if (conf.contains(TiConfigConst$.MODULE$.WRITE_ENABLE())) {
            tiConf.setWriteEnable(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.WRITE_ENABLE()))).toBoolean());
        }
        if (conf.contains(TiConfigConst$.MODULE$.WRITE_WITHOUT_LOCK_TABLE())) {
            tiConf.setWriteWithoutLockTable(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.WRITE_WITHOUT_LOCK_TABLE()))).toBoolean());
        }
        if (conf.contains(TiConfigConst$.MODULE$.WRITE_ALLOW_SPARK_SQL())) {
            tiConf.setWriteAllowSparkSQL(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.WRITE_ALLOW_SPARK_SQL()))).toBoolean());
        }
        if (conf.contains(TiConfigConst$.MODULE$.TIKV_REGION_SPLIT_SIZE_IN_MB())) {
            tiConf.setTikvRegionSplitSizeInMB(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.TIKV_REGION_SPLIT_SIZE_IN_MB()))).toInt());
        }
        return var2_2;
    }

    public String getReqEstCountStr(TiDAGRequest req) {
        String string;
        if (req.getEstimatedCount() > 0.0) {
            DecimalFormat df = new DecimalFormat("#.#");
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" EstimatedCount:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.format(req.getEstimatedCount())}));
        } else {
            string = "";
        }
        return string;
    }

    public SparkPlan planAggregateWithoutPartial(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        Seq completeAggregateExpressions = (Seq)aggregateExpressions.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AggregateExpression apply(AggregateExpression x$2) {
                Complete$ x$4 = Complete$.MODULE$;
                AggregateFunction x$5 = x$2.copy$default$1();
                boolean x$6 = x$2.copy$default$3();
                ExprId x$7 = x$2.copy$default$4();
                return x$2.copy(x$5, (AggregateMode)x$4, x$6, x$7);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq completeAggregateAttributes = (Seq)completeAggregateExpressions.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Attribute apply(AggregateExpression x$3) {
                return x$3.resultAttribute();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new SortAggregateExec((Option)new Some(groupingExpressions), groupingExpressions, completeAggregateExpressions, completeAggregateAttributes, 0, resultExpressions, child);
    }

    private TiUtil$() {
        MODULE$ = this;
    }
}

