/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LDAPExtendedOperationException
extends LDAPException {
    private static final long serialVersionUID = -5674215690199642408L;
    private final ExtendedResult extendedResult;

    public LDAPExtendedOperationException(ExtendedResult extendedResult) {
        super(extendedResult);
        this.extendedResult = extendedResult;
    }

    @Override
    public LDAPResult toLDAPResult() {
        return this.extendedResult;
    }

    public ExtendedResult getExtendedResult() {
        return this.extendedResult;
    }

    public String getResponseOID() {
        return this.extendedResult.getOID();
    }

    public ASN1OctetString getResponseValue() {
        return this.extendedResult.getValue();
    }

    @Override
    public void toString(StringBuilder buffer) {
        super.toString(buffer);
    }

    @Override
    public void toString(StringBuilder buffer, boolean includeCause, boolean includeStackTrace) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String responseName;
        String responseOID;
        buffer.append("LDAPException(resultCode=");
        buffer.append(this.getResultCode());
        String errorMessage = this.getMessage();
        String diagnosticMessage = this.getDiagnosticMessage();
        if (errorMessage != null && !errorMessage.equals(diagnosticMessage)) {
            buffer.append(", errorMessage='");
            buffer.append(errorMessage);
            buffer.append('\'');
        }
        if ((responseOID = this.getResponseOID()) != null) {
            buffer.append(", responseOID='");
            buffer.append(responseOID);
            buffer.append('\'');
        }
        if ((responseName = this.extendedResult.getExtendedResultName()) != null && !responseName.equals(responseOID)) {
            buffer.append(", responseName='");
            buffer.append(responseName);
            buffer.append('\'');
        }
        if (diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        if (includeStackTrace) {
            buffer.append(", trace='");
            StaticUtils.getStackTrace(this.getStackTrace(), buffer);
            buffer.append('\'');
        }
        String ldapSDKVersionString = ", ldapSDKVersion=4.0.5, revision=27420";
        if (buffer.indexOf(", ldapSDKVersion=4.0.5, revision=27420") < 0) {
            buffer.append(", ldapSDKVersion=4.0.5, revision=27420");
        }
        buffer.append(')');
    }
}

