/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.SRVRecord;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadLocalRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class SRVRecordPrioritySet
implements Serializable {
    private static final long serialVersionUID = -7722028520625558942L;
    private final long priority;
    private final long totalWeight;
    private final List<SRVRecord> allRecords;
    private final List<SRVRecord> nonzeroWeightRecords;
    private final List<SRVRecord> zeroWeightRecords;

    SRVRecordPrioritySet(long priority, List<SRVRecord> records) {
        this.priority = priority;
        long w = 0L;
        ArrayList<SRVRecord> nRecords = new ArrayList<SRVRecord>(records.size());
        ArrayList<SRVRecord> zRecords = new ArrayList<SRVRecord>(records.size());
        for (SRVRecord r : records) {
            if (r.getWeight() == 0L) {
                zRecords.add(r);
                continue;
            }
            nRecords.add(r);
            w += r.getWeight();
        }
        this.totalWeight = w;
        this.allRecords = Collections.unmodifiableList(records);
        this.nonzeroWeightRecords = Collections.unmodifiableList(nRecords);
        this.zeroWeightRecords = Collections.unmodifiableList(zRecords);
    }

    long getPriority() {
        return this.priority;
    }

    List<SRVRecord> getOrderedRecords() {
        ArrayList<SRVRecord> records = new ArrayList<SRVRecord>(this.allRecords.size());
        if (!this.nonzeroWeightRecords.isEmpty()) {
            if (this.nonzeroWeightRecords.size() == 1) {
                records.addAll(this.nonzeroWeightRecords);
            } else {
                Random r = ThreadLocalRandom.get();
                long tw = this.totalWeight;
                ArrayList<SRVRecord> rl = new ArrayList<SRVRecord>(this.nonzeroWeightRecords);
                block0: while (!rl.isEmpty()) {
                    long w = (r.nextLong() & Long.MAX_VALUE) % tw;
                    Iterator<SRVRecord> iterator = rl.iterator();
                    while (iterator.hasNext()) {
                        SRVRecord record = iterator.next();
                        if (w < record.getWeight() || !iterator.hasNext()) {
                            iterator.remove();
                            records.add(record);
                            tw -= record.getWeight();
                            continue block0;
                        }
                        w -= record.getWeight();
                    }
                }
            }
        }
        records.addAll(this.zeroWeightRecords);
        return records;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    void toString(StringBuilder buffer) {
        buffer.append("SRVRecordPrioritySet(records={");
        Iterator<SRVRecord> iterator = this.allRecords.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

