/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import me.ahoo.cosid.Decorator;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.stat.Stat;
import me.ahoo.cosid.stat.converter.DatePrefixConverterStat;

public class DatePrefixIdConverter
implements IdConverter,
Decorator<IdConverter> {
    private final String pattern;
    private final DateTimeFormatter formatter;
    private final String delimiter;
    private final IdConverter actual;

    public DatePrefixIdConverter(String pattern, String delimiter, IdConverter actual) {
        this.pattern = pattern;
        this.formatter = DateTimeFormatter.ofPattern(pattern);
        this.delimiter = delimiter;
        this.actual = actual;
    }

    @Override
    @Nonnull
    public String asString(long id) {
        return LocalDateTime.now().format(this.formatter) + this.delimiter + this.actual.asString(id);
    }

    @Override
    public long asLong(@Nonnull String idString) {
        int appendedLength = this.pattern.length() + this.delimiter.length();
        String idStr = idString.substring(appendedLength);
        return this.actual.asLong(idStr);
    }

    @Override
    @Nonnull
    public IdConverter getActual() {
        return this.actual;
    }

    @Override
    public Stat stat() {
        return new DatePrefixConverterStat(this.getClass().getSimpleName(), this.pattern, this.actual.stat());
    }
}

