/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.cosid;

import jakarta.annotation.Nonnull;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.cosid.CosIdIdStateParser;
import me.ahoo.cosid.cosid.CosIdState;
import me.ahoo.cosid.stat.Stat;
import me.ahoo.cosid.stat.generator.CosIdGeneratorStat;
import me.ahoo.cosid.stat.generator.IdGeneratorStat;

public interface CosIdGenerator
extends IdGenerator {
    public int getMachineId();

    public long getLastTimestamp();

    @Nonnull
    public CosIdIdStateParser getStateParser();

    @Override
    @Nonnull
    default public IdConverter idConverter() {
        throw new UnsupportedOperationException("CosIdGenerator does not support IdConverter,please use CosIdIdStateParser instead!");
    }

    @Override
    default public long generate() {
        throw new UnsupportedOperationException("CosIdGenerator does not support the generation of long IDs!");
    }

    @Nonnull
    public CosIdState generateAsState();

    @Override
    @Nonnull
    default public String generateAsString() {
        return this.getStateParser().asString(this.generateAsState());
    }

    @Override
    default public IdGeneratorStat stat() {
        return new CosIdGeneratorStat(this.getClass().getSimpleName(), this.getMachineId(), this.getLastTimestamp(), Stat.simple(this.getStateParser().getClass().getSimpleName()));
    }
}

