/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.machine;

import com.google.common.base.Strings;
import com.google.errorprone.annotations.ThreadSafe;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdLostException;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.machine.MachineState;
import me.ahoo.cosid.machine.NotFoundMachineStateException;

@ThreadSafe
public interface MachineIdDistributor {
    public static final Duration FOREVER_SAFE_GUARD_DURATION = Duration.ofMillis(Long.MAX_VALUE);

    public static int maxMachineId(int machineBit) {
        return ~(-1 << machineBit);
    }

    public static int totalMachineIds(int machineBit) {
        return MachineIdDistributor.maxMachineId(machineBit) + 1;
    }

    public static String namespacedMachineId(String namespace, int machineId) {
        return namespace + "." + Strings.padStart((String)String.valueOf(machineId), (int)8, (char)'0');
    }

    public static long getSafeGuardAt(Duration safeGuardDuration, boolean stable) {
        if (stable) {
            return 0L;
        }
        if (FOREVER_SAFE_GUARD_DURATION.equals(safeGuardDuration)) {
            return 0L;
        }
        long safeGuardAt = System.currentTimeMillis() - safeGuardDuration.toMillis();
        if (safeGuardAt < 0L) {
            return 0L;
        }
        return safeGuardAt;
    }

    @Nonnull
    public MachineState distribute(String var1, int var2, InstanceId var3, Duration var4) throws MachineIdOverflowException;

    public void revert(String var1, InstanceId var2) throws NotFoundMachineStateException;

    public void guard(String var1, InstanceId var2, Duration var3) throws NotFoundMachineStateException, MachineIdLostException;
}

