/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment.grouped;

import jakarta.annotation.Nonnull;
import me.ahoo.cosid.segment.IdSegment;
import me.ahoo.cosid.segment.IdSegmentChain;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributorDefinition;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import me.ahoo.cosid.segment.grouped.GroupBySupplier;
import me.ahoo.cosid.segment.grouped.GroupedIdSegmentDistributor;
import me.ahoo.cosid.segment.grouped.GroupedKey;

public class DefaultGroupedIdSegmentDistributor
implements GroupedIdSegmentDistributor {
    private final GroupBySupplier groupBySupplier;
    private final IdSegmentDistributorDefinition idSegmentDistributorDefinition;
    private final IdSegmentDistributorFactory idSegmentDistributorFactory;
    private volatile GroupedBinding currentGroup;

    public DefaultGroupedIdSegmentDistributor(GroupBySupplier groupBySupplier, IdSegmentDistributorDefinition idSegmentDistributorDefinition, IdSegmentDistributorFactory idSegmentDistributorFactory) {
        this.groupBySupplier = groupBySupplier;
        this.idSegmentDistributorDefinition = idSegmentDistributorDefinition;
        this.idSegmentDistributorFactory = idSegmentDistributorFactory;
        this.ensureGroupedBinding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupedBinding ensureGroupedBinding() {
        GroupedKey groupedKey = (GroupedKey)this.groupBySupplier.get();
        if (this.currentGroup != null && this.currentGroup.group().equals(groupedKey)) {
            return this.currentGroup;
        }
        DefaultGroupedIdSegmentDistributor defaultGroupedIdSegmentDistributor = this;
        synchronized (defaultGroupedIdSegmentDistributor) {
            if (this.currentGroup != null && this.currentGroup.group().equals(groupedKey)) {
                return this.currentGroup;
            }
            String groupedName = this.idSegmentDistributorDefinition.getName() + "@" + groupedKey.getKey();
            IdSegmentDistributorDefinition groupedDef = new IdSegmentDistributorDefinition(this.idSegmentDistributorDefinition.getNamespace(), groupedName, this.idSegmentDistributorDefinition.getOffset(), this.idSegmentDistributorDefinition.getStep());
            this.currentGroup = new GroupedBinding(groupedKey, this.idSegmentDistributorFactory.create(groupedDef));
        }
        return this.currentGroup;
    }

    public GroupBySupplier groupBySupplier() {
        return this.groupBySupplier;
    }

    @Override
    @Nonnull
    public String getNamespace() {
        return this.idSegmentDistributorDefinition.getNamespace();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.idSegmentDistributorDefinition.getName();
    }

    @Override
    public long getStep() {
        return this.idSegmentDistributorDefinition.getStep();
    }

    @Override
    public GroupedKey group() {
        return this.ensureGroupedBinding().group();
    }

    @Override
    public long nextMaxId() {
        return this.ensureGroupedBinding().nextMaxId();
    }

    @Override
    public long nextMaxId(long step) {
        return this.ensureGroupedBinding().nextMaxId(step);
    }

    @Override
    @Nonnull
    public IdSegment nextIdSegment() {
        return this.ensureGroupedBinding().nextIdSegment();
    }

    @Override
    @Nonnull
    public IdSegment nextIdSegment(long ttl) {
        return this.ensureGroupedBinding().nextIdSegment(ttl);
    }

    @Override
    @Nonnull
    public IdSegment nextIdSegment(int segments, long ttl) {
        return this.ensureGroupedBinding().nextIdSegment(segments, ttl);
    }

    @Override
    @Nonnull
    public IdSegmentChain nextIdSegmentChain(IdSegmentChain previousChain, int segments, long ttl) {
        return this.ensureGroupedBinding().nextIdSegmentChain(previousChain, segments, ttl);
    }

    @Override
    @Nonnull
    public IdSegmentChain nextIdSegmentChain(IdSegmentChain previousChain) {
        return this.ensureGroupedBinding().nextIdSegmentChain(previousChain);
    }

    public static class GroupedBinding
    implements GroupedIdSegmentDistributor {
        private final GroupedKey group;
        private final IdSegmentDistributor idSegmentDistributor;

        public GroupedBinding(GroupedKey group, IdSegmentDistributor idSegmentDistributor) {
            this.group = group;
            this.idSegmentDistributor = idSegmentDistributor;
        }

        @Override
        public GroupedKey group() {
            return this.group;
        }

        @Override
        @Nonnull
        public String getNamespace() {
            return this.idSegmentDistributor.getNamespace();
        }

        @Override
        @Nonnull
        public String getName() {
            return this.idSegmentDistributor.getName();
        }

        @Override
        public long getStep() {
            return this.idSegmentDistributor.getStep();
        }

        @Override
        public long nextMaxId(long step) {
            return this.idSegmentDistributor.nextMaxId(step);
        }

        private long getMinTtl(long ttl) {
            long groupedTtl = this.group.ttl();
            return Math.min(groupedTtl, ttl);
        }

        @Override
        @Nonnull
        public IdSegment nextIdSegment(long ttl) {
            long minTtl = this.getMinTtl(ttl);
            return GroupedIdSegmentDistributor.super.nextIdSegment(minTtl);
        }

        @Override
        @Nonnull
        public IdSegment nextIdSegment(int segments, long ttl) {
            long minTtl = this.getMinTtl(ttl);
            return GroupedIdSegmentDistributor.super.nextIdSegment(segments, minTtl);
        }

        @Override
        @Nonnull
        public IdSegmentChain nextIdSegmentChain(IdSegmentChain previousChain, int segments, long ttl) {
            long minTtl = this.getMinTtl(ttl);
            return GroupedIdSegmentDistributor.super.nextIdSegmentChain(previousChain, segments, minTtl);
        }
    }
}

