/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment.grouped;

import com.google.errorprone.annotations.ThreadSafe;
import jakarta.annotation.Nullable;
import java.util.Objects;
import me.ahoo.cosid.segment.grouped.GroupedKey;

@ThreadSafe
public final class GroupedAccessor {
    private static final ThreadLocal<GroupedKey> CURRENT = new ThreadLocal();

    public static void set(GroupedKey groupedKey) {
        CURRENT.set(groupedKey);
    }

    public static void setIfNotNever(GroupedKey groupedKey) {
        if (GroupedKey.NEVER.equals(groupedKey)) {
            return;
        }
        GroupedAccessor.set(groupedKey);
    }

    @Nullable
    public static GroupedKey get() {
        return CURRENT.get();
    }

    public static GroupedKey requiredGet() {
        return Objects.requireNonNull(GroupedAccessor.get(), "The current thread has not set the GroupedKey.");
    }

    public static void clear() {
        CURRENT.remove();
    }
}

