/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.sharding;

import com.google.errorprone.annotations.Immutable;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

@Immutable
public class IntervalStep {
    public static final int DEFAULT_AMOUNT = 1;
    private final ChronoUnit unit;
    private final int amount;

    public IntervalStep(ChronoUnit unit, int amount) {
        this.unit = unit;
        this.amount = amount;
    }

    public ChronoUnit getUnit() {
        return this.unit;
    }

    public int getAmount() {
        return this.amount;
    }

    public LocalDateTime next(LocalDateTime previous) {
        return previous.plus(this.amount, this.unit);
    }

    public LocalDateTime floorUnit(LocalDateTime time) {
        switch (this.unit) {
            case YEARS: {
                return LocalDateTime.of(time.getYear(), 1, 1, 0, 0);
            }
            case MONTHS: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), 1, 0, 0);
            }
            case DAYS: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), 0, 0);
            }
            case HOURS: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), 0);
            }
            case MINUTES: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute());
            }
            case SECONDS: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(this.unit));
    }

    public int offsetUnit(LocalDateTime start, LocalDateTime time) {
        return (int)(start.until(time, this.unit) / (long)this.amount);
    }

    public static IntervalStep of(ChronoUnit unit) {
        return new IntervalStep(unit, 1);
    }

    public static IntervalStep of(ChronoUnit unit, int amount) {
        return new IntervalStep(unit, amount);
    }
}

