/*
 * Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 2.0, as published by the
 * Free Software Foundation.
 *
 * This program is also distributed with certain software (including but not
 * limited to OpenSSL) that is licensed under separate terms, as designated in a
 * particular file or component or in included license documentation. The
 * authors of MySQL hereby grant you an additional permission to link the
 * program and your derivative works with the separately licensed software that
 * they have included with MySQL.
 *
 * Without limiting anything contained in the foregoing, this file, which is
 * part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0,
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_expr.proto

public final class MysqlxExpr {
  private MysqlxExpr() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface ExprOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Expr)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
     */
    boolean hasType();
    /**
     * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type getType();

    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     */
    boolean hasIdentifier();
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getIdentifier();
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder getIdentifierOrBuilder();

    /**
     * <code>optional string variable = 3;</code>
     */
    boolean hasVariable();
    /**
     * <code>optional string variable = 3;</code>
     */
    java.lang.String getVariable();
    /**
     * <code>optional string variable = 3;</code>
     */
    com.google.protobuf.ByteString
        getVariableBytes();

    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     */
    boolean hasLiteral();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getLiteral();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getLiteralOrBuilder();

    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     */
    boolean hasFunctionCall();
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getFunctionCall();
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder getFunctionCallOrBuilder();

    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     */
    boolean hasOperator();
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Operator getOperator();
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder getOperatorOrBuilder();

    /**
     * <code>optional uint32 position = 7;</code>
     */
    boolean hasPosition();
    /**
     * <code>optional uint32 position = 7;</code>
     */
    int getPosition();

    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     */
    boolean hasObject();
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Object getObject();
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder getObjectOrBuilder();

    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     */
    boolean hasArray();
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Array getArray();
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder getArrayOrBuilder();
  }
  /**
   * Protobuf type {@code Mysqlx.Expr.Expr}
   *
   * <pre>
   * Expressions
   * the "root" of the expression tree
   * .. productionlist::
   *   expr: `operator` |
   *       : `identifier` |
   *       : `function_call` |
   *       : variable |
   *       : `literal` |
   *       : placeholder
   * If expression type is PLACEHOLDER then it refers to the value of a parameter
   * specified when executing a statement (see `args` field of `StmtExecute` command).
   * Field `position` (which must be present for such an expression) gives 0-based
   * position of the parameter in the parameter list.
   * </pre>
   */
  public static final class Expr extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Expr)
      ExprOrBuilder {
    // Use Expr.newBuilder() to construct.
    private Expr(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Expr(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Expr defaultInstance;
    public static Expr getDefaultInstance() {
      return defaultInstance;
    }

    public Expr getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Expr(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type value = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                type_ = value;
              }
              break;
            }
            case 18: {
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = identifier_.toBuilder();
              }
              identifier_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(identifier_);
                identifier_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              variable_ = bs;
              break;
            }
            case 34: {
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = literal_.toBuilder();
              }
              literal_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(literal_);
                literal_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
            case 42: {
              com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) == 0x00000010)) {
                subBuilder = functionCall_.toBuilder();
              }
              functionCall_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(functionCall_);
                functionCall_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 50: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder subBuilder = null;
              if (((bitField0_ & 0x00000020) == 0x00000020)) {
                subBuilder = operator_.toBuilder();
              }
              operator_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Operator.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(operator_);
                operator_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000020;
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              position_ = input.readUInt32();
              break;
            }
            case 66: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder subBuilder = null;
              if (((bitField0_ & 0x00000080) == 0x00000080)) {
                subBuilder = object_.toBuilder();
              }
              object_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Object.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(object_);
                object_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000080;
              break;
            }
            case 74: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder subBuilder = null;
              if (((bitField0_ & 0x00000100) == 0x00000100)) {
                subBuilder = array_.toBuilder();
              }
              array_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Array.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(array_);
                array_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000100;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.class, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder.class);
    }

    public static com.google.protobuf.Parser<Expr> PARSER =
        new com.google.protobuf.AbstractParser<Expr>() {
      public Expr parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Expr(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Expr> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Expr.Expr.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>IDENT = 1;</code>
       */
      IDENT(0, 1),
      /**
       * <code>LITERAL = 2;</code>
       */
      LITERAL(1, 2),
      /**
       * <code>VARIABLE = 3;</code>
       */
      VARIABLE(2, 3),
      /**
       * <code>FUNC_CALL = 4;</code>
       */
      FUNC_CALL(3, 4),
      /**
       * <code>OPERATOR = 5;</code>
       */
      OPERATOR(4, 5),
      /**
       * <code>PLACEHOLDER = 6;</code>
       */
      PLACEHOLDER(5, 6),
      /**
       * <code>OBJECT = 7;</code>
       */
      OBJECT(6, 7),
      /**
       * <code>ARRAY = 8;</code>
       */
      ARRAY(7, 8),
      ;

      /**
       * <code>IDENT = 1;</code>
       */
      public static final int IDENT_VALUE = 1;
      /**
       * <code>LITERAL = 2;</code>
       */
      public static final int LITERAL_VALUE = 2;
      /**
       * <code>VARIABLE = 3;</code>
       */
      public static final int VARIABLE_VALUE = 3;
      /**
       * <code>FUNC_CALL = 4;</code>
       */
      public static final int FUNC_CALL_VALUE = 4;
      /**
       * <code>OPERATOR = 5;</code>
       */
      public static final int OPERATOR_VALUE = 5;
      /**
       * <code>PLACEHOLDER = 6;</code>
       */
      public static final int PLACEHOLDER_VALUE = 6;
      /**
       * <code>OBJECT = 7;</code>
       */
      public static final int OBJECT_VALUE = 7;
      /**
       * <code>ARRAY = 8;</code>
       */
      public static final int ARRAY_VALUE = 8;


      public final int getNumber() { return value; }

      public static Type valueOf(int value) {
        switch (value) {
          case 1: return IDENT;
          case 2: return LITERAL;
          case 3: return VARIABLE;
          case 4: return FUNC_CALL;
          case 5: return OPERATOR;
          case 6: return PLACEHOLDER;
          case 7: return OBJECT;
          case 8: return ARRAY;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Type(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Expr.Expr.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type type_;
    /**
     * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type getType() {
      return type_;
    }

    public static final int IDENTIFIER_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier identifier_;
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     */
    public boolean hasIdentifier() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getIdentifier() {
      return identifier_;
    }
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder getIdentifierOrBuilder() {
      return identifier_;
    }

    public static final int VARIABLE_FIELD_NUMBER = 3;
    private java.lang.Object variable_;
    /**
     * <code>optional string variable = 3;</code>
     */
    public boolean hasVariable() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string variable = 3;</code>
     */
    public java.lang.String getVariable() {
      java.lang.Object ref = variable_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          variable_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string variable = 3;</code>
     */
    public com.google.protobuf.ByteString
        getVariableBytes() {
      java.lang.Object ref = variable_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        variable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LITERAL_FIELD_NUMBER = 4;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar literal_;
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     */
    public boolean hasLiteral() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getLiteral() {
      return literal_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getLiteralOrBuilder() {
      return literal_;
    }

    public static final int FUNCTION_CALL_FIELD_NUMBER = 5;
    private com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall functionCall_;
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     */
    public boolean hasFunctionCall() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getFunctionCall() {
      return functionCall_;
    }
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder getFunctionCallOrBuilder() {
      return functionCall_;
    }

    public static final int OPERATOR_FIELD_NUMBER = 6;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Operator operator_;
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     */
    public boolean hasOperator() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Operator getOperator() {
      return operator_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder getOperatorOrBuilder() {
      return operator_;
    }

    public static final int POSITION_FIELD_NUMBER = 7;
    private int position_;
    /**
     * <code>optional uint32 position = 7;</code>
     */
    public boolean hasPosition() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional uint32 position = 7;</code>
     */
    public int getPosition() {
      return position_;
    }

    public static final int OBJECT_FIELD_NUMBER = 8;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Object object_;
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     */
    public boolean hasObject() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Object getObject() {
      return object_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder getObjectOrBuilder() {
      return object_;
    }

    public static final int ARRAY_FIELD_NUMBER = 9;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Array array_;
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     */
    public boolean hasArray() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Array getArray() {
      return array_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder getArrayOrBuilder() {
      return array_;
    }

    private void initFields() {
      type_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.IDENT;
      identifier_ = com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
      variable_ = "";
      literal_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
      functionCall_ = com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance();
      operator_ = com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance();
      position_ = 0;
      object_ = com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance();
      array_ = com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasIdentifier()) {
        if (!getIdentifier().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasLiteral()) {
        if (!getLiteral().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasFunctionCall()) {
        if (!getFunctionCall().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasOperator()) {
        if (!getOperator().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasObject()) {
        if (!getObject().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasArray()) {
        if (!getArray().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, identifier_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getVariableBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(4, literal_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeMessage(5, functionCall_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeMessage(6, operator_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeUInt32(7, position_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeMessage(8, object_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeMessage(9, array_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, identifier_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getVariableBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, literal_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, functionCall_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, operator_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(7, position_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, object_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, array_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Expr prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.Expr}
     *
     * <pre>
     * Expressions
     * the "root" of the expression tree
     * .. productionlist::
     *   expr: `operator` |
     *       : `identifier` |
     *       : `function_call` |
     *       : variable |
     *       : `literal` |
     *       : placeholder
     * If expression type is PLACEHOLDER then it refers to the value of a parameter
     * specified when executing a statement (see `args` field of `StmtExecute` command).
     * Field `position` (which must be present for such an expression) gives 0-based
     * position of the parameter in the parameter list.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Expr)
        com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr.class, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getIdentifierFieldBuilder();
          getLiteralFieldBuilder();
          getFunctionCallFieldBuilder();
          getOperatorFieldBuilder();
          getObjectFieldBuilder();
          getArrayFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        type_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.IDENT;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (identifierBuilder_ == null) {
          identifier_ = com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
        } else {
          identifierBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        variable_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        if (literalBuilder_ == null) {
          literal_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
        } else {
          literalBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (functionCallBuilder_ == null) {
          functionCall_ = com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance();
        } else {
          functionCallBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        if (operatorBuilder_ == null) {
          operator_ = com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance();
        } else {
          operatorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        position_ = 0;
        bitField0_ = (bitField0_ & ~0x00000040);
        if (objectBuilder_ == null) {
          object_ = com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance();
        } else {
          objectBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        if (arrayBuilder_ == null) {
          array_ = com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance();
        } else {
          arrayBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Expr result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Expr result = new com.mysql.cj.x.protobuf.MysqlxExpr.Expr(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (identifierBuilder_ == null) {
          result.identifier_ = identifier_;
        } else {
          result.identifier_ = identifierBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.variable_ = variable_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (literalBuilder_ == null) {
          result.literal_ = literal_;
        } else {
          result.literal_ = literalBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        if (functionCallBuilder_ == null) {
          result.functionCall_ = functionCall_;
        } else {
          result.functionCall_ = functionCallBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        if (operatorBuilder_ == null) {
          result.operator_ = operator_;
        } else {
          result.operator_ = operatorBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.position_ = position_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        if (objectBuilder_ == null) {
          result.object_ = object_;
        } else {
          result.object_ = objectBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        if (arrayBuilder_ == null) {
          result.array_ = array_;
        } else {
          result.array_ = arrayBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Expr) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Expr)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Expr other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasIdentifier()) {
          mergeIdentifier(other.getIdentifier());
        }
        if (other.hasVariable()) {
          bitField0_ |= 0x00000004;
          variable_ = other.variable_;
          onChanged();
        }
        if (other.hasLiteral()) {
          mergeLiteral(other.getLiteral());
        }
        if (other.hasFunctionCall()) {
          mergeFunctionCall(other.getFunctionCall());
        }
        if (other.hasOperator()) {
          mergeOperator(other.getOperator());
        }
        if (other.hasPosition()) {
          setPosition(other.getPosition());
        }
        if (other.hasObject()) {
          mergeObject(other.getObject());
        }
        if (other.hasArray()) {
          mergeArray(other.getArray());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasType()) {
          
          return false;
        }
        if (hasIdentifier()) {
          if (!getIdentifier().isInitialized()) {
            
            return false;
          }
        }
        if (hasLiteral()) {
          if (!getLiteral().isInitialized()) {
            
            return false;
          }
        }
        if (hasFunctionCall()) {
          if (!getFunctionCall().isInitialized()) {
            
            return false;
          }
        }
        if (hasOperator()) {
          if (!getOperator().isInitialized()) {
            
            return false;
          }
        }
        if (hasObject()) {
          if (!getObject().isInitialized()) {
            
            return false;
          }
        }
        if (hasArray()) {
          if (!getArray().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpr.Expr parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpr.Expr) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type type_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.IDENT;
      /**
       * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type getType() {
        return type_;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.IDENT;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier identifier_ = com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder> identifierBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public boolean hasIdentifier() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getIdentifier() {
        if (identifierBuilder_ == null) {
          return identifier_;
        } else {
          return identifierBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public Builder setIdentifier(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier value) {
        if (identifierBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          identifier_ = value;
          onChanged();
        } else {
          identifierBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public Builder setIdentifier(
          com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder builderForValue) {
        if (identifierBuilder_ == null) {
          identifier_ = builderForValue.build();
          onChanged();
        } else {
          identifierBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public Builder mergeIdentifier(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier value) {
        if (identifierBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              identifier_ != com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance()) {
            identifier_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.newBuilder(identifier_).mergeFrom(value).buildPartial();
          } else {
            identifier_ = value;
          }
          onChanged();
        } else {
          identifierBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public Builder clearIdentifier() {
        if (identifierBuilder_ == null) {
          identifier_ = com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
          onChanged();
        } else {
          identifierBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder getIdentifierBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getIdentifierFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder getIdentifierOrBuilder() {
        if (identifierBuilder_ != null) {
          return identifierBuilder_.getMessageOrBuilder();
        } else {
          return identifier_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder> 
          getIdentifierFieldBuilder() {
        if (identifierBuilder_ == null) {
          identifierBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder>(
                  getIdentifier(),
                  getParentForChildren(),
                  isClean());
          identifier_ = null;
        }
        return identifierBuilder_;
      }

      private java.lang.Object variable_ = "";
      /**
       * <code>optional string variable = 3;</code>
       */
      public boolean hasVariable() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string variable = 3;</code>
       */
      public java.lang.String getVariable() {
        java.lang.Object ref = variable_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            variable_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string variable = 3;</code>
       */
      public com.google.protobuf.ByteString
          getVariableBytes() {
        java.lang.Object ref = variable_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          variable_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string variable = 3;</code>
       */
      public Builder setVariable(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        variable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string variable = 3;</code>
       */
      public Builder clearVariable() {
        bitField0_ = (bitField0_ & ~0x00000004);
        variable_ = getDefaultInstance().getVariable();
        onChanged();
        return this;
      }
      /**
       * <code>optional string variable = 3;</code>
       */
      public Builder setVariableBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        variable_ = value;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar literal_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> literalBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public boolean hasLiteral() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getLiteral() {
        if (literalBuilder_ == null) {
          return literal_;
        } else {
          return literalBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public Builder setLiteral(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (literalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          literal_ = value;
          onChanged();
        } else {
          literalBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public Builder setLiteral(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (literalBuilder_ == null) {
          literal_ = builderForValue.build();
          onChanged();
        } else {
          literalBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public Builder mergeLiteral(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (literalBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008) &&
              literal_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance()) {
            literal_ =
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.newBuilder(literal_).mergeFrom(value).buildPartial();
          } else {
            literal_ = value;
          }
          onChanged();
        } else {
          literalBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public Builder clearLiteral() {
        if (literalBuilder_ == null) {
          literal_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
          onChanged();
        } else {
          literalBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getLiteralBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getLiteralFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getLiteralOrBuilder() {
        if (literalBuilder_ != null) {
          return literalBuilder_.getMessageOrBuilder();
        } else {
          return literal_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getLiteralFieldBuilder() {
        if (literalBuilder_ == null) {
          literalBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  getLiteral(),
                  getParentForChildren(),
                  isClean());
          literal_ = null;
        }
        return literalBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall functionCall_ = com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder> functionCallBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public boolean hasFunctionCall() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getFunctionCall() {
        if (functionCallBuilder_ == null) {
          return functionCall_;
        } else {
          return functionCallBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public Builder setFunctionCall(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall value) {
        if (functionCallBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          functionCall_ = value;
          onChanged();
        } else {
          functionCallBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public Builder setFunctionCall(
          com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder builderForValue) {
        if (functionCallBuilder_ == null) {
          functionCall_ = builderForValue.build();
          onChanged();
        } else {
          functionCallBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public Builder mergeFunctionCall(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall value) {
        if (functionCallBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010) &&
              functionCall_ != com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance()) {
            functionCall_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.newBuilder(functionCall_).mergeFrom(value).buildPartial();
          } else {
            functionCall_ = value;
          }
          onChanged();
        } else {
          functionCallBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public Builder clearFunctionCall() {
        if (functionCallBuilder_ == null) {
          functionCall_ = com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance();
          onChanged();
        } else {
          functionCallBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder getFunctionCallBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getFunctionCallFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder getFunctionCallOrBuilder() {
        if (functionCallBuilder_ != null) {
          return functionCallBuilder_.getMessageOrBuilder();
        } else {
          return functionCall_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder> 
          getFunctionCallFieldBuilder() {
        if (functionCallBuilder_ == null) {
          functionCallBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder>(
                  getFunctionCall(),
                  getParentForChildren(),
                  isClean());
          functionCall_ = null;
        }
        return functionCallBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Operator operator_ = com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Operator, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder> operatorBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public boolean hasOperator() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator getOperator() {
        if (operatorBuilder_ == null) {
          return operator_;
        } else {
          return operatorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public Builder setOperator(com.mysql.cj.x.protobuf.MysqlxExpr.Operator value) {
        if (operatorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          operator_ = value;
          onChanged();
        } else {
          operatorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public Builder setOperator(
          com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder builderForValue) {
        if (operatorBuilder_ == null) {
          operator_ = builderForValue.build();
          onChanged();
        } else {
          operatorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public Builder mergeOperator(com.mysql.cj.x.protobuf.MysqlxExpr.Operator value) {
        if (operatorBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020) &&
              operator_ != com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance()) {
            operator_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Operator.newBuilder(operator_).mergeFrom(value).buildPartial();
          } else {
            operator_ = value;
          }
          onChanged();
        } else {
          operatorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public Builder clearOperator() {
        if (operatorBuilder_ == null) {
          operator_ = com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance();
          onChanged();
        } else {
          operatorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder getOperatorBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getOperatorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder getOperatorOrBuilder() {
        if (operatorBuilder_ != null) {
          return operatorBuilder_.getMessageOrBuilder();
        } else {
          return operator_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Operator, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder> 
          getOperatorFieldBuilder() {
        if (operatorBuilder_ == null) {
          operatorBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Operator, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder>(
                  getOperator(),
                  getParentForChildren(),
                  isClean());
          operator_ = null;
        }
        return operatorBuilder_;
      }

      private int position_ ;
      /**
       * <code>optional uint32 position = 7;</code>
       */
      public boolean hasPosition() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional uint32 position = 7;</code>
       */
      public int getPosition() {
        return position_;
      }
      /**
       * <code>optional uint32 position = 7;</code>
       */
      public Builder setPosition(int value) {
        bitField0_ |= 0x00000040;
        position_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 position = 7;</code>
       */
      public Builder clearPosition() {
        bitField0_ = (bitField0_ & ~0x00000040);
        position_ = 0;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Object object_ = com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Object, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder> objectBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public boolean hasObject() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object getObject() {
        if (objectBuilder_ == null) {
          return object_;
        } else {
          return objectBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public Builder setObject(com.mysql.cj.x.protobuf.MysqlxExpr.Object value) {
        if (objectBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          object_ = value;
          onChanged();
        } else {
          objectBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public Builder setObject(
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder builderForValue) {
        if (objectBuilder_ == null) {
          object_ = builderForValue.build();
          onChanged();
        } else {
          objectBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public Builder mergeObject(com.mysql.cj.x.protobuf.MysqlxExpr.Object value) {
        if (objectBuilder_ == null) {
          if (((bitField0_ & 0x00000080) == 0x00000080) &&
              object_ != com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance()) {
            object_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Object.newBuilder(object_).mergeFrom(value).buildPartial();
          } else {
            object_ = value;
          }
          onChanged();
        } else {
          objectBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public Builder clearObject() {
        if (objectBuilder_ == null) {
          object_ = com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance();
          onChanged();
        } else {
          objectBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder getObjectBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getObjectFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder getObjectOrBuilder() {
        if (objectBuilder_ != null) {
          return objectBuilder_.getMessageOrBuilder();
        } else {
          return object_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Object, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder> 
          getObjectFieldBuilder() {
        if (objectBuilder_ == null) {
          objectBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Object, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder>(
                  getObject(),
                  getParentForChildren(),
                  isClean());
          object_ = null;
        }
        return objectBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Array array_ = com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Array, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder> arrayBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public boolean hasArray() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Array getArray() {
        if (arrayBuilder_ == null) {
          return array_;
        } else {
          return arrayBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public Builder setArray(com.mysql.cj.x.protobuf.MysqlxExpr.Array value) {
        if (arrayBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          array_ = value;
          onChanged();
        } else {
          arrayBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public Builder setArray(
          com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder builderForValue) {
        if (arrayBuilder_ == null) {
          array_ = builderForValue.build();
          onChanged();
        } else {
          arrayBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public Builder mergeArray(com.mysql.cj.x.protobuf.MysqlxExpr.Array value) {
        if (arrayBuilder_ == null) {
          if (((bitField0_ & 0x00000100) == 0x00000100) &&
              array_ != com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance()) {
            array_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Array.newBuilder(array_).mergeFrom(value).buildPartial();
          } else {
            array_ = value;
          }
          onChanged();
        } else {
          arrayBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public Builder clearArray() {
        if (arrayBuilder_ == null) {
          array_ = com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance();
          onChanged();
        } else {
          arrayBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder getArrayBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getArrayFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder getArrayOrBuilder() {
        if (arrayBuilder_ != null) {
          return arrayBuilder_.getMessageOrBuilder();
        } else {
          return array_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Array, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder> 
          getArrayFieldBuilder() {
        if (arrayBuilder_ == null) {
          arrayBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Array, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder>(
                  getArray(),
                  getParentForChildren(),
                  isClean());
          array_ = null;
        }
        return arrayBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Expr)
    }

    static {
      defaultInstance = new Expr(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Expr)
  }

  public interface IdentifierOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Identifier)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional string schema_name = 2;</code>
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();
  }
  /**
   * Protobuf type {@code Mysqlx.Expr.Identifier}
   *
   * <pre>
   * identifier: name, schame.name
   * .. productionlist::
   *   identifier: string "." string |
   *             : string
   * </pre>
   */
  public static final class Identifier extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Identifier)
      IdentifierOrBuilder {
    // Use Identifier.newBuilder() to construct.
    private Identifier(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Identifier(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Identifier defaultInstance;
    public static Identifier getDefaultInstance() {
      return defaultInstance;
    }

    public Identifier getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Identifier(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              schemaName_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.class, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder.class);
    }

    public static com.google.protobuf.Parser<Identifier> PARSER =
        new com.google.protobuf.AbstractParser<Identifier>() {
      public Identifier parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Identifier(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Identifier> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    private java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      name_ = "";
      schemaName_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getSchemaNameBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getSchemaNameBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.Identifier}
     *
     * <pre>
     * identifier: name, schame.name
     * .. productionlist::
     *   identifier: string "." string |
     *             : string
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Identifier)
        com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.class, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        schemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Identifier result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Identifier result = new com.mysql.cj.x.protobuf.MysqlxExpr.Identifier(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.schemaName_ = schemaName_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Identifier) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Identifier)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasSchemaName()) {
          bitField0_ |= 0x00000002;
          schemaName_ = other.schemaName_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpr.Identifier) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            schemaName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder clearSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Identifier)
    }

    static {
      defaultInstance = new Identifier(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Identifier)
  }

  public interface DocumentPathItemOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.DocumentPathItem)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
     */
    boolean hasType();
    /**
     * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type getType();

    /**
     * <code>optional string value = 2;</code>
     */
    boolean hasValue();
    /**
     * <code>optional string value = 2;</code>
     */
    java.lang.String getValue();
    /**
     * <code>optional string value = 2;</code>
     */
    com.google.protobuf.ByteString
        getValueBytes();

    /**
     * <code>optional uint32 index = 3;</code>
     */
    boolean hasIndex();
    /**
     * <code>optional uint32 index = 3;</code>
     */
    int getIndex();
  }
  /**
   * Protobuf type {@code Mysqlx.Expr.DocumentPathItem}
   *
   * <pre>
   * DocumentPathItem
   * .. productionlist::
   *    document_path: path_item | path_item document_path
   *    path_item    : member | array_index | "**"
   *    member       : "." string | "." "*"
   *    array_index  : "[" number "]" | "[" "*" "]"
   * </pre>
   */
  public static final class DocumentPathItem extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.DocumentPathItem)
      DocumentPathItemOrBuilder {
    // Use DocumentPathItem.newBuilder() to construct.
    private DocumentPathItem(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private DocumentPathItem(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final DocumentPathItem defaultInstance;
    public static DocumentPathItem getDefaultInstance() {
      return defaultInstance;
    }

    public DocumentPathItem getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private DocumentPathItem(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type value = com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                type_ = value;
              }
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              value_ = bs;
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              index_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.class, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder.class);
    }

    public static com.google.protobuf.Parser<DocumentPathItem> PARSER =
        new com.google.protobuf.AbstractParser<DocumentPathItem>() {
      public DocumentPathItem parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new DocumentPathItem(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<DocumentPathItem> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Expr.DocumentPathItem.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>MEMBER = 1;</code>
       *
       * <pre>
       * .member
       * </pre>
       */
      MEMBER(0, 1),
      /**
       * <code>MEMBER_ASTERISK = 2;</code>
       *
       * <pre>
       * .*
       * </pre>
       */
      MEMBER_ASTERISK(1, 2),
      /**
       * <code>ARRAY_INDEX = 3;</code>
       *
       * <pre>
       * [index]
       * </pre>
       */
      ARRAY_INDEX(2, 3),
      /**
       * <code>ARRAY_INDEX_ASTERISK = 4;</code>
       *
       * <pre>
       * [*]
       * </pre>
       */
      ARRAY_INDEX_ASTERISK(3, 4),
      /**
       * <code>DOUBLE_ASTERISK = 5;</code>
       *
       * <pre>
       * **
       * </pre>
       */
      DOUBLE_ASTERISK(4, 5),
      ;

      /**
       * <code>MEMBER = 1;</code>
       *
       * <pre>
       * .member
       * </pre>
       */
      public static final int MEMBER_VALUE = 1;
      /**
       * <code>MEMBER_ASTERISK = 2;</code>
       *
       * <pre>
       * .*
       * </pre>
       */
      public static final int MEMBER_ASTERISK_VALUE = 2;
      /**
       * <code>ARRAY_INDEX = 3;</code>
       *
       * <pre>
       * [index]
       * </pre>
       */
      public static final int ARRAY_INDEX_VALUE = 3;
      /**
       * <code>ARRAY_INDEX_ASTERISK = 4;</code>
       *
       * <pre>
       * [*]
       * </pre>
       */
      public static final int ARRAY_INDEX_ASTERISK_VALUE = 4;
      /**
       * <code>DOUBLE_ASTERISK = 5;</code>
       *
       * <pre>
       * **
       * </pre>
       */
      public static final int DOUBLE_ASTERISK_VALUE = 5;


      public final int getNumber() { return value; }

      public static Type valueOf(int value) {
        switch (value) {
          case 1: return MEMBER;
          case 2: return MEMBER_ASTERISK;
          case 3: return ARRAY_INDEX;
          case 4: return ARRAY_INDEX_ASTERISK;
          case 5: return DOUBLE_ASTERISK;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Type(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Expr.DocumentPathItem.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type type_;
    /**
     * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type getType() {
      return type_;
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private java.lang.Object value_;
    /**
     * <code>optional string value = 2;</code>
     */
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string value = 2;</code>
     */
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string value = 2;</code>
     */
    public com.google.protobuf.ByteString
        getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INDEX_FIELD_NUMBER = 3;
    private int index_;
    /**
     * <code>optional uint32 index = 3;</code>
     */
    public boolean hasIndex() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint32 index = 3;</code>
     */
    public int getIndex() {
      return index_;
    }

    private void initFields() {
      type_ = com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.MEMBER;
      value_ = "";
      index_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getValueBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt32(3, index_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getValueBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, index_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.DocumentPathItem}
     *
     * <pre>
     * DocumentPathItem
     * .. productionlist::
     *    document_path: path_item | path_item document_path
     *    path_item    : member | array_index | "**"
     *    member       : "." string | "." "*"
     *    array_index  : "[" number "]" | "[" "*" "]"
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.DocumentPathItem)
        com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.class, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        type_ = com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.MEMBER;
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        index_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem result = new com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.value_ = value_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.index_ = index_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasValue()) {
          bitField0_ |= 0x00000002;
          value_ = other.value_;
          onChanged();
        }
        if (other.hasIndex()) {
          setIndex(other.getIndex());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasType()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type type_ = com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.MEMBER;
      /**
       * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type getType() {
        return type_;
      }
      /**
       * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.MEMBER;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       * <code>optional string value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public Builder setValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public Builder setValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }

      private int index_ ;
      /**
       * <code>optional uint32 index = 3;</code>
       */
      public boolean hasIndex() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint32 index = 3;</code>
       */
      public int getIndex() {
        return index_;
      }
      /**
       * <code>optional uint32 index = 3;</code>
       */
      public Builder setIndex(int value) {
        bitField0_ |= 0x00000004;
        index_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 index = 3;</code>
       */
      public Builder clearIndex() {
        bitField0_ = (bitField0_ & ~0x00000004);
        index_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.DocumentPathItem)
    }

    static {
      defaultInstance = new DocumentPathItem(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.DocumentPathItem)
  }

  public interface ColumnIdentifierOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.ColumnIdentifier)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> 
        getDocumentPathList();
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDocumentPath(int index);
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    int getDocumentPathCount();
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
        getDocumentPathOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder getDocumentPathOrBuilder(
        int index);

    /**
     * <code>optional string name = 2;</code>
     */
    boolean hasName();
    /**
     * <code>optional string name = 2;</code>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 2;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional string table_name = 3;</code>
     */
    boolean hasTableName();
    /**
     * <code>optional string table_name = 3;</code>
     */
    java.lang.String getTableName();
    /**
     * <code>optional string table_name = 3;</code>
     */
    com.google.protobuf.ByteString
        getTableNameBytes();

    /**
     * <code>optional string schema_name = 4;</code>
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 4;</code>
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 4;</code>
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();
  }
  /**
   * Protobuf type {@code Mysqlx.Expr.ColumnIdentifier}
   *
   * <pre>
   * col_identifier (table): col&#64;doc_path, tbl.col&#64;doc_path col, tbl.col, schema.tbl.col
   * col_identifier (document): doc_path
   * .. productionlist::
   *   col_identifier: string "." string "." string |
   *             : string "." string |
   *             : string |
   *             : string "." string "." string "&#64;" document_path |
   *             : string "." string "&#64;" document_path |
   *             : string "&#64;" document_path |
   *             : document_path
   *    document_path: member | arrayLocation | doubleAsterisk
   *    member = "." string | "." "*"
   *    arrayLocation = "[" index "]" | "[" "*" "]"
   *    doubleAsterisk = "**"
   * </pre>
   */
  public static final class ColumnIdentifier extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.ColumnIdentifier)
      ColumnIdentifierOrBuilder {
    // Use ColumnIdentifier.newBuilder() to construct.
    private ColumnIdentifier(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ColumnIdentifier(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final ColumnIdentifier defaultInstance;
    public static ColumnIdentifier getDefaultInstance() {
      return defaultInstance;
    }

    public ColumnIdentifier getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private ColumnIdentifier(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                documentPath_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem>();
                mutable_bitField0_ |= 0x00000001;
              }
              documentPath_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.PARSER, extensionRegistry));
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              tableName_ = bs;
              break;
            }
            case 34: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              schemaName_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          documentPath_ = java.util.Collections.unmodifiableList(documentPath_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.class, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder.class);
    }

    public static com.google.protobuf.Parser<ColumnIdentifier> PARSER =
        new com.google.protobuf.AbstractParser<ColumnIdentifier>() {
      public ColumnIdentifier parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ColumnIdentifier(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnIdentifier> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int DOCUMENT_PATH_FIELD_NUMBER = 1;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> documentPath_;
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> getDocumentPathList() {
      return documentPath_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
        getDocumentPathOrBuilderList() {
      return documentPath_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    public int getDocumentPathCount() {
      return documentPath_.size();
    }
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDocumentPath(int index) {
      return documentPath_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder getDocumentPathOrBuilder(
        int index) {
      return documentPath_.get(index);
    }

    public static final int NAME_FIELD_NUMBER = 2;
    private java.lang.Object name_;
    /**
     * <code>optional string name = 2;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string name = 2;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_NAME_FIELD_NUMBER = 3;
    private java.lang.Object tableName_;
    /**
     * <code>optional string table_name = 3;</code>
     */
    public boolean hasTableName() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string table_name = 3;</code>
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          tableName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string table_name = 3;</code>
     */
    public com.google.protobuf.ByteString
        getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_NAME_FIELD_NUMBER = 4;
    private java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 4;</code>
     */
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string schema_name = 4;</code>
     */
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 4;</code>
     */
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      documentPath_ = java.util.Collections.emptyList();
      name_ = "";
      tableName_ = "";
      schemaName_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getDocumentPathCount(); i++) {
        if (!getDocumentPath(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < documentPath_.size(); i++) {
        output.writeMessage(1, documentPath_.get(i));
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(2, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(3, getTableNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(4, getSchemaNameBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < documentPath_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, documentPath_.get(i));
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getTableNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getSchemaNameBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.ColumnIdentifier}
     *
     * <pre>
     * col_identifier (table): col&#64;doc_path, tbl.col&#64;doc_path col, tbl.col, schema.tbl.col
     * col_identifier (document): doc_path
     * .. productionlist::
     *   col_identifier: string "." string "." string |
     *             : string "." string |
     *             : string |
     *             : string "." string "." string "&#64;" document_path |
     *             : string "." string "&#64;" document_path |
     *             : string "&#64;" document_path |
     *             : document_path
     *    document_path: member | arrayLocation | doubleAsterisk
     *    member = "." string | "." "*"
     *    arrayLocation = "[" index "]" | "[" "*" "]"
     *    doubleAsterisk = "**"
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.ColumnIdentifier)
        com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.class, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getDocumentPathFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (documentPathBuilder_ == null) {
          documentPath_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          documentPathBuilder_.clear();
        }
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        tableName_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        schemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier result = new com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (documentPathBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            documentPath_ = java.util.Collections.unmodifiableList(documentPath_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.documentPath_ = documentPath_;
        } else {
          result.documentPath_ = documentPathBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        result.tableName_ = tableName_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000004;
        }
        result.schemaName_ = schemaName_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance()) return this;
        if (documentPathBuilder_ == null) {
          if (!other.documentPath_.isEmpty()) {
            if (documentPath_.isEmpty()) {
              documentPath_ = other.documentPath_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDocumentPathIsMutable();
              documentPath_.addAll(other.documentPath_);
            }
            onChanged();
          }
        } else {
          if (!other.documentPath_.isEmpty()) {
            if (documentPathBuilder_.isEmpty()) {
              documentPathBuilder_.dispose();
              documentPathBuilder_ = null;
              documentPath_ = other.documentPath_;
              bitField0_ = (bitField0_ & ~0x00000001);
              documentPathBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getDocumentPathFieldBuilder() : null;
            } else {
              documentPathBuilder_.addAllMessages(other.documentPath_);
            }
          }
        }
        if (other.hasName()) {
          bitField0_ |= 0x00000002;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasTableName()) {
          bitField0_ |= 0x00000004;
          tableName_ = other.tableName_;
          onChanged();
        }
        if (other.hasSchemaName()) {
          bitField0_ |= 0x00000008;
          schemaName_ = other.schemaName_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getDocumentPathCount(); i++) {
          if (!getDocumentPath(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> documentPath_ =
        java.util.Collections.emptyList();
      private void ensureDocumentPathIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          documentPath_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem>(documentPath_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> documentPathBuilder_;

      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> getDocumentPathList() {
        if (documentPathBuilder_ == null) {
          return java.util.Collections.unmodifiableList(documentPath_);
        } else {
          return documentPathBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public int getDocumentPathCount() {
        if (documentPathBuilder_ == null) {
          return documentPath_.size();
        } else {
          return documentPathBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDocumentPath(int index) {
        if (documentPathBuilder_ == null) {
          return documentPath_.get(index);
        } else {
          return documentPathBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder setDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem value) {
        if (documentPathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentPathIsMutable();
          documentPath_.set(index, value);
          onChanged();
        } else {
          documentPathBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder setDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder builderForValue) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.set(index, builderForValue.build());
          onChanged();
        } else {
          documentPathBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addDocumentPath(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem value) {
        if (documentPathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentPathIsMutable();
          documentPath_.add(value);
          onChanged();
        } else {
          documentPathBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem value) {
        if (documentPathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentPathIsMutable();
          documentPath_.add(index, value);
          onChanged();
        } else {
          documentPathBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addDocumentPath(
          com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder builderForValue) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.add(builderForValue.build());
          onChanged();
        } else {
          documentPathBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder builderForValue) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.add(index, builderForValue.build());
          onChanged();
        } else {
          documentPathBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addAllDocumentPath(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> values) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, documentPath_);
          onChanged();
        } else {
          documentPathBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder clearDocumentPath() {
        if (documentPathBuilder_ == null) {
          documentPath_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          documentPathBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder removeDocumentPath(int index) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.remove(index);
          onChanged();
        } else {
          documentPathBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder getDocumentPathBuilder(
          int index) {
        return getDocumentPathFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder getDocumentPathOrBuilder(
          int index) {
        if (documentPathBuilder_ == null) {
          return documentPath_.get(index);  } else {
          return documentPathBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
           getDocumentPathOrBuilderList() {
        if (documentPathBuilder_ != null) {
          return documentPathBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(documentPath_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder addDocumentPathBuilder() {
        return getDocumentPathFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder addDocumentPathBuilder(
          int index) {
        return getDocumentPathFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder> 
           getDocumentPathBuilderList() {
        return getDocumentPathFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
          getDocumentPathFieldBuilder() {
        if (documentPathBuilder_ == null) {
          documentPathBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder>(
                  documentPath_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          documentPath_ = null;
        }
        return documentPathBuilder_;
      }

      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 2;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object tableName_ = "";
      /**
       * <code>optional string table_name = 3;</code>
       */
      public boolean hasTableName() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public java.lang.String getTableName() {
        java.lang.Object ref = tableName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            tableName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public com.google.protobuf.ByteString
          getTableNameBytes() {
        java.lang.Object ref = tableName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tableName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public Builder setTableName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public Builder clearTableName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        tableName_ = getDefaultInstance().getTableName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public Builder setTableNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 4;</code>
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string schema_name = 4;</code>
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            schemaName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 4;</code>
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 4;</code>
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 4;</code>
       */
      public Builder clearSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000008);
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 4;</code>
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        schemaName_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.ColumnIdentifier)
    }

    static {
      defaultInstance = new ColumnIdentifier(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.ColumnIdentifier)
  }

  public interface FunctionCallOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.FunctionCall)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     */
    boolean hasName();
    /**
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getName();
    /**
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder getNameOrBuilder();

    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> 
        getParamList();
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index);
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    int getParamCount();
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getParamOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Expr.FunctionCall}
   *
   * <pre>
   * function call: ``func(a, b, "1", 3)``
   * .. productionlist::
   *   function_call: `identifier` "(" [ `expr` ["," `expr` ]* ] ")"
   * </pre>
   */
  public static final class FunctionCall extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.FunctionCall)
      FunctionCallOrBuilder {
    // Use FunctionCall.newBuilder() to construct.
    private FunctionCall(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private FunctionCall(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final FunctionCall defaultInstance;
    public static FunctionCall getDefaultInstance() {
      return defaultInstance;
    }

    public FunctionCall getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private FunctionCall(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = name_.toBuilder();
              }
              name_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(name_);
                name_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                param_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>();
                mutable_bitField0_ |= 0x00000002;
              }
              param_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          param_ = java.util.Collections.unmodifiableList(param_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.class, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder.class);
    }

    public static com.google.protobuf.Parser<FunctionCall> PARSER =
        new com.google.protobuf.AbstractParser<FunctionCall>() {
      public FunctionCall parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FunctionCall(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<FunctionCall> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Identifier name_;
    /**
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getName() {
      return name_;
    }
    /**
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder getNameOrBuilder() {
      return name_;
    }

    public static final int PARAM_FIELD_NUMBER = 2;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> param_;
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getParamList() {
      return param_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getParamOrBuilderList() {
      return param_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public int getParamCount() {
      return param_.size();
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index) {
      return param_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
        int index) {
      return param_.get(index);
    }

    private void initFields() {
      name_ = com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance();
      param_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getName().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getParamCount(); i++) {
        if (!getParam(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, name_);
      }
      for (int i = 0; i < param_.size(); i++) {
        output.writeMessage(2, param_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, name_);
      }
      for (int i = 0; i < param_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, param_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.FunctionCall}
     *
     * <pre>
     * function call: ``func(a, b, "1", 3)``
     * .. productionlist::
     *   function_call: `identifier` "(" [ `expr` ["," `expr` ]* ] ")"
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.FunctionCall)
        com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.class, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getNameFieldBuilder();
          getParamFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (nameBuilder_ == null) {
          name_ = com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance();
        } else {
          nameBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (paramBuilder_ == null) {
          param_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          paramBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall result = new com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (nameBuilder_ == null) {
          result.name_ = name_;
        } else {
          result.name_ = nameBuilder_.build();
        }
        if (paramBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            param_ = java.util.Collections.unmodifiableList(param_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.param_ = param_;
        } else {
          result.param_ = paramBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance()) return this;
        if (other.hasName()) {
          mergeName(other.getName());
        }
        if (paramBuilder_ == null) {
          if (!other.param_.isEmpty()) {
            if (param_.isEmpty()) {
              param_ = other.param_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureParamIsMutable();
              param_.addAll(other.param_);
            }
            onChanged();
          }
        } else {
          if (!other.param_.isEmpty()) {
            if (paramBuilder_.isEmpty()) {
              paramBuilder_.dispose();
              paramBuilder_ = null;
              param_ = other.param_;
              bitField0_ = (bitField0_ & ~0x00000002);
              paramBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getParamFieldBuilder() : null;
            } else {
              paramBuilder_.addAllMessages(other.param_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        if (!getName().isInitialized()) {
          
          return false;
        }
        for (int i = 0; i < getParamCount(); i++) {
          if (!getParam(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxExpr.Identifier name_ = com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Identifier, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder> nameBuilder_;
      /**
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getName() {
        if (nameBuilder_ == null) {
          return name_;
        } else {
          return nameBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public Builder setName(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier value) {
        if (nameBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          onChanged();
        } else {
          nameBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public Builder setName(
          com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder builderForValue) {
        if (nameBuilder_ == null) {
          name_ = builderForValue.build();
          onChanged();
        } else {
          nameBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public Builder mergeName(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier value) {
        if (nameBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              name_ != com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance()) {
            name_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.newBuilder(name_).mergeFrom(value).buildPartial();
          } else {
            name_ = value;
          }
          onChanged();
        } else {
          nameBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public Builder clearName() {
        if (nameBuilder_ == null) {
          name_ = com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance();
          onChanged();
        } else {
          nameBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder getNameBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getNameFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder getNameOrBuilder() {
        if (nameBuilder_ != null) {
          return nameBuilder_.getMessageOrBuilder();
        } else {
          return name_;
        }
      }
      /**
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Identifier, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder> 
          getNameFieldBuilder() {
        if (nameBuilder_ == null) {
          nameBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Identifier, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder>(
                  getName(),
                  getParentForChildren(),
                  isClean());
          name_ = null;
        }
        return nameBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> param_ =
        java.util.Collections.emptyList();
      private void ensureParamIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          param_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>(param_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> paramBuilder_;

      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getParamList() {
        if (paramBuilder_ == null) {
          return java.util.Collections.unmodifiableList(param_);
        } else {
          return paramBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public int getParamCount() {
        if (paramBuilder_ == null) {
          return param_.size();
        } else {
          return paramBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index) {
        if (paramBuilder_ == null) {
          return param_.get(index);
        } else {
          return paramBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder setParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.set(index, value);
          onChanged();
        } else {
          paramBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder setParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.set(index, builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.add(value);
          onChanged();
        } else {
          paramBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.add(index, value);
          onChanged();
        } else {
          paramBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.add(builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.add(index, builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addAllParam(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Expr> values) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, param_);
          onChanged();
        } else {
          paramBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder clearParam() {
        if (paramBuilder_ == null) {
          param_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          paramBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder removeParam(int index) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.remove(index);
          onChanged();
        } else {
          paramBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getParamBuilder(
          int index) {
        return getParamFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
          int index) {
        if (paramBuilder_ == null) {
          return param_.get(index);  } else {
          return paramBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
           getParamOrBuilderList() {
        if (paramBuilder_ != null) {
          return paramBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(param_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addParamBuilder() {
        return getParamFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addParamBuilder(
          int index) {
        return getParamFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder> 
           getParamBuilderList() {
        return getParamFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getParamFieldBuilder() {
        if (paramBuilder_ == null) {
          paramBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  param_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          param_ = null;
        }
        return paramBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.FunctionCall)
    }

    static {
      defaultInstance = new FunctionCall(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.FunctionCall)
  }

  public interface OperatorOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Operator)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> 
        getParamList();
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index);
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    int getParamCount();
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getParamOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Expr.Operator}
   *
   * <pre>
   * operator: ``&lt;&lt;(a, b)``
   * .. note::
   *   Non-authoritative list of operators implemented (case sensitive):
   *   Nullary
   *     * ``*``
   *     * ``default``
   *   Unary
   *     * ``!``
   *     * ``sign_plus``
   *     * ``sign_minus``
   *     * ``~``
   *   Binary
   *     * ``&amp;&amp;``
   *     * ``||``
   *     * ``xor``
   *     * ``==``
   *     * ``!=``
   *     * ``&gt;``
   *     * ``&gt;=``
   *     * ``&lt;``
   *     * ``&lt;=``
   *     * ``&amp;``
   *     * ``|``
   *     * ``^``
   *     * ``&lt;&lt;``
   *     * ``&gt;&gt;``
   *     * ``+``
   *     * ``-``
   *     * ``*``
   *     * ``/``
   *     * ``div``
   *     * ``%``
   *     * ``is``
   *     * ``is_not``
   *     * ``regexp``
   *     * ``not_regexp``
   *     * ``like``
   *     * ``not_like``
   *     * ``cast``
   *     * ``cont_in``
   *     * ``not_cont_in``
   *   Using special representation, with more than 2 params
   *     * ``in`` (param[0] IN (param[1], param[2], ...))
   *     * ``not_in`` (param[0] NOT IN (param[1], param[2], ...))
   *   Ternary
   *     * ``between``
   *     * ``between_not``
   *     * ``date_add``
   *     * ``date_sub``
   *   Units for date_add/date_sub
   *     * ``MICROSECOND``
   *     * ``SECOND``
   *     * ``MINUTE``
   *     * ``HOUR``
   *     * ``DAY``
   *     * ``WEEK``
   *     * ``MONTH``
   *     * ``QUARTER``
   *     * ``YEAR``
   *     * ``SECOND_MICROSECOND``
   *     * ``MINUTE_MICROSECOND``
   *     * ``MINUTE_SECOND``
   *     * ``HOUR_MICROSECOND``
   *     * ``HOUR_SECOND``
   *     * ``HOUR_MINUTE``
   *     * ``DAY_MICROSECOND``
   *     * ``DAY_SECOND``
   *     * ``DAY_MINUTE``
   *     * ``DAY_HOUR``
   *   Types for cast
   *     * ``BINARY[(N)]``
   *     * ``CHAR[(N)]``
   *     * ``DATE``
   *     * ``DATETIME``
   *     * ``DECIMAL[(M[,D])]``
   *     * ``JSON``
   *     * ``SIGNED [INTEGER]``
   *     * ``TIME``
   *     * ``UNSIGNED [INTEGER]``
   * .. productionlist::
   *   operator: `name` "(" [ `expr` ["," `expr` ]* ] ")"
   * </pre>
   */
  public static final class Operator extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Operator)
      OperatorOrBuilder {
    // Use Operator.newBuilder() to construct.
    private Operator(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Operator(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Operator defaultInstance;
    public static Operator getDefaultInstance() {
      return defaultInstance;
    }

    public Operator getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Operator(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                param_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>();
                mutable_bitField0_ |= 0x00000002;
              }
              param_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          param_ = java.util.Collections.unmodifiableList(param_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Operator.class, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder.class);
    }

    public static com.google.protobuf.Parser<Operator> PARSER =
        new com.google.protobuf.AbstractParser<Operator>() {
      public Operator parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Operator(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Operator> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAM_FIELD_NUMBER = 2;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> param_;
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getParamList() {
      return param_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getParamOrBuilderList() {
      return param_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public int getParamCount() {
      return param_.size();
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index) {
      return param_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
        int index) {
      return param_.get(index);
    }

    private void initFields() {
      name_ = "";
      param_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getParamCount(); i++) {
        if (!getParam(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      for (int i = 0; i < param_.size(); i++) {
        output.writeMessage(2, param_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      for (int i = 0; i < param_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, param_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Operator prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.Operator}
     *
     * <pre>
     * operator: ``&lt;&lt;(a, b)``
     * .. note::
     *   Non-authoritative list of operators implemented (case sensitive):
     *   Nullary
     *     * ``*``
     *     * ``default``
     *   Unary
     *     * ``!``
     *     * ``sign_plus``
     *     * ``sign_minus``
     *     * ``~``
     *   Binary
     *     * ``&amp;&amp;``
     *     * ``||``
     *     * ``xor``
     *     * ``==``
     *     * ``!=``
     *     * ``&gt;``
     *     * ``&gt;=``
     *     * ``&lt;``
     *     * ``&lt;=``
     *     * ``&amp;``
     *     * ``|``
     *     * ``^``
     *     * ``&lt;&lt;``
     *     * ``&gt;&gt;``
     *     * ``+``
     *     * ``-``
     *     * ``*``
     *     * ``/``
     *     * ``div``
     *     * ``%``
     *     * ``is``
     *     * ``is_not``
     *     * ``regexp``
     *     * ``not_regexp``
     *     * ``like``
     *     * ``not_like``
     *     * ``cast``
     *     * ``cont_in``
     *     * ``not_cont_in``
     *   Using special representation, with more than 2 params
     *     * ``in`` (param[0] IN (param[1], param[2], ...))
     *     * ``not_in`` (param[0] NOT IN (param[1], param[2], ...))
     *   Ternary
     *     * ``between``
     *     * ``between_not``
     *     * ``date_add``
     *     * ``date_sub``
     *   Units for date_add/date_sub
     *     * ``MICROSECOND``
     *     * ``SECOND``
     *     * ``MINUTE``
     *     * ``HOUR``
     *     * ``DAY``
     *     * ``WEEK``
     *     * ``MONTH``
     *     * ``QUARTER``
     *     * ``YEAR``
     *     * ``SECOND_MICROSECOND``
     *     * ``MINUTE_MICROSECOND``
     *     * ``MINUTE_SECOND``
     *     * ``HOUR_MICROSECOND``
     *     * ``HOUR_SECOND``
     *     * ``HOUR_MINUTE``
     *     * ``DAY_MICROSECOND``
     *     * ``DAY_SECOND``
     *     * ``DAY_MINUTE``
     *     * ``DAY_HOUR``
     *   Types for cast
     *     * ``BINARY[(N)]``
     *     * ``CHAR[(N)]``
     *     * ``DATE``
     *     * ``DATETIME``
     *     * ``DECIMAL[(M[,D])]``
     *     * ``JSON``
     *     * ``SIGNED [INTEGER]``
     *     * ``TIME``
     *     * ``UNSIGNED [INTEGER]``
     * .. productionlist::
     *   operator: `name` "(" [ `expr` ["," `expr` ]* ] ")"
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Operator)
        com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Operator.class, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Operator.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getParamFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (paramBuilder_ == null) {
          param_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          paramBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Operator result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Operator result = new com.mysql.cj.x.protobuf.MysqlxExpr.Operator(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (paramBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            param_ = java.util.Collections.unmodifiableList(param_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.param_ = param_;
        } else {
          result.param_ = paramBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Operator) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Operator)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Operator other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (paramBuilder_ == null) {
          if (!other.param_.isEmpty()) {
            if (param_.isEmpty()) {
              param_ = other.param_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureParamIsMutable();
              param_.addAll(other.param_);
            }
            onChanged();
          }
        } else {
          if (!other.param_.isEmpty()) {
            if (paramBuilder_.isEmpty()) {
              paramBuilder_.dispose();
              paramBuilder_ = null;
              param_ = other.param_;
              bitField0_ = (bitField0_ & ~0x00000002);
              paramBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getParamFieldBuilder() : null;
            } else {
              paramBuilder_.addAllMessages(other.param_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        for (int i = 0; i < getParamCount(); i++) {
          if (!getParam(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpr.Operator parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpr.Operator) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> param_ =
        java.util.Collections.emptyList();
      private void ensureParamIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          param_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>(param_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> paramBuilder_;

      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getParamList() {
        if (paramBuilder_ == null) {
          return java.util.Collections.unmodifiableList(param_);
        } else {
          return paramBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public int getParamCount() {
        if (paramBuilder_ == null) {
          return param_.size();
        } else {
          return paramBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index) {
        if (paramBuilder_ == null) {
          return param_.get(index);
        } else {
          return paramBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder setParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.set(index, value);
          onChanged();
        } else {
          paramBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder setParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.set(index, builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.add(value);
          onChanged();
        } else {
          paramBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.add(index, value);
          onChanged();
        } else {
          paramBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.add(builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.add(index, builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addAllParam(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Expr> values) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, param_);
          onChanged();
        } else {
          paramBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder clearParam() {
        if (paramBuilder_ == null) {
          param_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          paramBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder removeParam(int index) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.remove(index);
          onChanged();
        } else {
          paramBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getParamBuilder(
          int index) {
        return getParamFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
          int index) {
        if (paramBuilder_ == null) {
          return param_.get(index);  } else {
          return paramBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
           getParamOrBuilderList() {
        if (paramBuilder_ != null) {
          return paramBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(param_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addParamBuilder() {
        return getParamFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addParamBuilder(
          int index) {
        return getParamFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder> 
           getParamBuilderList() {
        return getParamFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getParamFieldBuilder() {
        if (paramBuilder_ == null) {
          paramBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  param_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          param_ = null;
        }
        return paramBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Operator)
    }

    static {
      defaultInstance = new Operator(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Operator)
  }

  public interface ObjectOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Object)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> 
        getFldList();
    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getFld(int index);
    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    int getFldCount();
    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> 
        getFldOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder getFldOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Expr.Object}
   *
   * <pre>
   * an object (with expression values)
   * </pre>
   */
  public static final class Object extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Object)
      ObjectOrBuilder {
    // Use Object.newBuilder() to construct.
    private Object(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Object(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Object defaultInstance;
    public static Object getDefaultInstance() {
      return defaultInstance;
    }

    public Object getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Object(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                fld_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField>();
                mutable_bitField0_ |= 0x00000001;
              }
              fld_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          fld_ = java.util.Collections.unmodifiableList(fld_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Object.class, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder.class);
    }

    public static com.google.protobuf.Parser<Object> PARSER =
        new com.google.protobuf.AbstractParser<Object>() {
      public Object parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Object(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Object> getParserForType() {
      return PARSER;
    }

    public interface ObjectFieldOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Object.ObjectField)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required string key = 1;</code>
       */
      boolean hasKey();
      /**
       * <code>required string key = 1;</code>
       */
      java.lang.String getKey();
      /**
       * <code>required string key = 1;</code>
       */
      com.google.protobuf.ByteString
          getKeyBytes();

      /**
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       */
      boolean hasValue();
      /**
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue();
      /**
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder();
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.Object.ObjectField}
     */
    public static final class ObjectField extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Object.ObjectField)
        ObjectFieldOrBuilder {
      // Use ObjectField.newBuilder() to construct.
      private ObjectField(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
        this.unknownFields = builder.getUnknownFields();
      }
      private ObjectField(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

      private static final ObjectField defaultInstance;
      public static ObjectField getDefaultInstance() {
        return defaultInstance;
      }

      public ObjectField getDefaultInstanceForType() {
        return defaultInstance;
      }

      private final com.google.protobuf.UnknownFieldSet unknownFields;
      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
          getUnknownFields() {
        return this.unknownFields;
      }
      private ObjectField(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        initFields();
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownField(input, unknownFields,
                                       extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 10: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                key_ = bs;
                break;
              }
              case 18: {
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = value_.toBuilder();
                }
                value_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(value_);
                  value_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e.getMessage()).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.class, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder.class);
      }

      public static com.google.protobuf.Parser<ObjectField> PARSER =
          new com.google.protobuf.AbstractParser<ObjectField>() {
        public ObjectField parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ObjectField(input, extensionRegistry);
        }
      };

      @java.lang.Override
      public com.google.protobuf.Parser<ObjectField> getParserForType() {
        return PARSER;
      }

      private int bitField0_;
      public static final int KEY_FIELD_NUMBER = 1;
      private java.lang.Object key_;
      /**
       * <code>required string key = 1;</code>
       */
      public boolean hasKey() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string key = 1;</code>
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            key_ = s;
          }
          return s;
        }
      }
      /**
       * <code>required string key = 1;</code>
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr value_;
      /**
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue() {
        return value_;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder() {
        return value_;
      }

      private void initFields() {
        key_ = "";
        value_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      }
      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasKey()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getSerializedSize();
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          output.writeBytes(1, getKeyBytes());
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          output.writeMessage(2, value_);
        }
        getUnknownFields().writeTo(output);
      }

      private int memoizedSerializedSize = -1;
      public int getSerializedSize() {
        int size = memoizedSerializedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(1, getKeyBytes());
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, value_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSerializedSize = size;
        return size;
      }

      private static final long serialVersionUID = 0L;
      @java.lang.Override
      protected java.lang.Object writeReplace()
          throws java.io.ObjectStreamException {
        return super.writeReplace();
      }

      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }

      public static Builder newBuilder() { return Builder.create(); }
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField prototype) {
        return newBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() { return newBuilder(this); }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Expr.Object.ObjectField}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Object.ObjectField)
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_descriptor;
        }

        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.class, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
            getValueFieldBuilder();
          }
        }
        private static Builder create() {
          return new Builder();
        }

        public Builder clear() {
          super.clear();
          key_ = "";
          bitField0_ = (bitField0_ & ~0x00000001);
          if (valueBuilder_ == null) {
            value_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
          } else {
            valueBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        public Builder clone() {
          return create().mergeFrom(buildPartial());
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_descriptor;
        }

        public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.getDefaultInstance();
        }

        public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField build() {
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField result = new com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
            to_bitField0_ |= 0x00000001;
          }
          result.key_ = key_;
          if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
            to_bitField0_ |= 0x00000002;
          }
          if (valueBuilder_ == null) {
            result.value_ = value_;
          } else {
            result.value_ = valueBuilder_.build();
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.getDefaultInstance()) return this;
          if (other.hasKey()) {
            bitField0_ |= 0x00000001;
            key_ = other.key_;
            onChanged();
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          return this;
        }

        public final boolean isInitialized() {
          if (!hasKey()) {
            
            return false;
          }
          if (!hasValue()) {
            
            return false;
          }
          if (!getValue().isInitialized()) {
            
            return false;
          }
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField) e.getUnfinishedMessage();
            throw e;
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.lang.Object key_ = "";
        /**
         * <code>required string key = 1;</code>
         */
        public boolean hasKey() {
          return ((bitField0_ & 0x00000001) == 0x00000001);
        }
        /**
         * <code>required string key = 1;</code>
         */
        public java.lang.String getKey() {
          java.lang.Object ref = key_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              key_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>required string key = 1;</code>
         */
        public com.google.protobuf.ByteString
            getKeyBytes() {
          java.lang.Object ref = key_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            key_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <code>required string key = 1;</code>
         */
        public Builder setKey(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          key_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>required string key = 1;</code>
         */
        public Builder clearKey() {
          bitField0_ = (bitField0_ & ~0x00000001);
          key_ = getDefaultInstance().getKey();
          onChanged();
          return this;
        }
        /**
         * <code>required string key = 1;</code>
         */
        public Builder setKeyBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          key_ = value;
          onChanged();
          return this;
        }

        private com.mysql.cj.x.protobuf.MysqlxExpr.Expr value_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> valueBuilder_;
        /**
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) == 0x00000002);
        }
        /**
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue() {
          if (valueBuilder_ == null) {
            return value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public Builder setValue(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
            onChanged();
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public Builder setValue(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
            onChanged();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public Builder mergeValue(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) == 0x00000002) &&
                value_ != com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) {
              value_ =
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder(value_).mergeFrom(value).buildPartial();
            } else {
              value_ = value;
            }
            onChanged();
          } else {
            valueBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public Builder clearValue() {
          if (valueBuilder_ == null) {
            value_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
            onChanged();
          } else {
            valueBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }
        /**
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_;
          }
        }
        /**
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                    getValue(),
                    getParentForChildren(),
                    isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Object.ObjectField)
      }

      static {
        defaultInstance = new ObjectField(true);
        defaultInstance.initFields();
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Object.ObjectField)
    }

    public static final int FLD_FIELD_NUMBER = 1;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> fld_;
    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> getFldList() {
      return fld_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> 
        getFldOrBuilderList() {
      return fld_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    public int getFldCount() {
      return fld_.size();
    }
    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getFld(int index) {
      return fld_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder getFldOrBuilder(
        int index) {
      return fld_.get(index);
    }

    private void initFields() {
      fld_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getFldCount(); i++) {
        if (!getFld(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < fld_.size(); i++) {
        output.writeMessage(1, fld_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fld_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, fld_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Object prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.Object}
     *
     * <pre>
     * an object (with expression values)
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Object)
        com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Object.class, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Object.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getFldFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (fldBuilder_ == null) {
          fld_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          fldBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Object getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Object build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Object result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Object buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Object result = new com.mysql.cj.x.protobuf.MysqlxExpr.Object(this);
        int from_bitField0_ = bitField0_;
        if (fldBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            fld_ = java.util.Collections.unmodifiableList(fld_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fld_ = fld_;
        } else {
          result.fld_ = fldBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Object) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Object)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Object other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance()) return this;
        if (fldBuilder_ == null) {
          if (!other.fld_.isEmpty()) {
            if (fld_.isEmpty()) {
              fld_ = other.fld_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFldIsMutable();
              fld_.addAll(other.fld_);
            }
            onChanged();
          }
        } else {
          if (!other.fld_.isEmpty()) {
            if (fldBuilder_.isEmpty()) {
              fldBuilder_.dispose();
              fldBuilder_ = null;
              fld_ = other.fld_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fldBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getFldFieldBuilder() : null;
            } else {
              fldBuilder_.addAllMessages(other.fld_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getFldCount(); i++) {
          if (!getFld(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpr.Object parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpr.Object) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> fld_ =
        java.util.Collections.emptyList();
      private void ensureFldIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          fld_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField>(fld_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> fldBuilder_;

      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> getFldList() {
        if (fldBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fld_);
        } else {
          return fldBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public int getFldCount() {
        if (fldBuilder_ == null) {
          return fld_.size();
        } else {
          return fldBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getFld(int index) {
        if (fldBuilder_ == null) {
          return fld_.get(index);
        } else {
          return fldBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder setFld(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.set(index, value);
          onChanged();
        } else {
          fldBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder setFld(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.set(index, builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.add(value);
          onChanged();
        } else {
          fldBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.add(index, value);
          onChanged();
        } else {
          fldBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.add(builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.add(index, builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addAllFld(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> values) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, fld_);
          onChanged();
        } else {
          fldBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder clearFld() {
        if (fldBuilder_ == null) {
          fld_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fldBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder removeFld(int index) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.remove(index);
          onChanged();
        } else {
          fldBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder getFldBuilder(
          int index) {
        return getFldFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder getFldOrBuilder(
          int index) {
        if (fldBuilder_ == null) {
          return fld_.get(index);  } else {
          return fldBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> 
           getFldOrBuilderList() {
        if (fldBuilder_ != null) {
          return fldBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fld_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder addFldBuilder() {
        return getFldFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder addFldBuilder(
          int index) {
        return getFldFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder> 
           getFldBuilderList() {
        return getFldFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> 
          getFldFieldBuilder() {
        if (fldBuilder_ == null) {
          fldBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder>(
                  fld_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          fld_ = null;
        }
        return fldBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Object)
    }

    static {
      defaultInstance = new Object(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Object)
  }

  public interface ArrayOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Array)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> 
        getValueList();
    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue(int index);
    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    int getValueCount();
    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getValueOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Expr.Array}
   *
   * <pre>
   * a Array of expressions
   * </pre>
   */
  public static final class Array extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Array)
      ArrayOrBuilder {
    // Use Array.newBuilder() to construct.
    private Array(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Array(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Array defaultInstance;
    public static Array getDefaultInstance() {
      return defaultInstance;
    }

    public Array getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Array(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                value_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>();
                mutable_bitField0_ |= 0x00000001;
              }
              value_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          value_ = java.util.Collections.unmodifiableList(value_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Array.class, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder.class);
    }

    public static com.google.protobuf.Parser<Array> PARSER =
        new com.google.protobuf.AbstractParser<Array>() {
      public Array parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Array(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Array> getParserForType() {
      return PARSER;
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> value_;
    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getValueList() {
      return value_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getValueOrBuilderList() {
      return value_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    public int getValueCount() {
      return value_.size();
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue(int index) {
      return value_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder(
        int index) {
      return value_.get(index);
    }

    private void initFields() {
      value_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getValueCount(); i++) {
        if (!getValue(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < value_.size(); i++) {
        output.writeMessage(1, value_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < value_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, value_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Array prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.Array}
     *
     * <pre>
     * a Array of expressions
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Array)
        com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Array.class, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Array.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getValueFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          valueBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Array getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Array build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Array result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpr.Array buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Array result = new com.mysql.cj.x.protobuf.MysqlxExpr.Array(this);
        int from_bitField0_ = bitField0_;
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            value_ = java.util.Collections.unmodifiableList(value_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Array) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Array)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Array other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance()) return this;
        if (valueBuilder_ == null) {
          if (!other.value_.isEmpty()) {
            if (value_.isEmpty()) {
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValueIsMutable();
              value_.addAll(other.value_);
            }
            onChanged();
          }
        } else {
          if (!other.value_.isEmpty()) {
            if (valueBuilder_.isEmpty()) {
              valueBuilder_.dispose();
              valueBuilder_ = null;
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
              valueBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getValueFieldBuilder() : null;
            } else {
              valueBuilder_.addAllMessages(other.value_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getValueCount(); i++) {
          if (!getValue(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpr.Array parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpr.Array) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> value_ =
        java.util.Collections.emptyList();
      private void ensureValueIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          value_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>(value_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> valueBuilder_;

      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getValueList() {
        if (valueBuilder_ == null) {
          return java.util.Collections.unmodifiableList(value_);
        } else {
          return valueBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public int getValueCount() {
        if (valueBuilder_ == null) {
          return value_.size();
        } else {
          return valueBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue(int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);
        } else {
          return valueBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.set(index, value);
          onChanged();
        } else {
          valueBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.set(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addValue(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(value);
          onChanged();
        } else {
          valueBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(index, value);
          onChanged();
        } else {
          valueBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addValue(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addAllValue(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Expr> values) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, value_);
          onChanged();
        } else {
          valueBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder removeValue(int index) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.remove(index);
          onChanged();
        } else {
          valueBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getValueBuilder(
          int index) {
        return getValueFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder(
          int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);  } else {
          return valueBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
           getValueOrBuilderList() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(value_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addValueBuilder() {
        return getValueFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addValueBuilder(
          int index) {
        return getValueFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder> 
           getValueBuilderList() {
        return getValueFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  value_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Array)
    }

    static {
      defaultInstance = new Array(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Array)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Expr_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Expr_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Identifier_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Identifier_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_DocumentPathItem_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_DocumentPathItem_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_ColumnIdentifier_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_FunctionCall_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_FunctionCall_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Operator_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Operator_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Object_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Object_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Object_ObjectField_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Object_ObjectField_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Array_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Array_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\021mysqlx_expr.proto\022\013Mysqlx.Expr\032\026mysqlx" +
      "_datatypes.proto\"\304\003\n\004Expr\022$\n\004type\030\001 \002(\0162" +
      "\026.Mysqlx.Expr.Expr.Type\0221\n\nidentifier\030\002 " +
      "\001(\0132\035.Mysqlx.Expr.ColumnIdentifier\022\020\n\010va" +
      "riable\030\003 \001(\t\022)\n\007literal\030\004 \001(\0132\030.Mysqlx.D" +
      "atatypes.Scalar\0220\n\rfunction_call\030\005 \001(\0132\031" +
      ".Mysqlx.Expr.FunctionCall\022\'\n\010operator\030\006 " +
      "\001(\0132\025.Mysqlx.Expr.Operator\022\020\n\010position\030\007" +
      " \001(\r\022#\n\006object\030\010 \001(\0132\023.Mysqlx.Expr.Objec" +
      "t\022!\n\005array\030\t \001(\0132\022.Mysqlx.Expr.Array\"q\n\004",
      "Type\022\t\n\005IDENT\020\001\022\013\n\007LITERAL\020\002\022\014\n\010VARIABLE" +
      "\020\003\022\r\n\tFUNC_CALL\020\004\022\014\n\010OPERATOR\020\005\022\017\n\013PLACE" +
      "HOLDER\020\006\022\n\n\006OBJECT\020\007\022\t\n\005ARRAY\020\010\"/\n\nIdent" +
      "ifier\022\014\n\004name\030\001 \002(\t\022\023\n\013schema_name\030\002 \001(\t" +
      "\"\313\001\n\020DocumentPathItem\0220\n\004type\030\001 \002(\0162\".My" +
      "sqlx.Expr.DocumentPathItem.Type\022\r\n\005value" +
      "\030\002 \001(\t\022\r\n\005index\030\003 \001(\r\"g\n\004Type\022\n\n\006MEMBER\020" +
      "\001\022\023\n\017MEMBER_ASTERISK\020\002\022\017\n\013ARRAY_INDEX\020\003\022" +
      "\030\n\024ARRAY_INDEX_ASTERISK\020\004\022\023\n\017DOUBLE_ASTE" +
      "RISK\020\005\"\177\n\020ColumnIdentifier\0224\n\rdocument_p",
      "ath\030\001 \003(\0132\035.Mysqlx.Expr.DocumentPathItem" +
      "\022\014\n\004name\030\002 \001(\t\022\022\n\ntable_name\030\003 \001(\t\022\023\n\013sc" +
      "hema_name\030\004 \001(\t\"W\n\014FunctionCall\022%\n\004name\030" +
      "\001 \002(\0132\027.Mysqlx.Expr.Identifier\022 \n\005param\030" +
      "\002 \003(\0132\021.Mysqlx.Expr.Expr\":\n\010Operator\022\014\n\004" +
      "name\030\001 \002(\t\022 \n\005param\030\002 \003(\0132\021.Mysqlx.Expr." +
      "Expr\"t\n\006Object\022,\n\003fld\030\001 \003(\0132\037.Mysqlx.Exp" +
      "r.Object.ObjectField\032<\n\013ObjectField\022\013\n\003k" +
      "ey\030\001 \002(\t\022 \n\005value\030\002 \002(\0132\021.Mysqlx.Expr.Ex" +
      "pr\")\n\005Array\022 \n\005value\030\001 \003(\0132\021.Mysqlx.Expr",
      ".ExprB\031\n\027com.mysql.cj.x.protobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor(),
        }, assigner);
    internal_static_Mysqlx_Expr_Expr_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Expr_Expr_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Expr_descriptor,
        new java.lang.String[] { "Type", "Identifier", "Variable", "Literal", "FunctionCall", "Operator", "Position", "Object", "Array", });
    internal_static_Mysqlx_Expr_Identifier_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Expr_Identifier_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Identifier_descriptor,
        new java.lang.String[] { "Name", "SchemaName", });
    internal_static_Mysqlx_Expr_DocumentPathItem_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Expr_DocumentPathItem_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_DocumentPathItem_descriptor,
        new java.lang.String[] { "Type", "Value", "Index", });
    internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Expr_ColumnIdentifier_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor,
        new java.lang.String[] { "DocumentPath", "Name", "TableName", "SchemaName", });
    internal_static_Mysqlx_Expr_FunctionCall_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_Mysqlx_Expr_FunctionCall_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_FunctionCall_descriptor,
        new java.lang.String[] { "Name", "Param", });
    internal_static_Mysqlx_Expr_Operator_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_Mysqlx_Expr_Operator_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Operator_descriptor,
        new java.lang.String[] { "Name", "Param", });
    internal_static_Mysqlx_Expr_Object_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_Mysqlx_Expr_Object_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Object_descriptor,
        new java.lang.String[] { "Fld", });
    internal_static_Mysqlx_Expr_Object_ObjectField_descriptor =
      internal_static_Mysqlx_Expr_Object_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Expr_Object_ObjectField_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Object_ObjectField_descriptor,
        new java.lang.String[] { "Key", "Value", });
    internal_static_Mysqlx_Expr_Array_descriptor =
      getDescriptor().getMessageTypes().get(7);
    internal_static_Mysqlx_Expr_Array_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Array_descriptor,
        new java.lang.String[] { "Value", });
    com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
