/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.apache.http.protocol;

import java.io.IOException;
import org.apache.ambari.metrics.sink.relocated.apache.http.HttpEntity;
import org.apache.ambari.metrics.sink.relocated.apache.http.HttpEntityEnclosingRequest;
import org.apache.ambari.metrics.sink.relocated.apache.http.HttpException;
import org.apache.ambari.metrics.sink.relocated.apache.http.HttpRequest;
import org.apache.ambari.metrics.sink.relocated.apache.http.HttpRequestInterceptor;
import org.apache.ambari.metrics.sink.relocated.apache.http.HttpVersion;
import org.apache.ambari.metrics.sink.relocated.apache.http.ProtocolVersion;
import org.apache.ambari.metrics.sink.relocated.apache.http.annotation.Immutable;
import org.apache.ambari.metrics.sink.relocated.apache.http.protocol.HttpContext;
import org.apache.ambari.metrics.sink.relocated.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

