/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.curator;

import org.apache.ambari.metrics.sink.relocated.curator.ensemble.EnsembleProvider;
import org.apache.ambari.metrics.sink.relocated.curator.utils.ZookeeperFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.WatchedEvent;
import org.apache.ambari.metrics.sink.relocated.zookeeper.Watcher;
import org.apache.ambari.metrics.sink.relocated.zookeeper.ZooKeeper;

class HandleHolder {
    private final ZookeeperFactory zookeeperFactory;
    private final Watcher watcher;
    private final EnsembleProvider ensembleProvider;
    private final int sessionTimeout;
    private final boolean canBeReadOnly;
    private volatile Helper helper;

    HandleHolder(ZookeeperFactory zookeeperFactory, Watcher watcher, EnsembleProvider ensembleProvider, int sessionTimeout, boolean canBeReadOnly) {
        this.zookeeperFactory = zookeeperFactory;
        this.watcher = watcher;
        this.ensembleProvider = ensembleProvider;
        this.sessionTimeout = sessionTimeout;
        this.canBeReadOnly = canBeReadOnly;
    }

    ZooKeeper getZooKeeper() throws Exception {
        return this.helper != null ? this.helper.getZooKeeper() : null;
    }

    int getNegotiatedSessionTimeoutMs() {
        return this.helper != null ? this.helper.getNegotiatedSessionTimeoutMs() : 0;
    }

    String getConnectionString() {
        return this.helper != null ? this.helper.getConnectionString() : null;
    }

    String getNewConnectionString() {
        String helperConnectionString = this.helper != null ? this.helper.getConnectionString() : null;
        return helperConnectionString != null && !this.ensembleProvider.getConnectionString().equals(helperConnectionString) ? helperConnectionString : null;
    }

    void closeAndClear() throws Exception {
        this.internalClose();
        this.helper = null;
    }

    void closeAndReset() throws Exception {
        this.internalClose();
        this.helper = new Helper(){
            private volatile ZooKeeper zooKeeperHandle = null;
            private volatile String connectionString = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ZooKeeper getZooKeeper() throws Exception {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.zooKeeperHandle == null) {
                        this.connectionString = HandleHolder.this.ensembleProvider.getConnectionString();
                        this.zooKeeperHandle = HandleHolder.this.zookeeperFactory.newZooKeeper(this.connectionString, HandleHolder.this.sessionTimeout, HandleHolder.this.watcher, HandleHolder.this.canBeReadOnly);
                    }
                    HandleHolder.this.helper = new Helper(){

                        @Override
                        public ZooKeeper getZooKeeper() throws Exception {
                            return zooKeeperHandle;
                        }

                        @Override
                        public String getConnectionString() {
                            return connectionString;
                        }

                        @Override
                        public int getNegotiatedSessionTimeoutMs() {
                            return zooKeeperHandle != null ? zooKeeperHandle.getSessionTimeout() : 0;
                        }
                    };
                    return this.zooKeeperHandle;
                }
            }

            @Override
            public String getConnectionString() {
                return this.connectionString;
            }

            @Override
            public int getNegotiatedSessionTimeoutMs() {
                return this.zooKeeperHandle != null ? this.zooKeeperHandle.getSessionTimeout() : 0;
            }
        };
    }

    private void internalClose() throws Exception {
        try {
            ZooKeeper zooKeeper;
            ZooKeeper zooKeeper2 = zooKeeper = this.helper != null ? this.helper.getZooKeeper() : null;
            if (zooKeeper != null) {
                Watcher dummyWatcher = new Watcher(){

                    @Override
                    public void process(WatchedEvent event) {
                    }
                };
                zooKeeper.register(dummyWatcher);
                zooKeeper.close();
            }
        }
        catch (InterruptedException dummy) {
            Thread.currentThread().interrupt();
        }
    }

    private static interface Helper {
        public ZooKeeper getZooKeeper() throws Exception;

        public String getConnectionString();

        public int getNegotiatedSessionTimeoutMs();
    }
}

