/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.util.VerifyingFileFactory;

public class ZKConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ZKConfig.class);
    public static final String SSL_KEYSTORE_LOCATION = "zookeeper.ssl.keyStore.location";
    public static final String SSL_KEYSTORE_PASSWD = "zookeeper.ssl.keyStore.password";
    public static final String SSL_TRUSTSTORE_LOCATION = "zookeeper.ssl.trustStore.location";
    public static final String SSL_TRUSTSTORE_PASSWD = "zookeeper.ssl.trustStore.password";
    public static final String SSL_AUTHPROVIDER = "zookeeper.ssl.authProvider";
    public static final String JUTE_MAXBUFFER = "jute.maxbuffer";
    public static final String KINIT_COMMAND = "zookeeper.kinit";
    public static final String JGSS_NATIVE = "sun.security.jgss.native";
    private final Map<String, String> properties = new HashMap<String, String>();

    public ZKConfig() {
        this.init();
    }

    public ZKConfig(String configPath) throws QuorumPeerConfig.ConfigException {
        this(new File(configPath));
    }

    public ZKConfig(File configFile) throws QuorumPeerConfig.ConfigException {
        this();
        this.addConfiguration(configFile);
    }

    private void init() {
        this.handleBackwardCompatibility();
    }

    protected void handleBackwardCompatibility() {
        this.properties.put(SSL_KEYSTORE_LOCATION, System.getProperty(SSL_KEYSTORE_LOCATION));
        this.properties.put(SSL_KEYSTORE_PASSWD, System.getProperty(SSL_KEYSTORE_PASSWD));
        this.properties.put(SSL_TRUSTSTORE_LOCATION, System.getProperty(SSL_TRUSTSTORE_LOCATION));
        this.properties.put(SSL_TRUSTSTORE_PASSWD, System.getProperty(SSL_TRUSTSTORE_PASSWD));
        this.properties.put(SSL_AUTHPROVIDER, System.getProperty(SSL_AUTHPROVIDER));
        this.properties.put(JUTE_MAXBUFFER, System.getProperty(JUTE_MAXBUFFER));
        this.properties.put(KINIT_COMMAND, System.getProperty(KINIT_COMMAND));
        this.properties.put(JGSS_NATIVE, System.getProperty(JGSS_NATIVE));
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value == null ? defaultValue : value;
    }

    public String getJaasConfKey() {
        return System.getProperty("java.security.auth.login.config");
    }

    public void setProperty(String key, String value) {
        if (null == key) {
            throw new IllegalArgumentException("property key is null.");
        }
        String oldValue = this.properties.put(key, value);
        if (LOG.isDebugEnabled() && null != oldValue && !oldValue.equals(value)) {
            LOG.debug("key {}'s value {} is replaced with new value {}", key, oldValue, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguration(File configFile) throws QuorumPeerConfig.ConfigException {
        LOG.info("Reading configuration from: {}", (Object)configFile.getAbsolutePath());
        try {
            configFile = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().validate(configFile);
            Properties cfg = new Properties();
            try (FileInputStream in = new FileInputStream(configFile);){
                cfg.load(in);
            }
            this.parseProperties(cfg);
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.error("Error while configuration from: {}", (Object)configFile.getAbsolutePath(), (Object)e);
            throw new QuorumPeerConfig.ConfigException("Error while processing " + configFile.getAbsolutePath(), e);
        }
    }

    public void addConfiguration(String configPath) throws QuorumPeerConfig.ConfigException {
        this.addConfiguration(new File(configPath));
    }

    private void parseProperties(Properties cfg) {
        for (Map.Entry<Object, Object> entry : cfg.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            this.setProperty(key, value);
        }
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getProperty(key);
        if (value != null) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }
}

