/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.command;

import java.io.PrintWriter;
import org.apache.ambari.metrics.sink.relocated.zookeeper.Version;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ServerCnxn;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ServerStats;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ZKDatabase;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.command.AbstractFourLetterCommand;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.Leader;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.util.OSMXBean;

public class MonitorCommand
extends AbstractFourLetterCommand {
    MonitorCommand(PrintWriter pw, ServerCnxn serverCnxn) {
        super(pw, serverCnxn);
    }

    @Override
    public void commandRun() {
        if (!this.isZKServerRunning()) {
            this.pw.println("This ZooKeeper instance is not currently serving requests");
            return;
        }
        ZKDatabase zkdb = this.zkServer.getZKDatabase();
        ServerStats stats = this.zkServer.serverStats();
        this.print("version", Version.getFullVersion());
        this.print("avg_latency", stats.getAvgLatency());
        this.print("max_latency", stats.getMaxLatency());
        this.print("min_latency", stats.getMinLatency());
        this.print("packets_received", stats.getPacketsReceived());
        this.print("packets_sent", stats.getPacketsSent());
        this.print("num_alive_connections", stats.getNumAliveClientConnections());
        this.print("outstanding_requests", stats.getOutstandingRequests());
        this.print("server_state", stats.getServerState());
        this.print("znode_count", zkdb.getNodeCount());
        this.print("watch_count", zkdb.getDataTree().getWatchCount());
        this.print("ephemerals_count", zkdb.getDataTree().getEphemeralsCount());
        this.print("approximate_data_size", zkdb.getDataTree().approximateDataSize());
        OSMXBean osMbean = new OSMXBean();
        if (osMbean != null && osMbean.getUnix()) {
            this.print("open_file_descriptor_count", osMbean.getOpenFileDescriptorCount());
            this.print("max_file_descriptor_count", osMbean.getMaxFileDescriptorCount());
        }
        if (stats.getServerState().equals("leader")) {
            Leader leader = ((LeaderZooKeeperServer)this.zkServer).getLeader();
            this.print("followers", leader.getLearners().size());
            this.print("synced_followers", leader.getForwardingFollowers().size());
            this.print("pending_syncs", leader.getNumPendingSyncs());
        }
    }

    private void print(String key, long number) {
        this.print(key, "" + number);
    }

    private void print(String key, String value) {
        this.pw.print("zk_");
        this.pw.print(key);
        this.pw.print("\t");
        this.pw.println(value);
    }
}

