/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum;

import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.common.Time;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.LearnerSnapshot;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.SnapshotThrottleException;

public class LearnerSnapshotThrottler {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerSnapshotThrottler.class);
    private final Object snapCountSyncObject = new Object();
    private int snapsInProgress;
    private final int maxConcurrentSnapshots;
    private final long timeoutMillis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LearnerSnapshotThrottler(int maxConcurrentSnapshots, long timeoutMillis) {
        if (timeoutMillis < 0L) {
            String errorMsg = "timeout cannot be negative, was " + timeoutMillis;
            throw new IllegalArgumentException(errorMsg);
        }
        if (maxConcurrentSnapshots <= 0) {
            String errorMsg = "maxConcurrentSnapshots must be positive, was " + maxConcurrentSnapshots;
            throw new IllegalArgumentException(errorMsg);
        }
        this.maxConcurrentSnapshots = maxConcurrentSnapshots;
        this.timeoutMillis = timeoutMillis;
        Object object = this.snapCountSyncObject;
        synchronized (object) {
            this.snapsInProgress = 0;
        }
    }

    public LearnerSnapshotThrottler(int maxConcurrentSnapshots) {
        this(maxConcurrentSnapshots, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LearnerSnapshot beginSnapshot(boolean essential) throws SnapshotThrottleException, InterruptedException {
        int snapshotNumber;
        Object object = this.snapCountSyncObject;
        synchronized (object) {
            if (!essential && this.timeoutMillis > 0L && this.snapsInProgress >= this.maxConcurrentSnapshots) {
                long timestamp = Time.currentElapsedTime();
                do {
                    this.snapCountSyncObject.wait(this.timeoutMillis);
                } while (this.snapsInProgress >= this.maxConcurrentSnapshots && timestamp + this.timeoutMillis < Time.currentElapsedTime());
            }
            if (essential || this.snapsInProgress < this.maxConcurrentSnapshots) {
                ++this.snapsInProgress;
            } else {
                throw new SnapshotThrottleException(this.snapsInProgress + 1, this.maxConcurrentSnapshots);
            }
            snapshotNumber = this.snapsInProgress;
        }
        return new LearnerSnapshot(this, snapshotNumber, essential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSnapshot() {
        int newCount;
        Object object = this.snapCountSyncObject;
        synchronized (object) {
            --this.snapsInProgress;
            newCount = this.snapsInProgress;
            this.snapCountSyncObject.notify();
        }
        if (newCount < 0) {
            String errorMsg = "endSnapshot() called incorrectly; current snapshot count is " + newCount;
            LOG.error(errorMsg);
        }
    }
}

