/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum;

import org.apache.ambari.metrics.sink.relocated.zookeeper.jmx.ZKMBeanInfo;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.QuorumPeer;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.RemotePeerMXBean;

public class RemotePeerBean
implements RemotePeerMXBean,
ZKMBeanInfo {
    private QuorumPeer.QuorumServer peer;

    public RemotePeerBean(QuorumPeer.QuorumServer peer) {
        this.peer = peer;
    }

    public void setQuorumServer(QuorumPeer.QuorumServer peer) {
        this.peer = peer;
    }

    @Override
    public String getName() {
        return "replica." + this.peer.id;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getQuorumAddress() {
        return this.peer.addr.getHostString() + ":" + this.peer.addr.getPort();
    }

    @Override
    public String getElectionAddress() {
        return this.peer.electionAddr.getHostString() + ":" + this.peer.electionAddr.getPort();
    }

    @Override
    public String getClientAddress() {
        if (null == this.peer.clientAddr) {
            return "";
        }
        return this.peer.clientAddr.getHostString() + ":" + this.peer.clientAddr.getPort();
    }

    @Override
    public String getLearnerType() {
        return this.peer.type.toString();
    }
}

