/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.flexible;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.QuorumPeer;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.flexible.QuorumVerifier;

public class QuorumHierarchical
implements QuorumVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumHierarchical.class);
    private HashMap<Long, Long> serverWeight = new HashMap();
    private HashMap<Long, Long> serverGroup = new HashMap();
    private HashMap<Long, Long> groupWeight = new HashMap();
    private int numGroups = 0;
    private Map<Long, QuorumPeer.QuorumServer> allMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> participatingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> observingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private long version = 0L;

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof QuorumHierarchical)) {
            return false;
        }
        QuorumHierarchical qm = (QuorumHierarchical)o;
        if (qm.getVersion() == this.version) {
            return true;
        }
        if (this.allMembers.size() != qm.getAllMembers().size() || this.serverWeight.size() != qm.serverWeight.size() || this.groupWeight.size() != qm.groupWeight.size() || this.serverGroup.size() != qm.serverGroup.size()) {
            return false;
        }
        for (QuorumPeer.QuorumServer quorumServer : this.allMembers.values()) {
            QuorumPeer.QuorumServer qso = qm.getAllMembers().get(quorumServer.id);
            if (qso != null && quorumServer.equals(qso)) continue;
            return false;
        }
        for (Map.Entry entry : this.serverWeight.entrySet()) {
            if (((Long)entry.getValue()).equals(qm.serverWeight.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry entry : this.groupWeight.entrySet()) {
            if (((Long)entry.getValue()).equals(qm.groupWeight.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry entry : this.serverGroup.entrySet()) {
            if (((Long)entry.getValue()).equals(qm.serverGroup.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public QuorumHierarchical(String filename) throws QuorumPeerConfig.ConfigException {
        this.readConfigFile(filename);
    }

    public QuorumHierarchical(Properties qp) throws QuorumPeerConfig.ConfigException {
        this.parse(qp);
        LOG.info(this.serverWeight.size() + ", " + this.serverGroup.size() + ", " + this.groupWeight.size());
    }

    @Override
    public long getWeight(long id) {
        return this.serverWeight.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFile(String filename) throws QuorumPeerConfig.ConfigException {
        File configFile = new File(filename);
        LOG.info("Reading configuration from: " + configFile);
        try {
            if (!configFile.exists()) {
                throw new IllegalArgumentException(configFile.toString() + " file is missing");
            }
            Properties cfg = new Properties();
            try (FileInputStream in = new FileInputStream(configFile);){
                cfg.load(in);
            }
            this.parse(cfg);
        }
        catch (IOException e) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + filename, e);
        }
        catch (IllegalArgumentException e) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + filename, e);
        }
    }

    private void parse(Properties quorumProp) throws QuorumPeerConfig.ConfigException {
        for (Map.Entry<Object, Object> entry : quorumProp.entrySet()) {
            long sid;
            int dot;
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.startsWith("server.")) {
                dot = key.indexOf(46);
                sid = Long.parseLong(key.substring(dot + 1));
                QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(sid, value);
                this.allMembers.put(sid, qs);
                if (qs.type == QuorumPeer.LearnerType.PARTICIPANT) {
                    this.participatingMembers.put(sid, qs);
                    continue;
                }
                this.observingMembers.put(sid, qs);
                continue;
            }
            if (key.startsWith("group")) {
                String[] parts;
                dot = key.indexOf(46);
                long gid = Long.parseLong(key.substring(dot + 1));
                ++this.numGroups;
                for (String s : parts = value.split(":")) {
                    long sid2 = Long.parseLong(s);
                    if (this.serverGroup.containsKey(sid2)) {
                        throw new QuorumPeerConfig.ConfigException("Server " + sid2 + "is in multiple groups");
                    }
                    this.serverGroup.put(sid2, gid);
                }
                continue;
            }
            if (key.startsWith("weight")) {
                dot = key.indexOf(46);
                sid = Long.parseLong(key.substring(dot + 1));
                this.serverWeight.put(sid, Long.parseLong(value));
                continue;
            }
            if (!key.equals("version")) continue;
            this.version = Long.parseLong(value, 16);
        }
        for (QuorumPeer.QuorumServer qs : this.allMembers.values()) {
            Long id = qs.id;
            if (qs.type != QuorumPeer.LearnerType.PARTICIPANT) continue;
            if (!this.serverGroup.containsKey(id)) {
                throw new QuorumPeerConfig.ConfigException("Server " + id + "is not in a group");
            }
            if (this.serverWeight.containsKey(id)) continue;
            this.serverWeight.put(id, 1L);
        }
        this.computeGroupWeight();
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getAllMembers() {
        return this.allMembers;
    }

    @Override
    public String toString() {
        String value;
        String key;
        Long sid;
        StringWriter sw = new StringWriter();
        for (QuorumPeer.QuorumServer member : this.getAllMembers().values()) {
            String string = "server." + member.id;
            String value2 = member.toString();
            sw.append(string);
            sw.append('=');
            sw.append(value2);
            sw.append('\n');
        }
        HashMap<Long, String> groups = new HashMap<Long, String>();
        for (Map.Entry<Long, Long> entry : this.serverGroup.entrySet()) {
            sid = entry.getKey();
            Long gid = entry.getValue();
            String str = (String)groups.get(gid);
            str = str == null ? sid.toString() : str.concat(":").concat(sid.toString());
            groups.put(gid, str);
        }
        for (Map.Entry<Long, Long> entry : groups.entrySet()) {
            Long gid = entry.getKey();
            key = "group." + gid.toString();
            value = (String)((Object)entry.getValue());
            sw.append(key);
            sw.append('=');
            sw.append(value);
            sw.append('\n');
        }
        for (Map.Entry<Long, Long> entry : this.serverWeight.entrySet()) {
            sid = entry.getKey();
            key = "weight." + sid.toString();
            value = entry.getValue().toString();
            sw.append(key);
            sw.append('=');
            sw.append(value);
            sw.append('\n');
        }
        sw.append("version=" + Long.toHexString(this.version));
        return sw.toString();
    }

    private void computeGroupWeight() {
        for (Map.Entry<Long, Long> entry : this.serverGroup.entrySet()) {
            Long sid = entry.getKey();
            Long gid = entry.getValue();
            if (!this.groupWeight.containsKey(gid)) {
                this.groupWeight.put(gid, this.serverWeight.get(sid));
                continue;
            }
            long totalWeight = this.serverWeight.get(sid) + this.groupWeight.get(gid);
            this.groupWeight.put(gid, totalWeight);
        }
        Iterator<Object> i$ = this.groupWeight.values().iterator();
        while (i$.hasNext()) {
            long weight = (Long)i$.next();
            LOG.debug("Group weight: " + weight);
            if (weight != 0L) continue;
            --this.numGroups;
            LOG.debug("One zero-weight group: 1, " + this.numGroups);
        }
    }

    @Override
    public boolean containsQuorum(Set<Long> set) {
        Long gid;
        HashMap<Long, Long> expansion = new HashMap<Long, Long>();
        if (set.size() == 0) {
            return false;
        }
        LOG.debug("Set size: " + set.size());
        for (long sid : set) {
            gid = this.serverGroup.get(sid);
            if (gid == null) continue;
            if (!expansion.containsKey(gid)) {
                expansion.put(gid, this.serverWeight.get(sid));
                continue;
            }
            long totalWeight = this.serverWeight.get(sid) + (Long)expansion.get(gid);
            expansion.put(gid, totalWeight);
        }
        int majGroupCounter = 0;
        for (Map.Entry entry : expansion.entrySet()) {
            gid = (Long)entry.getKey();
            LOG.debug("Group info: {}, {}, {}", entry.getValue(), gid, this.groupWeight.get(gid));
            if ((Long)entry.getValue() <= this.groupWeight.get(gid) / 2L) continue;
            ++majGroupCounter;
        }
        LOG.debug("Majority group counter: {}, {}", (Object)majGroupCounter, (Object)this.numGroups);
        if (majGroupCounter > this.numGroups / 2) {
            LOG.debug("Positive set size: {}", (Object)set.size());
            return true;
        }
        LOG.debug("Negative set size: {}", (Object)set.size());
        return false;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getVotingMembers() {
        return this.participatingMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getObservingMembers() {
        return this.observingMembers;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long ver) {
        this.version = ver;
    }
}

