/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import java.io.IOException;
import org.apache.ambari.metrics.sink.relocated.jackson.annotate.JsonProperty;
import org.apache.ambari.metrics.sink.relocated.jackson.annotate.JsonSubTypes;
import org.apache.ambari.metrics.sink.relocated.jackson.map.ObjectMapper;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.sink.timeline.MetricClusterAggregate;
import org.apache.hadoop.metrics2.sink.timeline.MetricHostAggregate;

@JsonSubTypes(value={@JsonSubTypes.Type(value=MetricClusterAggregate.class), @JsonSubTypes.Type(value=MetricHostAggregate.class)})
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MetricAggregate {
    private static final ObjectMapper mapper = new ObjectMapper();
    protected Double sum = 0.0;
    protected Double deviation;
    protected Double max = Double.MIN_VALUE;
    protected Double min = Double.MAX_VALUE;

    public MetricAggregate() {
    }

    MetricAggregate(Double sum, Double deviation, Double max, Double min) {
        this.sum = sum;
        this.deviation = deviation;
        this.max = max;
        this.min = min;
    }

    public void updateSum(Double sum) {
        MetricAggregate metricAggregate = this;
        metricAggregate.sum = metricAggregate.sum + sum;
    }

    public void updateMax(Double max) {
        if (max > this.max) {
            this.max = max;
        }
    }

    public void updateMin(Double min) {
        if (min < this.min) {
            this.min = min;
        }
    }

    @JsonProperty(value="sum")
    public Double getSum() {
        return this.sum;
    }

    @JsonProperty(value="deviation")
    public Double getDeviation() {
        return this.deviation;
    }

    @JsonProperty(value="max")
    public Double getMax() {
        return this.max;
    }

    @JsonProperty(value="min")
    public Double getMin() {
        return this.min;
    }

    public void setSum(Double sum) {
        this.sum = sum;
    }

    public void setDeviation(Double deviation) {
        this.deviation = deviation;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public String toJSON() throws IOException {
        return mapper.writeValueAsString(this);
    }
}

