/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

public class SingleValuedTimelineMetric {
    private Double value;
    private String metricName;
    private String appId;
    private String instanceId;
    private String hostName;
    private Long startTime;

    public void setSingleTimeseriesValue(Long startTime, Double value) {
        this.startTime = startTime;
        this.value = value;
    }

    public SingleValuedTimelineMetric(String metricName, String appId, String instanceId, String hostName, long startTime) {
        this.metricName = metricName;
        this.appId = appId;
        this.instanceId = instanceId;
        this.hostName = hostName;
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Double getValue() {
        return this.value;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean equalsExceptTime(TimelineMetric metric) {
        if (!this.metricName.equals(metric.getMetricName())) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(metric.getHostName()) : metric.getHostName() != null) {
            return false;
        }
        if (this.appId != null ? !this.appId.equals(metric.getAppId()) : metric.getAppId() != null) {
            return false;
        }
        return !(this.instanceId != null ? !this.instanceId.equals(metric.getInstanceId()) : metric.getInstanceId() != null);
    }

    public TimelineMetric getTimelineMetric() {
        TimelineMetric metric = new TimelineMetric();
        metric.setMetricName(this.metricName);
        metric.setAppId(this.appId);
        metric.setHostName(this.hostName);
        metric.setInstanceId(this.instanceId);
        metric.setStartTime(this.startTime);
        metric.getMetricValues().put(this.startTime, this.value);
        return metric;
    }
}

