/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline.configuration;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    public final Log LOG = LogFactory.getLog(this.getClass());
    private final Properties properties = new Properties();

    public Configuration(String configFile) {
        InputStream inputStream = Configuration.class.getResourceAsStream(configFile);
        if (inputStream == null) {
            throw new IllegalArgumentException(configFile + " not found in classpath");
        }
        try {
            this.properties.load(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException fnf) {
            this.LOG.info("No configuration file " + configFile + " found in classpath.", fnf);
        }
        catch (IOException ie) {
            throw new IllegalArgumentException("Can't read configuration file " + configFile, ie);
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }
}

