/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.configcenter.DynamicConfiguration;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.integration.AbstractConfiguratorListener;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.directory.AbstractDirectory;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.protocol.InvokerWrapper;

public class RegistryDirectory<T>
extends AbstractDirectory<T>
implements NotifyListener {
    private static final Logger logger = LoggerFactory.getLogger(RegistryDirectory.class);
    private static final Cluster CLUSTER = ExtensionLoader.getExtensionLoader(Cluster.class).getAdaptiveExtension();
    private static final RouterFactory ROUTER_FACTORY = ExtensionLoader.getExtensionLoader(RouterFactory.class).getAdaptiveExtension();
    private final String serviceKey;
    private final Class<T> serviceType;
    private final Map<String, String> queryMap;
    private final URL directoryUrl;
    private final boolean multiGroup;
    private Protocol protocol;
    private Registry registry;
    private volatile boolean forbidden = false;
    private volatile URL overrideDirectoryUrl;
    private volatile URL registeredConsumerUrl;
    private volatile List<Configurator> configurators;
    private volatile Map<String, Invoker<T>> urlInvokerMap;
    private volatile List<Invoker<T>> invokers;
    private volatile Set<URL> cachedInvokerUrls;
    private static final ConsumerConfigurationListener CONSUMER_CONFIGURATION_LISTENER = new ConsumerConfigurationListener();
    private ReferenceConfigurationListener serviceConfigurationListener;

    public RegistryDirectory(Class<T> serviceType, URL url) {
        super(url);
        if (serviceType == null) {
            throw new IllegalArgumentException("service type is null.");
        }
        if (url.getServiceKey() == null || url.getServiceKey().length() == 0) {
            throw new IllegalArgumentException("registry serviceKey is null.");
        }
        this.serviceType = serviceType;
        this.serviceKey = url.getServiceKey();
        this.queryMap = StringUtils.parseQueryString(url.getParameterAndDecoded("refer"));
        this.overrideDirectoryUrl = this.directoryUrl = this.turnRegistryUrlToConsumerUrl(url);
        String group = this.directoryUrl.getParameter("group", "");
        this.multiGroup = group != null && ("*".equals(group) || group.contains(","));
    }

    private URL turnRegistryUrlToConsumerUrl(URL url) {
        String isDefault = url.getParameter("default");
        if (StringUtils.isNotEmpty(isDefault)) {
            this.queryMap.put("registry.default", isDefault);
        }
        return URLBuilder.from(url).setPath(url.getServiceInterface()).clearParameters().addParameters(this.queryMap).removeParameter("monitor").build();
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void subscribe(URL url) {
        this.setConsumerUrl(url);
        CONSUMER_CONFIGURATION_LISTENER.addNotifyListener(this);
        this.serviceConfigurationListener = new ReferenceConfigurationListener(this, url);
        this.registry.subscribe(url, this);
    }

    @Override
    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (this.getRegisteredConsumerUrl() != null && this.registry != null && this.registry.isAvailable()) {
                this.registry.unregister(this.getRegisteredConsumerUrl());
            }
        }
        catch (Throwable t) {
            logger.warn("unexpected error when unregister service " + this.serviceKey + "from registry" + this.registry.getUrl(), t);
        }
        try {
            if (this.getConsumerUrl() != null && this.registry != null && this.registry.isAvailable()) {
                this.registry.unsubscribe(this.getConsumerUrl(), this);
            }
            DynamicConfiguration.getDynamicConfiguration().removeListener(ApplicationModel.getApplication(), CONSUMER_CONFIGURATION_LISTENER);
        }
        catch (Throwable t) {
            logger.warn("unexpected error when unsubscribe service " + this.serviceKey + "from registry" + this.registry.getUrl(), t);
        }
        super.destroy();
        try {
            this.destroyAllInvokers();
        }
        catch (Throwable t) {
            logger.warn("Failed to destroy service " + this.serviceKey, t);
        }
    }

    @Override
    public synchronized void notify(List<URL> urls) {
        Map<String, List<URL>> categoryUrls = urls.stream().filter(Objects::nonNull).filter(this::isValidCategory).filter(this::isNotCompatibleFor26x).collect(Collectors.groupingBy(url -> {
            if (UrlUtils.isConfigurator(url)) {
                return "configurators";
            }
            if (UrlUtils.isRoute(url)) {
                return "routers";
            }
            if (UrlUtils.isProvider(url)) {
                return "providers";
            }
            return "";
        }));
        List<URL> configuratorURLs = categoryUrls.getOrDefault("configurators", Collections.emptyList());
        this.configurators = Configurator.toConfigurators(configuratorURLs).orElse(this.configurators);
        List<URL> routerURLs = categoryUrls.getOrDefault("routers", Collections.emptyList());
        this.toRouters(routerURLs).ifPresent(this::addRouters);
        List<URL> providerURLs = categoryUrls.getOrDefault("providers", Collections.emptyList());
        this.refreshOverrideAndInvoker(providerURLs);
    }

    private void refreshOverrideAndInvoker(List<URL> urls) {
        this.overrideDirectoryUrl();
        this.refreshInvoker(urls);
    }

    private void refreshInvoker(List<URL> invokerUrls) {
        Assert.notNull(invokerUrls, "invokerUrls should not be null");
        if (invokerUrls.size() == 1 && invokerUrls.get(0) != null && "empty".equals(invokerUrls.get(0).getProtocol())) {
            this.forbidden = true;
            this.invokers = Collections.emptyList();
            this.routerChain.setInvokers(this.invokers);
            this.destroyAllInvokers();
        } else {
            this.forbidden = false;
            Map<String, Invoker<T>> oldUrlInvokerMap = this.urlInvokerMap;
            if (invokerUrls == Collections.emptyList()) {
                invokerUrls = new ArrayList<URL>();
            }
            if (invokerUrls.isEmpty() && this.cachedInvokerUrls != null) {
                invokerUrls.addAll(this.cachedInvokerUrls);
            } else {
                this.cachedInvokerUrls = new HashSet<URL>();
                this.cachedInvokerUrls.addAll(invokerUrls);
            }
            if (invokerUrls.isEmpty()) {
                return;
            }
            Map<String, Invoker<T>> newUrlInvokerMap = this.toInvokers(invokerUrls);
            if (CollectionUtils.isEmptyMap(newUrlInvokerMap)) {
                logger.error(new IllegalStateException("urls to invokers error .invokerUrls.size :" + invokerUrls.size() + ", invoker.size :0. urls :" + invokerUrls.toString()));
                return;
            }
            List<Invoker<T>> newInvokers = Collections.unmodifiableList(new ArrayList<Invoker<T>>(newUrlInvokerMap.values()));
            this.routerChain.setInvokers(newInvokers);
            this.invokers = this.multiGroup ? this.toMergeInvokerList(newInvokers) : newInvokers;
            this.urlInvokerMap = newUrlInvokerMap;
            try {
                this.destroyUnusedInvokers(oldUrlInvokerMap, newUrlInvokerMap);
            }
            catch (Exception e) {
                logger.warn("destroyUnusedInvokers error. ", e);
            }
        }
    }

    private List<Invoker<T>> toMergeInvokerList(List<Invoker<T>> invokers) {
        ArrayList<Invoker<T>> mergedInvokers = new ArrayList();
        HashMap<String, List> groupMap = new HashMap<String, List>();
        for (Invoker<T> invoker : invokers) {
            String group = invoker.getUrl().getParameter("group", "");
            groupMap.computeIfAbsent(group, k -> new ArrayList());
            ((List)groupMap.get(group)).add(invoker);
        }
        if (groupMap.size() == 1) {
            mergedInvokers.addAll((Collection)groupMap.values().iterator().next());
        } else if (groupMap.size() > 1) {
            for (List groupList : groupMap.values()) {
                StaticDirectory staticDirectory = new StaticDirectory(groupList);
                staticDirectory.buildRouterChain();
                mergedInvokers.add(CLUSTER.join(staticDirectory));
            }
        } else {
            mergedInvokers = invokers;
        }
        return mergedInvokers;
    }

    private Optional<List<Router>> toRouters(List<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Router> routers = new ArrayList<Router>();
        for (URL url : urls) {
            if ("empty".equals(url.getProtocol())) continue;
            String routerType = url.getParameter("router");
            if (routerType != null && routerType.length() > 0) {
                url = url.setProtocol(routerType);
            }
            try {
                Router router = ROUTER_FACTORY.getRouter(url);
                if (routers.contains(router)) continue;
                routers.add(router);
            }
            catch (Throwable t) {
                logger.error("convert router url to router error, url: " + url, t);
            }
        }
        return Optional.of(routers);
    }

    private Map<String, Invoker<T>> toInvokers(List<URL> urls) {
        HashMap<String, Invoker<T>> newUrlInvokerMap = new HashMap<String, Invoker<T>>();
        if (urls == null || urls.isEmpty()) {
            return newUrlInvokerMap;
        }
        HashSet<String> keys = new HashSet<String>();
        String queryProtocols = this.queryMap.get("protocol");
        for (URL providerUrl : urls) {
            Invoker<T> invoker;
            if (queryProtocols != null && queryProtocols.length() > 0) {
                String[] acceptProtocols;
                boolean accept = false;
                for (String acceptProtocol : acceptProtocols = queryProtocols.split(",")) {
                    if (!providerUrl.getProtocol().equals(acceptProtocol)) continue;
                    accept = true;
                    break;
                }
                if (!accept) continue;
            }
            if ("empty".equals(providerUrl.getProtocol())) continue;
            if (!ExtensionLoader.getExtensionLoader(Protocol.class).hasExtension(providerUrl.getProtocol())) {
                logger.error(new IllegalStateException("Unsupported protocol " + providerUrl.getProtocol() + " in notified url: " + providerUrl + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost() + ", supported protocol: " + ExtensionLoader.getExtensionLoader(Protocol.class).getSupportedExtensions()));
                continue;
            }
            URL url = this.mergeUrl(providerUrl);
            String key = url.toFullString();
            if (keys.contains(key)) continue;
            keys.add(key);
            Map<String, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
            Invoker<T> invoker2 = invoker = localUrlInvokerMap == null ? null : localUrlInvokerMap.get(key);
            if (invoker == null) {
                try {
                    boolean enabled = true;
                    enabled = url.hasParameter("disabled") ? !url.getParameter("disabled", false) : url.getParameter("enabled", true);
                    if (enabled) {
                        invoker = new InvokerDelegate<T>(this.protocol.refer(this.serviceType, url), url, providerUrl);
                    }
                }
                catch (Throwable t) {
                    logger.error("Failed to refer invoker for interface:" + this.serviceType + ",url:(" + url + ")" + t.getMessage(), t);
                }
                if (invoker == null) continue;
                newUrlInvokerMap.put(key, invoker);
                continue;
            }
            newUrlInvokerMap.put(key, invoker);
        }
        keys.clear();
        return newUrlInvokerMap;
    }

    private URL mergeUrl(URL providerUrl) {
        String path;
        providerUrl = ClusterUtils.mergeUrl(providerUrl, this.queryMap);
        providerUrl = this.overrideWithConfigurator(providerUrl);
        providerUrl = providerUrl.addParameter("check", String.valueOf(false));
        this.overrideDirectoryUrl = this.overrideDirectoryUrl.addParametersIfAbsent(providerUrl.getParameters());
        if ((providerUrl.getPath() == null || providerUrl.getPath().length() == 0) && "dubbo".equals(providerUrl.getProtocol()) && (path = this.directoryUrl.getParameter("interface")) != null) {
            int i = path.indexOf(47);
            if (i >= 0) {
                path = path.substring(i + 1);
            }
            if ((i = path.lastIndexOf(58)) >= 0) {
                path = path.substring(0, i);
            }
            providerUrl = providerUrl.setPath(path);
        }
        return providerUrl;
    }

    private URL overrideWithConfigurator(URL providerUrl) {
        providerUrl = this.overrideWithConfigurators(this.configurators, providerUrl);
        providerUrl = this.overrideWithConfigurators(CONSUMER_CONFIGURATION_LISTENER.getConfigurators(), providerUrl);
        if (this.serviceConfigurationListener != null) {
            providerUrl = this.overrideWithConfigurators(this.serviceConfigurationListener.getConfigurators(), providerUrl);
        }
        return providerUrl;
    }

    private URL overrideWithConfigurators(List<Configurator> configurators, URL url) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            for (Configurator configurator : configurators) {
                url = configurator.configure(url);
            }
        }
        return url;
    }

    private void destroyAllInvokers() {
        Map<String, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                try {
                    invoker.destroy();
                }
                catch (Throwable t) {
                    logger.warn("Failed to destroy service " + this.serviceKey + " to provider " + invoker.getUrl(), t);
                }
            }
            localUrlInvokerMap.clear();
        }
        this.invokers = null;
    }

    private void destroyUnusedInvokers(Map<String, Invoker<T>> oldUrlInvokerMap, Map<String, Invoker<T>> newUrlInvokerMap) {
        if (newUrlInvokerMap == null || newUrlInvokerMap.size() == 0) {
            this.destroyAllInvokers();
            return;
        }
        ArrayList<String> deleted = null;
        if (oldUrlInvokerMap != null) {
            Collection<Invoker<T>> newInvokers = newUrlInvokerMap.values();
            for (Map.Entry<String, Invoker<T>> entry : oldUrlInvokerMap.entrySet()) {
                if (newInvokers.contains(entry.getValue())) continue;
                if (deleted == null) {
                    deleted = new ArrayList<String>();
                }
                deleted.add(entry.getKey());
            }
        }
        if (deleted != null) {
            for (String url : deleted) {
                Invoker<T> invoker;
                if (url == null || (invoker = oldUrlInvokerMap.remove(url)) == null) continue;
                try {
                    invoker.destroy();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("destroy invoker[" + invoker.getUrl() + "] success. ");
                }
                catch (Exception e) {
                    logger.warn("destroy invoker[" + invoker.getUrl() + "] failed. " + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public List<Invoker<T>> doList(Invocation invocation) {
        if (this.forbidden) {
            throw new RpcException(4, "No provider available from registry " + this.getUrl().getAddress() + " for service " + this.getConsumerUrl().getServiceKey() + " on consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please check status of providers(disabled, not registered or in blacklist).");
        }
        if (this.multiGroup) {
            return this.invokers == null ? Collections.emptyList() : this.invokers;
        }
        List invokers = null;
        try {
            invokers = this.routerChain.route(this.getConsumerUrl(), invocation);
        }
        catch (Throwable t) {
            logger.error("Failed to execute router: " + this.getUrl() + ", cause: " + t.getMessage(), t);
        }
        return invokers == null ? Collections.emptyList() : invokers;
    }

    @Override
    public Class<T> getInterface() {
        return this.serviceType;
    }

    @Override
    public URL getUrl() {
        return this.overrideDirectoryUrl;
    }

    public URL getRegisteredConsumerUrl() {
        return this.registeredConsumerUrl;
    }

    public void setRegisteredConsumerUrl(URL registeredConsumerUrl) {
        this.registeredConsumerUrl = registeredConsumerUrl;
    }

    @Override
    public boolean isAvailable() {
        if (this.isDestroyed()) {
            return false;
        }
        Map<String, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null && localUrlInvokerMap.size() > 0) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                if (!invoker.isAvailable()) continue;
                return true;
            }
        }
        return false;
    }

    public void buildRouterChain(URL url) {
        this.setRouterChain(RouterChain.buildChain(url));
    }

    public Map<String, Invoker<T>> getUrlInvokerMap() {
        return this.urlInvokerMap;
    }

    public List<Invoker<T>> getInvokers() {
        return this.invokers;
    }

    private boolean isValidCategory(URL url) {
        String category = url.getParameter("category", "providers");
        if ("routers".equals(category) || "route".equals(url.getProtocol()) || "providers".equals(category) || "configurators".equals(category) || "dynamicconfigurators".equals(category) || "appdynamicconfigurators".equals(category)) {
            return true;
        }
        logger.warn("Unsupported category " + category + " in notified url: " + url + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost());
        return false;
    }

    private boolean isNotCompatibleFor26x(URL url) {
        return StringUtils.isEmpty(url.getParameter("compatible_config"));
    }

    private void overrideDirectoryUrl() {
        this.overrideDirectoryUrl = this.directoryUrl;
        List<Configurator> localConfigurators = this.configurators;
        this.doOverrideUrl(localConfigurators);
        List<Configurator> localAppDynamicConfigurators = CONSUMER_CONFIGURATION_LISTENER.getConfigurators();
        this.doOverrideUrl(localAppDynamicConfigurators);
        if (this.serviceConfigurationListener != null) {
            List<Configurator> localDynamicConfigurators = this.serviceConfigurationListener.getConfigurators();
            this.doOverrideUrl(localDynamicConfigurators);
        }
    }

    private void doOverrideUrl(List<Configurator> configurators) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            for (Configurator configurator : configurators) {
                this.overrideDirectoryUrl = configurator.configure(this.overrideDirectoryUrl);
            }
        }
    }

    private static class ConsumerConfigurationListener
    extends AbstractConfiguratorListener {
        List<RegistryDirectory> listeners = new ArrayList<RegistryDirectory>();

        ConsumerConfigurationListener() {
            this.initWith(ApplicationModel.getApplication() + ".configurators");
        }

        void addNotifyListener(RegistryDirectory listener) {
            this.listeners.add(listener);
        }

        @Override
        protected void notifyOverrides() {
            this.listeners.forEach(listener -> ((RegistryDirectory)listener).refreshInvoker(Collections.emptyList()));
        }
    }

    private static class ReferenceConfigurationListener
    extends AbstractConfiguratorListener {
        private RegistryDirectory directory;
        private URL url;

        ReferenceConfigurationListener(RegistryDirectory directory, URL url) {
            this.directory = directory;
            this.url = url;
            this.initWith(url.getEncodedServiceKey() + ".configurators");
        }

        @Override
        protected void notifyOverrides() {
            this.directory.refreshInvoker(Collections.emptyList());
        }
    }

    private static class InvokerDelegate<T>
    extends InvokerWrapper<T> {
        private URL providerUrl;

        public InvokerDelegate(Invoker<T> invoker, URL url, URL providerUrl) {
            super(invoker, url);
            this.providerUrl = providerUrl;
        }

        public URL getProviderUrl() {
            return this.providerUrl;
        }
    }
}

