/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import java.util.Properties;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.nacos.NacosRegistry;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRegistryFactory
extends AbstractRegistryFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    protected Registry createRegistry(URL url) {
        return new NacosRegistry(url, this.buildNamingService(url));
    }

    private NamingService buildNamingService(URL url) {
        NamingService namingService;
        Properties nacosProperties = this.buildNacosProperties(url);
        try {
            namingService = NacosFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getErrMsg(), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
        return namingService;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        this.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private void setProperties(URL url, Properties properties) {
        this.putPropertyIfAbsent(url, properties, "namespace");
        this.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename");
        this.putPropertyIfAbsent(url, properties, "endpoint");
        this.putPropertyIfAbsent(url, properties, "accessKey");
        this.putPropertyIfAbsent(url, properties, "secretKey");
        this.putPropertyIfAbsent(url, properties, "clusterName");
    }

    private void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }
}

