/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.injvm;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.DelegateExporterMap;
import org.apache.dubbo.rpc.protocol.injvm.InjvmExporter;
import org.apache.dubbo.rpc.protocol.injvm.InjvmInvoker;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class InjvmProtocol
extends AbstractProtocol
implements Protocol {
    public static final String NAME = "injvm";
    public static final int DEFAULT_PORT = 0;
    private static InjvmProtocol INSTANCE;

    public InjvmProtocol() {
        INSTANCE = this;
    }

    public static InjvmProtocol getInjvmProtocol() {
        if (INSTANCE == null) {
            ExtensionLoader.getExtensionLoader(Protocol.class).getExtension(NAME);
        }
        return INSTANCE;
    }

    static Exporter<?> getExporter(DelegateExporterMap delegateExporterMap, URL key) {
        Exporter result = null;
        if (!key.getServiceKey().contains("*")) {
            result = delegateExporterMap.getExport(key.getServiceKey());
        } else if (!delegateExporterMap.isEmpty()) {
            for (Exporter exporter : delegateExporterMap.getExporters()) {
                if (!UrlUtils.isServiceKeyMatch((URL)key, (URL)exporter.getInvoker().getUrl())) continue;
                result = exporter;
                break;
            }
        }
        if (result == null) {
            return null;
        }
        if (ProtocolUtils.isGeneric((String)result.getInvoker().getUrl().getParameter("generic"))) {
            return null;
        }
        return result;
    }

    public int getDefaultPort() {
        return 0;
    }

    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        String serviceKey = invoker.getUrl().getServiceKey();
        InjvmExporter<T> tInjvmExporter = new InjvmExporter<T>(invoker, serviceKey, this.exporterMap);
        this.exporterMap.addExportMap(serviceKey, tInjvmExporter);
        return tInjvmExporter;
    }

    public <T> Invoker<T> protocolBindingRefer(Class<T> serviceType, URL url) throws RpcException {
        return new InjvmInvoker<T>(serviceType, url, url.getServiceKey(), this.exporterMap);
    }

    public boolean isInjvmRefer(URL url) {
        String scope = url.getParameter("scope");
        if ("local".equals(scope) || url.getParameter(NAME, false)) {
            return true;
        }
        if ("remote".equals(scope)) {
            return false;
        }
        if (url.getParameter("generic", false)) {
            return false;
        }
        if (InjvmProtocol.getExporter(this.exporterMap, url) != null) {
            return !"broadcast".equalsIgnoreCase(url.getParameter("cluster"));
        }
        return false;
    }
}

