/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.internal.AbstractJdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.options.JdbcInsertOptions;
import org.apache.flink.connector.jdbc.utils.JdbcUtils;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JDBCOutputFormat
extends AbstractJdbcOutputFormat<Row> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JDBCOutputFormat.class);
    final JdbcInsertOptions insertOptions;
    private final JdbcExecutionOptions batchOptions;
    private transient PreparedStatement upload;
    private transient int batchCount = 0;

    @Deprecated
    public JDBCOutputFormat(String username, String password, String drivername, String dbURL, String query, int batchInterval, int[] typesArray) {
        this(new SimpleJdbcConnectionProvider(new JdbcConnectionOptions.JdbcConnectionOptionsBuilder().withUrl(dbURL).withDriverName(drivername).withUsername(username).withPassword(password).build()), new JdbcInsertOptions(query, typesArray), JdbcExecutionOptions.builder().withBatchSize(batchInterval).build());
    }

    private JDBCOutputFormat(JdbcConnectionProvider connectionProvider, JdbcInsertOptions insertOptions, JdbcExecutionOptions batchOptions) {
        super(connectionProvider);
        this.insertOptions = insertOptions;
        this.batchOptions = batchOptions;
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        try {
            this.upload = this.connection.prepareStatement(this.insertOptions.getQuery());
        }
        catch (SQLException sqe) {
            throw new IOException("open() failed.", sqe);
        }
    }

    public void writeRecord(Row row) {
        try {
            JdbcUtils.setRecordToStatement(this.upload, this.insertOptions.getFieldTypes(), row);
            this.upload.addBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Preparation of JDBC statement failed.", e);
        }
        ++this.batchCount;
        if (this.batchCount >= this.batchOptions.getBatchSize()) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        try {
            this.upload.executeBatch();
            this.batchCount = 0;
        }
        catch (SQLException e) {
            throw new RuntimeException("Execution of JDBC statement failed.", e);
        }
    }

    int[] getTypesArray() {
        return this.insertOptions.getFieldTypes();
    }

    @Override
    public void close() {
        if (this.upload != null) {
            this.flush();
            try {
                this.upload.close();
            }
            catch (SQLException e) {
                LOG.info("JDBC statement could not be closed: " + e.getMessage());
            }
            finally {
                this.upload = null;
            }
        }
        super.close();
    }

    public static JDBCOutputFormatBuilder buildJDBCOutputFormat() {
        return new JDBCOutputFormatBuilder();
    }

    public int[] getFieldTypes() {
        return this.insertOptions.getFieldTypes();
    }

    public static class JDBCOutputFormatBuilder {
        private String username;
        private String password;
        private String drivername;
        private String dbURL;
        private String query;
        private int batchInterval = 5000;
        private int[] typesArray;

        protected JDBCOutputFormatBuilder() {
        }

        public JDBCOutputFormatBuilder setUsername(String username) {
            this.username = username;
            return this;
        }

        public JDBCOutputFormatBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public JDBCOutputFormatBuilder setDrivername(String drivername) {
            this.drivername = drivername;
            return this;
        }

        public JDBCOutputFormatBuilder setDBUrl(String dbURL) {
            this.dbURL = dbURL;
            return this;
        }

        public JDBCOutputFormatBuilder setQuery(String query) {
            this.query = query;
            return this;
        }

        public JDBCOutputFormatBuilder setBatchInterval(int batchInterval) {
            this.batchInterval = batchInterval;
            return this;
        }

        public JDBCOutputFormatBuilder setSqlTypes(int[] typesArray) {
            this.typesArray = typesArray;
            return this;
        }

        public JDBCOutputFormat finish() {
            return new JDBCOutputFormat(new SimpleJdbcConnectionProvider(this.buildConnectionOptions()), new JdbcInsertOptions(this.query, this.typesArray), JdbcExecutionOptions.builder().withBatchSize(this.batchInterval).build());
        }

        public JdbcConnectionOptions buildConnectionOptions() {
            if (this.username == null) {
                LOG.info("Username was not supplied.");
            }
            if (this.password == null) {
                LOG.info("Password was not supplied.");
            }
            return new JdbcConnectionOptions.JdbcConnectionOptionsBuilder().withUrl(this.dbURL).withDriverName(this.drivername).withUsername(this.username).withPassword(this.password).build();
        }
    }
}

