/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJdbcConnectionProvider
implements JdbcConnectionProvider,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleJdbcConnectionProvider.class);
    private static final long serialVersionUID = 1L;
    private final JdbcConnectionOptions jdbcOptions;
    private volatile transient Connection connection;

    public SimpleJdbcConnectionProvider(JdbcConnectionOptions jdbcOptions) {
        this.jdbcOptions = jdbcOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException, ClassNotFoundException {
        if (this.connection == null) {
            SimpleJdbcConnectionProvider simpleJdbcConnectionProvider = this;
            synchronized (simpleJdbcConnectionProvider) {
                if (this.connection == null) {
                    Class.forName(this.jdbcOptions.getDriverName());
                    this.connection = this.jdbcOptions.getUsername().isPresent() ? DriverManager.getConnection(this.jdbcOptions.getDbURL(), this.jdbcOptions.getUsername().get(), this.jdbcOptions.getPassword().orElse(null)) : DriverManager.getConnection(this.jdbcOptions.getDbURL());
                }
            }
        }
        return this.connection;
    }

    @Override
    public Connection reestablishConnection() throws SQLException, ClassNotFoundException {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            LOG.info("JDBC connection close failed.", (Throwable)e);
        }
        finally {
            this.connection = null;
        }
        this.connection = this.getConnection();
        return this.connection;
    }
}

