/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.options;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialects;
import org.apache.flink.util.Preconditions;

public class JdbcOptions
extends JdbcConnectionOptions {
    private static final long serialVersionUID = 1L;
    public static final int CONNECTION_CHECK_TIMEOUT_SECONDS = 60;
    private String tableName;
    private JdbcDialect dialect;

    private JdbcOptions(String dbURL, String tableName, String driverName, String username, String password, JdbcDialect dialect) {
        super(dbURL, driverName, username, password);
        this.tableName = tableName;
        this.dialect = dialect;
    }

    public String getTableName() {
        return this.tableName;
    }

    public JdbcDialect getDialect() {
        return this.dialect;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o instanceof JdbcOptions) {
            JdbcOptions options = (JdbcOptions)o;
            return Objects.equals(this.url, options.url) && Objects.equals(this.tableName, options.tableName) && Objects.equals(this.driverName, options.driverName) && Objects.equals(this.username, options.username) && Objects.equals(this.password, options.password) && Objects.equals(this.dialect.getClass().getName(), options.dialect.getClass().getName());
        }
        return false;
    }

    public static class Builder {
        private String dbURL;
        private String tableName;
        private String driverName;
        private String username;
        private String password;
        private JdbcDialect dialect;

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setDriverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public Builder setDBUrl(String dbURL) {
            this.dbURL = dbURL;
            return this;
        }

        public Builder setDialect(JdbcDialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public JdbcOptions build() {
            Optional<Object> optional;
            Preconditions.checkNotNull((Object)this.dbURL, (String)"No dbURL supplied.");
            Preconditions.checkNotNull((Object)this.tableName, (String)"No tableName supplied.");
            if (this.dialect == null) {
                optional = JdbcDialects.get(this.dbURL);
                this.dialect = optional.orElseGet(() -> {
                    throw new NullPointerException("Unknown dbURL,can not find proper dialect.");
                });
            }
            if (this.driverName == null) {
                optional = this.dialect.defaultDriverName();
                this.driverName = optional.orElseGet(() -> {
                    throw new NullPointerException("No driverName supplied.");
                });
            }
            return new JdbcOptions(this.dbURL, this.tableName, this.driverName, this.username, this.password, this.dialect);
        }
    }
}

