/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.JdbcBatchingOutputFormat;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.internal.executor.BufferReduceStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.InsertOrUpdateJdbcExecutor;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class JdbcDynamicOutputFormatBuilder
implements Serializable {
    private JdbcOptions jdbcOptions;
    private JdbcExecutionOptions executionOptions;
    private JdbcDmlOptions dmlOptions;
    private TypeInformation<RowData> rowDataTypeInformation;
    private DataType[] fieldDataTypes;

    public JdbcDynamicOutputFormatBuilder setJdbcOptions(JdbcOptions jdbcOptions) {
        this.jdbcOptions = jdbcOptions;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setJdbcExecutionOptions(JdbcExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setJdbcDmlOptions(JdbcDmlOptions dmlOptions) {
        this.dmlOptions = dmlOptions;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setRowDataTypeInfo(TypeInformation<RowData> rowDataTypeInfo) {
        this.rowDataTypeInformation = rowDataTypeInfo;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setFieldDataTypes(DataType[] fieldDataTypes) {
        this.fieldDataTypes = fieldDataTypes;
        return this;
    }

    public JdbcBatchingOutputFormat<RowData, ?, ?> build() {
        Preconditions.checkNotNull((Object)this.jdbcOptions, (String)"jdbc options can not be null");
        Preconditions.checkNotNull((Object)this.dmlOptions, (String)"jdbc dml options can not be null");
        Preconditions.checkNotNull((Object)this.executionOptions, (String)"jdbc execution options can not be null");
        LogicalType[] logicalTypes = (LogicalType[])Arrays.stream(this.fieldDataTypes).map(DataType::getLogicalType).toArray(LogicalType[]::new);
        if (this.dmlOptions.getKeyFields().isPresent() && this.dmlOptions.getKeyFields().get().length > 0) {
            return new JdbcBatchingOutputFormat(new SimpleJdbcConnectionProvider(this.jdbcOptions), this.executionOptions, ctx -> JdbcDynamicOutputFormatBuilder.createBufferReduceExecutor(this.dmlOptions, ctx, this.rowDataTypeInformation, logicalTypes), JdbcBatchingOutputFormat.RecordExtractor.identity());
        }
        String sql = this.dmlOptions.getDialect().getInsertIntoStatement(this.dmlOptions.getTableName(), this.dmlOptions.getFieldNames());
        return new JdbcBatchingOutputFormat(new SimpleJdbcConnectionProvider(this.jdbcOptions), this.executionOptions, ctx -> JdbcDynamicOutputFormatBuilder.createSimpleRowDataExecutor(this.dmlOptions.getDialect(), sql, logicalTypes, ctx, this.rowDataTypeInformation), JdbcBatchingOutputFormat.RecordExtractor.identity());
    }

    private static JdbcBatchStatementExecutor<RowData> createBufferReduceExecutor(JdbcDmlOptions opt, RuntimeContext ctx, TypeInformation<RowData> rowDataTypeInfo, LogicalType[] fieldTypes) {
        Preconditions.checkArgument((boolean)opt.getKeyFields().isPresent());
        int[] pkFields = Arrays.stream((Object[])opt.getKeyFields().get()).mapToInt(Arrays.asList(opt.getFieldNames())::indexOf).toArray();
        LogicalType[] pkTypes = (LogicalType[])Arrays.stream(pkFields).mapToObj(f -> fieldTypes[f]).toArray(LogicalType[]::new);
        TypeSerializer typeSerializer = rowDataTypeInfo.createSerializer(ctx.getExecutionConfig());
        Function<RowData, RowData> valueTransform = ctx.getExecutionConfig().isObjectReuseEnabled() ? arg_0 -> ((TypeSerializer)typeSerializer).copy(arg_0) : Function.identity();
        JdbcBatchStatementExecutor<RowData> upsertExecutor = JdbcDynamicOutputFormatBuilder.createUpsertRowExecutor(opt, ctx, rowDataTypeInfo, pkFields, pkTypes, fieldTypes, valueTransform);
        JdbcBatchStatementExecutor<RowData> deleteExecutor = JdbcDynamicOutputFormatBuilder.createDeleteExecutor(opt, pkFields, pkTypes, fieldTypes);
        return new BufferReduceStatementExecutor(upsertExecutor, deleteExecutor, JdbcDynamicOutputFormatBuilder.createRowKeyExtractor(fieldTypes, pkFields), valueTransform);
    }

    private static JdbcBatchStatementExecutor<RowData> createUpsertRowExecutor(JdbcDmlOptions opt, RuntimeContext ctx, TypeInformation<RowData> rowDataTypeInfo, int[] pkFields, LogicalType[] pkTypes, LogicalType[] fieldTypes, Function<RowData, RowData> valueTransform) {
        Preconditions.checkArgument((boolean)opt.getKeyFields().isPresent());
        JdbcDialect dialect = opt.getDialect();
        return opt.getDialect().getUpsertStatement(opt.getTableName(), opt.getFieldNames(), opt.getKeyFields().get()).map(sql -> JdbcDynamicOutputFormatBuilder.createSimpleRowDataExecutor(dialect, sql, fieldTypes, ctx, rowDataTypeInfo)).orElseGet(() -> new InsertOrUpdateJdbcExecutor<RowData, RowData, RowData>(opt.getDialect().getRowExistsStatement(opt.getTableName(), opt.getKeyFields().get()), opt.getDialect().getInsertIntoStatement(opt.getTableName(), opt.getFieldNames()), opt.getDialect().getUpdateStatement(opt.getTableName(), opt.getFieldNames(), opt.getKeyFields().get()), JdbcDynamicOutputFormatBuilder.createRowDataJdbcStatementBuilder(dialect, pkTypes), JdbcDynamicOutputFormatBuilder.createRowDataJdbcStatementBuilder(dialect, fieldTypes), JdbcDynamicOutputFormatBuilder.createRowDataJdbcStatementBuilder(dialect, fieldTypes), JdbcDynamicOutputFormatBuilder.createRowKeyExtractor(fieldTypes, pkFields), valueTransform));
    }

    private static JdbcBatchStatementExecutor<RowData> createDeleteExecutor(JdbcDmlOptions dmlOptions, int[] pkFields, LogicalType[] pkTypes, LogicalType[] fieldTypes) {
        Preconditions.checkArgument((boolean)dmlOptions.getKeyFields().isPresent());
        String[] pkNames = (String[])Arrays.stream(pkFields).mapToObj(k -> dmlOptions.getFieldNames()[k]).toArray(String[]::new);
        String deleteSql = dmlOptions.getDialect().getDeleteStatement(dmlOptions.getTableName(), pkNames);
        JdbcRowConverter rowConverter = dmlOptions.getDialect().getRowConverter(RowType.of((LogicalType[])pkTypes));
        Function<RowData, RowData> keyExtractor = JdbcDynamicOutputFormatBuilder.createRowKeyExtractor(fieldTypes, pkFields);
        return JdbcBatchStatementExecutor.keyed(deleteSql, keyExtractor, (st, key) -> rowConverter.toExternal((RowData)key, (PreparedStatement)st));
    }

    private static Function<RowData, RowData> createRowKeyExtractor(LogicalType[] logicalTypes, int[] pkFields) {
        RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[pkFields.length];
        for (int i = 0; i < pkFields.length; ++i) {
            fieldGetters[i] = RowData.createFieldGetter((LogicalType)logicalTypes[pkFields[i]], (int)pkFields[i]);
        }
        return row -> JdbcDynamicOutputFormatBuilder.getPrimaryKey(row, fieldGetters);
    }

    private static JdbcBatchStatementExecutor<RowData> createSimpleRowDataExecutor(JdbcDialect dialect, String sql, LogicalType[] fieldTypes, RuntimeContext ctx, TypeInformation<RowData> rowDataTypeInfo) {
        TypeSerializer typeSerializer = rowDataTypeInfo.createSerializer(ctx.getExecutionConfig());
        return JdbcBatchStatementExecutor.simple(sql, JdbcDynamicOutputFormatBuilder.createRowDataJdbcStatementBuilder(dialect, fieldTypes), ctx.getExecutionConfig().isObjectReuseEnabled() ? arg_0 -> ((TypeSerializer)typeSerializer).copy(arg_0) : Function.identity());
    }

    private static JdbcStatementBuilder<RowData> createRowDataJdbcStatementBuilder(JdbcDialect dialect, LogicalType[] types) {
        JdbcRowConverter converter = dialect.getRowConverter(RowType.of((LogicalType[])types));
        return (st, record) -> converter.toExternal((RowData)record, (PreparedStatement)st);
    }

    private static RowData getPrimaryKey(RowData row, RowData.FieldGetter[] fieldGetters) {
        GenericRowData pkRow = new GenericRowData(fieldGetters.length);
        for (int i = 0; i < fieldGetters.length; ++i) {
            pkRow.setField(i, fieldGetters[i].getFieldOrNull(row));
        }
        return pkRow;
    }
}

