/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Map;
import org.apache.flink.table.descriptors.CatalogDescriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class JdbcCatalogDescriptor
extends CatalogDescriptor {
    private final String defaultDatabase;
    private final String username;
    private final String pwd;
    private final String baseUrl;

    public JdbcCatalogDescriptor(String defaultDatabase, String username, String pwd, String baseUrl) {
        super("jdbc", 1);
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)defaultDatabase) ? 1 : 0) != 0);
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)username) ? 1 : 0) != 0);
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)pwd) ? 1 : 0) != 0);
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)baseUrl) ? 1 : 0) != 0);
        this.defaultDatabase = defaultDatabase;
        this.username = username;
        this.pwd = pwd;
        this.baseUrl = baseUrl;
    }

    protected Map<String, String> toCatalogProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("default-database", this.defaultDatabase);
        properties.putString("username", this.username);
        properties.putString("password", this.pwd);
        properties.putString("base-url", this.baseUrl);
        return properties.asMap();
    }
}

