/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;

@PublicEvolving
public class ResourceManagerOptions {
    public static final ConfigOption<String> JOB_TIMEOUT = ConfigOptions.key("resourcemanager.job.timeout").defaultValue("5 minutes").withDescription("Timeout for jobs which don't have a job manager as leader assigned.");
    @Deprecated
    public static final ConfigOption<Integer> LOCAL_NUMBER_RESOURCE_MANAGER = ConfigOptions.key("local.number-resourcemanager").defaultValue(1).withDescription("The number of resource managers start.");
    public static final ConfigOption<Integer> IPC_PORT = ConfigOptions.key("resourcemanager.rpc.port").defaultValue(0).withDescription("Defines the network port to connect to for communication with the resource manager. By default, the port of the JobManager, because the same ActorSystem is used. Its not possible to use this configuration key to define port ranges.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Integer> MAX_SLOT_NUM = ConfigOptions.key("slotmanager.number-of-slots.max").intType().defaultValue(Integer.MAX_VALUE).withDescription("Defines the maximum number of slots that the Flink cluster allocates. This configuration option is meant for limiting the resource consumption for batch workloads. It is not recommended to configure this option for streaming workloads, which may fail if there are not enough slots. Note that this configuration option does not take effect for standalone clusters, where how many slots are allocated is not controlled by Flink.");
    public static final ConfigOption<Integer> REDUNDANT_TASK_MANAGER_NUM = ConfigOptions.key("slotmanager.redundant-taskmanager-num").intType().defaultValue(0).withDescription("The number of redundant task managers. Redundant task managers are extra task managers started by Flink, in order to speed up job recovery in case of failures due to task manager lost. Note that this feature is available only to the active deployments (native K8s, Yarn and Mesos).");
    @Deprecated
    public static final ConfigOption<Long> SLOT_REQUEST_TIMEOUT = ConfigOptions.key("slotmanager.request-timeout").defaultValue(-1L).withDescription("The timeout for a slot request to be discarded.");
    public static final ConfigOption<Long> STANDALONE_CLUSTER_STARTUP_PERIOD_TIME = ConfigOptions.key("resourcemanager.standalone.start-up-time").defaultValue(-1L).withDescription("Time in milliseconds of the start-up period of a standalone cluster. During this time, resource manager of the standalone cluster expects new task executors to be registered, and will not fail slot requests that can not be satisfied by any current registered slots. After this time, it will fail pending and new coming requests immediately that can not be satisfied by registered slots. If not set, 'slotmanager.request-timeout' will be used by default.");
    @Deprecated
    public static final ConfigOption<Long> SLOT_MANAGER_TASK_MANAGER_TIMEOUT = ConfigOptions.key("slotmanager.taskmanager-timeout").defaultValue(30000L).withDescription("The timeout for an idle task manager to be released.");
    public static final ConfigOption<Long> TASK_MANAGER_TIMEOUT = ConfigOptions.key("resourcemanager.taskmanager-timeout").defaultValue(30000L).withDeprecatedKeys(SLOT_MANAGER_TASK_MANAGER_TIMEOUT.key()).withDescription(Description.builder().text("The timeout for an idle task manager to be released.").build());
    @Deprecated
    public static final ConfigOption<Boolean> TASK_MANAGER_RELEASE_WHEN_RESULT_CONSUMED = ConfigOptions.key("resourcemanager.taskmanager-release.wait.result.consumed").defaultValue(true).withDescription(Description.builder().text("Release task executor only when each produced result partition is either consumed or failed. 'True' is default. 'False' means that idle task executor release is not blocked by receiver confirming consumption of result partition and can happen right away after 'resourcemanager.taskmanager-timeout' has elapsed. Setting this option to 'false' can speed up task executor release but can lead to unexpected failures if end of consumption is slower than 'resourcemanager.taskmanager-timeout'.").build());
    public static final String CONTAINERIZED_MASTER_ENV_PREFIX = "containerized.master.env.";
    public static final String CONTAINERIZED_TASK_MANAGER_ENV_PREFIX = "containerized.taskmanager.env.";

    private ResourceManagerOptions() {
    }
}

