/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.Row;

@PublicEvolving
public final class RowUtils {
    public static boolean compareRows(List<Row> l1, List<Row> l2) {
        return RowUtils.compareRows(l1, l2, false);
    }

    public static boolean compareRows(List<Row> l1, List<Row> l2, boolean ignoreOrder) {
        if (l1 == l2) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        if (ignoreOrder) {
            return RowUtils.deepEqualsListUnordered(l1, l2);
        }
        return RowUtils.deepEqualsListOrdered(l1, l2);
    }

    static boolean deepEqualsRow(Row row1, Row row2) {
        if (row1.getKind() != row2.getKind()) {
            return false;
        }
        if (row1.getArity() != row2.getArity()) {
            return false;
        }
        for (int pos = 0; pos < row1.getArity(); ++pos) {
            Object f2;
            Object f1 = row1.getField(pos);
            if (RowUtils.deepEqualsInternal(f1, f2 = row2.getField(pos))) continue;
            return false;
        }
        return true;
    }

    static int deepHashCodeRow(Row row) {
        int result = row.getKind().toByteValue();
        for (int i = 0; i < row.getArity(); ++i) {
            result = 31 * result + RowUtils.deepHashCodeInternal(row.getField(i));
        }
        return result;
    }

    private static boolean deepEqualsInternal(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof Row && o2 instanceof Row) {
            return RowUtils.deepEqualsRow((Row)o1, (Row)o2);
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return RowUtils.deepEqualsArray((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof Map && o2 instanceof Map) {
            return RowUtils.deepEqualsMap((Map)o1, (Map)o2);
        }
        if (o1 instanceof List && o2 instanceof List) {
            return RowUtils.deepEqualsListOrdered((List)o1, (List)o2);
        }
        return Objects.deepEquals(o1, o2);
    }

    private static boolean deepEqualsArray(Object[] a1, Object[] a2) {
        if (a1.getClass() != a2.getClass()) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int pos = 0; pos < a1.length; ++pos) {
            Object e1 = a1[pos];
            Object e2 = a2[pos];
            if (RowUtils.deepEqualsInternal(e1, e2)) continue;
            return false;
        }
        return true;
    }

    private static <K, V> boolean deepEqualsMap(Map<K, V> m1, Map<?, ?> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : m1.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m2.get(key) != null || !m2.containsKey(key) : !RowUtils.deepEqualsInternal(value, m2.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    private static <E> boolean deepEqualsListOrdered(List<E> l1, List<?> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<E> i1 = l1.iterator();
        Iterator<?> i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object o2;
            E o1 = i1.next();
            if (RowUtils.deepEqualsInternal(o1, o2 = i2.next())) continue;
            return false;
        }
        return true;
    }

    private static <E> boolean deepEqualsListUnordered(List<E> l1, List<?> l2) {
        LinkedList l2Mutable = new LinkedList(l2);
        for (E e1 : l1) {
            Iterator iterator = l2Mutable.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!RowUtils.deepEqualsInternal(e1, e2)) continue;
                found = true;
                iterator.remove();
                break;
            }
            if (found) continue;
            return false;
        }
        return l2Mutable.size() == 0;
    }

    private static int deepHashCodeInternal(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Row) {
            return RowUtils.deepHashCodeRow((Row)o);
        }
        if (o instanceof Object[]) {
            return RowUtils.deepHashCodeArray((Object[])o);
        }
        if (o instanceof Map) {
            return RowUtils.deepHashCodeMap((Map)o);
        }
        if (o instanceof List) {
            return RowUtils.deepHashCodeList((List)o);
        }
        return Arrays.deepHashCode(new Object[]{o});
    }

    private static int deepHashCodeArray(Object[] a) {
        int result = 1;
        for (Object element : a) {
            result = 31 * result + RowUtils.deepHashCodeInternal(element);
        }
        return result;
    }

    private static int deepHashCodeMap(Map<?, ?> m) {
        int result = 1;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            result += RowUtils.deepHashCodeInternal(entry.getKey()) ^ RowUtils.deepHashCodeInternal(entry.getValue());
        }
        return result;
    }

    private static int deepHashCodeList(List<?> l) {
        int result = 1;
        for (Object e : l) {
            result = 31 * result + RowUtils.deepHashCodeInternal(e);
        }
        return result;
    }

    private RowUtils() {
    }
}

