/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class SerializedValue<T>
implements Serializable {
    private static final long serialVersionUID = -3564011643393683761L;
    @Nullable
    private final byte[] serializedData;

    private SerializedValue(byte[] serializedData) {
        Preconditions.checkNotNull(serializedData, "Serialized data");
        this.serializedData = serializedData;
    }

    public SerializedValue(T value) throws IOException {
        this.serializedData = value == null ? null : InstantiationUtil.serializeObject(value);
    }

    public T deserializeValue(ClassLoader loader) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull(loader, "No classloader has been passed");
        return this.serializedData == null ? null : (T)InstantiationUtil.deserializeObject(this.serializedData, loader);
    }

    @Nullable
    public byte[] getByteArray() {
        return this.serializedData;
    }

    public static <T> SerializedValue<T> fromBytes(byte[] serializedData) {
        return new SerializedValue<T>(serializedData);
    }

    public int hashCode() {
        return this.serializedData == null ? 0 : Arrays.hashCode(this.serializedData);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializedValue) {
            SerializedValue other = (SerializedValue)obj;
            return this.serializedData == null ? other.serializedData == null : other.serializedData != null && Arrays.equals(this.serializedData, other.serializedData);
        }
        return false;
    }

    public String toString() {
        return "SerializedValue";
    }
}

