/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.json.JsonFormatFactory;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.formats.json.JsonRowDataSerializationSchema;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FileSystemFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.PartitionPathUtils;

public class JsonFileSystemFormatFactory
implements FileSystemFormatFactory {
    public static final String IDENTIFIER = "json";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(JsonOptions.FAIL_ON_MISSING_FIELD);
        options.add(JsonOptions.IGNORE_PARSE_ERRORS);
        options.add(JsonOptions.TIMESTAMP_FORMAT);
        return options;
    }

    public InputFormat<RowData, ?> createReader(FileSystemFormatFactory.ReaderContext context) {
        ReadableConfig options = context.getFormatOptions();
        JsonFormatFactory.validateFormatOptions(options);
        boolean failOnMissingField = (Boolean)options.get(JsonOptions.FAIL_ON_MISSING_FIELD);
        boolean ignoreParseErrors = (Boolean)options.get(JsonOptions.IGNORE_PARSE_ERRORS);
        TimestampFormat timestampOption = JsonOptions.getTimestampFormat(options);
        RowType formatRowType = context.getFormatRowType();
        JsonRowDataDeserializationSchema deserializationSchema = new JsonRowDataDeserializationSchema(formatRowType, (TypeInformation<RowData>)new GenericTypeInfo(GenericRowData.class), failOnMissingField, ignoreParseErrors, timestampOption);
        String[] fieldNames = context.getSchema().getFieldNames();
        List projectFields = Arrays.stream(context.getProjectFields()).mapToObj(idx -> fieldNames[idx]).collect(Collectors.toList());
        List jsonFields = Arrays.stream(fieldNames).filter(field -> !context.getPartitionKeys().contains(field)).collect(Collectors.toList());
        int[] jsonSelectFieldToProjectFieldMapping = context.getFormatProjectFields().stream().mapToInt(projectFields::indexOf).toArray();
        int[] jsonSelectFieldToJsonFieldMapping = context.getFormatProjectFields().stream().mapToInt(jsonFields::indexOf).toArray();
        return new JsonInputFormat(context.getPaths(), context.getSchema().getFieldDataTypes(), context.getSchema().getFieldNames(), context.getProjectFields(), context.getPartitionKeys(), context.getDefaultPartName(), context.getPushedDownLimit(), jsonSelectFieldToProjectFieldMapping, jsonSelectFieldToJsonFieldMapping, deserializationSchema);
    }

    public Optional<Encoder<RowData>> createEncoder(FileSystemFormatFactory.WriterContext context) {
        return Optional.of(new JsonRowDataEncoder(new JsonRowDataSerializationSchema(context.getFormatRowType(), JsonOptions.getTimestampFormat(context.getFormatOptions()))));
    }

    public Optional<BulkWriter.Factory<RowData>> createBulkWriterFactory(FileSystemFormatFactory.WriterContext context) {
        return Optional.empty();
    }

    public static class JsonRowDataEncoder
    implements Encoder<RowData> {
        private static final long serialVersionUID = 1L;
        private static final String DEFAULT_LINE_DELIMITER = "\n";
        private final JsonRowDataSerializationSchema serializationSchema;

        public JsonRowDataEncoder(JsonRowDataSerializationSchema serializationSchema) {
            this.serializationSchema = serializationSchema;
        }

        public void encode(RowData element, OutputStream stream) throws IOException {
            stream.write(this.serializationSchema.serialize(element));
            stream.write(DEFAULT_LINE_DELIMITER.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static class JsonInputFormat
    extends DelimitedInputFormat<RowData> {
        private static final byte CARRIAGE_RETURN = 13;
        private static final byte NEW_LINE = 10;
        private final DataType[] fieldTypes;
        private final String[] fieldNames;
        private final int[] selectFields;
        private final List<String> partitionKeys;
        private final String defaultPartValue;
        private final long limit;
        private final int[] jsonSelectFieldToProjectFieldMapping;
        private final int[] jsonSelectFieldToJsonFieldMapping;
        private final JsonRowDataDeserializationSchema deserializationSchema;
        private transient boolean end;
        private transient long emitted;
        private transient GenericRowData rowData;

        public JsonInputFormat(Path[] filePaths, DataType[] fieldTypes, String[] fieldNames, int[] selectFields, List<String> partitionKeys, String defaultPartValue, long limit, int[] jsonSelectFieldToProjectFieldMapping, int[] jsonSelectFieldToJsonFieldMapping, JsonRowDataDeserializationSchema deserializationSchema) {
            super.setFilePaths(filePaths);
            this.fieldTypes = fieldTypes;
            this.fieldNames = fieldNames;
            this.selectFields = selectFields;
            this.partitionKeys = partitionKeys;
            this.defaultPartValue = defaultPartValue;
            this.limit = limit;
            this.jsonSelectFieldToProjectFieldMapping = jsonSelectFieldToProjectFieldMapping;
            this.jsonSelectFieldToJsonFieldMapping = jsonSelectFieldToJsonFieldMapping;
            this.deserializationSchema = deserializationSchema;
        }

        public boolean supportsMultiPaths() {
            return true;
        }

        public void open(FileInputSplit split) throws IOException {
            super.open(split);
            this.end = false;
            this.emitted = 0L;
            this.rowData = PartitionPathUtils.fillPartitionValueForRecord((String[])this.fieldNames, (DataType[])this.fieldTypes, (int[])this.selectFields, this.partitionKeys, (Path)this.currentSplit.getPath(), (String)this.defaultPartValue);
        }

        public boolean reachedEnd() {
            return this.emitted >= this.limit || this.end;
        }

        public RowData readRecord(RowData reuse, byte[] bytes, int offset, int numBytes) throws IOException {
            byte[] trimBytes;
            GenericRowData jsonRow;
            if (this.getDelimiter() != null && this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10 && offset + numBytes >= 1 && bytes[offset + numBytes - 1] == 13) {
                --numBytes;
            }
            if ((jsonRow = (GenericRowData)this.deserializationSchema.deserialize(trimBytes = Arrays.copyOfRange(bytes, offset, offset + numBytes))) == null) {
                return null;
            }
            GenericRowData returnRecord = this.rowData;
            for (int i = 0; i < this.jsonSelectFieldToJsonFieldMapping.length; ++i) {
                returnRecord.setField(this.jsonSelectFieldToProjectFieldMapping[i], jsonRow.getField(this.jsonSelectFieldToJsonFieldMapping[i]));
            }
            ++this.emitted;
            return returnRecord;
        }

        public RowData nextRecord(RowData record) throws IOException {
            while (this.readLine()) {
                RowData row = this.readRecord(record, this.currBuffer, this.currOffset, this.currLen);
                if (row == null) continue;
                return row;
            }
            this.end = true;
            return null;
        }
    }
}

