/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.json.TimeFormats;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public class JsonRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final SerializationRuntimeConverter runtimeConverter;
    private final ObjectMapper mapper = new ObjectMapper();
    private transient ObjectNode node;
    private final TimestampFormat timestampFormat;

    public JsonRowDataSerializationSchema(RowType rowType, TimestampFormat timestampFormat) {
        this.rowType = rowType;
        this.timestampFormat = timestampFormat;
        this.runtimeConverter = this.createConverter((LogicalType)rowType);
    }

    public byte[] serialize(RowData row) {
        if (this.node == null) {
            this.node = this.mapper.createObjectNode();
        }
        try {
            this.runtimeConverter.convert(this.mapper, (JsonNode)this.node, row);
            return this.mapper.writeValueAsBytes((Object)this.node);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + row + "'. Make sure that the schema matches the input.", t);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRowDataSerializationSchema that = (JsonRowDataSerializationSchema)o;
        return this.rowType.equals((Object)that.rowType) && this.timestampFormat.equals((Object)this.timestampFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rowType, this.timestampFormat});
    }

    private SerializationRuntimeConverter createConverter(LogicalType type) {
        return this.wrapIntoNullableConverter(this.createNotNullConverter(type));
    }

    private SerializationRuntimeConverter createNotNullConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().nullNode();
            }
            case BOOLEAN: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().booleanNode(((Boolean)value).booleanValue());
            }
            case TINYINT: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().numberNode(((Byte)value).byteValue());
            }
            case SMALLINT: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().numberNode(((Short)value).shortValue());
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().numberNode(((Integer)value).intValue());
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().numberNode(((Long)value).longValue());
            }
            case FLOAT: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().numberNode(((Float)value).floatValue());
            }
            case DOUBLE: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().numberNode(((Double)value).doubleValue());
            }
            case CHAR: 
            case VARCHAR: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().textNode(value.toString());
            }
            case BINARY: 
            case VARBINARY: {
                return (mapper, reuse, value) -> mapper.getNodeFactory().binaryNode((byte[])value);
            }
            case DATE: {
                return this.createDateConverter();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return this.createTimeConverter();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this.createTimestampConverter();
            }
            case DECIMAL: {
                return this.createDecimalConverter();
            }
            case ARRAY: {
                return this.createArrayConverter((ArrayType)type);
            }
            case MAP: 
            case MULTISET: {
                return this.createMapConverter((MapType)type);
            }
            case ROW: {
                return this.createRowConverter((RowType)type);
            }
        }
        throw new UnsupportedOperationException("Not support to parse type: " + type);
    }

    private SerializationRuntimeConverter createDecimalConverter() {
        return (mapper, reuse, value) -> {
            BigDecimal bd = ((DecimalData)value).toBigDecimal();
            return mapper.getNodeFactory().numberNode(bd);
        };
    }

    private SerializationRuntimeConverter createDateConverter() {
        return (mapper, reuse, value) -> {
            int days = (Integer)value;
            LocalDate date = LocalDate.ofEpochDay(days);
            return mapper.getNodeFactory().textNode(DateTimeFormatter.ISO_LOCAL_DATE.format(date));
        };
    }

    private SerializationRuntimeConverter createTimeConverter() {
        return (mapper, reuse, value) -> {
            int millisecond = (Integer)value;
            LocalTime time = LocalTime.ofSecondOfDay((long)millisecond / 1000L);
            return mapper.getNodeFactory().textNode(TimeFormats.SQL_TIME_FORMAT.format(time));
        };
    }

    private SerializationRuntimeConverter createTimestampConverter() {
        switch (this.timestampFormat) {
            case ISO_8601: {
                return (mapper, reuse, value) -> {
                    TimestampData timestamp = (TimestampData)value;
                    return mapper.getNodeFactory().textNode(TimeFormats.ISO8601_TIMESTAMP_FORMAT.format(timestamp.toLocalDateTime()));
                };
            }
            case SQL: {
                return (mapper, reuse, value) -> {
                    TimestampData timestamp = (TimestampData)value;
                    return mapper.getNodeFactory().textNode(TimeFormats.SQL_TIMESTAMP_FORMAT.format(timestamp.toLocalDateTime()));
                };
            }
        }
        throw new TableException("Unsupported timestamp format. Validator should have checked that.");
    }

    private SerializationRuntimeConverter createArrayConverter(ArrayType type) {
        LogicalType elementType = type.getElementType();
        SerializationRuntimeConverter elementConverter = this.createConverter(elementType);
        return (mapper, reuse, value) -> {
            ArrayNode node;
            if (reuse == null || reuse.isNull()) {
                node = mapper.createArrayNode();
            } else {
                node = (ArrayNode)reuse;
                node.removeAll();
            }
            ArrayData array = (ArrayData)value;
            int numElements = array.size();
            for (int i = 0; i < numElements; ++i) {
                Object element = ArrayData.get((ArrayData)array, (int)i, (LogicalType)elementType);
                node.add(elementConverter.convert(mapper, null, element));
            }
            return node;
        };
    }

    private SerializationRuntimeConverter createMapConverter(MapType type) {
        LogicalType keyType = type.getKeyType();
        if (!LogicalTypeChecks.hasFamily((LogicalType)keyType, (LogicalTypeFamily)LogicalTypeFamily.CHARACTER_STRING)) {
            throw new UnsupportedOperationException("JSON format doesn't support non-string as key type of map. The map type is: " + type.asSummaryString());
        }
        LogicalType valueType = type.getValueType();
        SerializationRuntimeConverter valueConverter = this.createConverter(valueType);
        return (mapper, reuse, object) -> {
            ObjectNode node;
            if (reuse == null || reuse.isNull()) {
                node = mapper.createObjectNode();
            } else {
                node = (ObjectNode)reuse;
                node.removeAll();
            }
            MapData map = (MapData)object;
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            int numElements = map.size();
            for (int i = 0; i < numElements; ++i) {
                String fieldName = keyArray.getString(i).toString();
                Object value = ArrayData.get((ArrayData)valueArray, (int)i, (LogicalType)valueType);
                node.set(fieldName, valueConverter.convert(mapper, node.get(fieldName), value));
            }
            return node;
        };
    }

    private SerializationRuntimeConverter createRowConverter(RowType type) {
        String[] fieldNames = type.getFieldNames().toArray(new String[0]);
        LogicalType[] fieldTypes = (LogicalType[])type.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        SerializationRuntimeConverter[] fieldConverters = (SerializationRuntimeConverter[])Arrays.stream(fieldTypes).map(this::createConverter).toArray(SerializationRuntimeConverter[]::new);
        int fieldCount = type.getFieldCount();
        return (mapper, reuse, value) -> {
            ObjectNode node = reuse == null || reuse.isNull() ? mapper.createObjectNode() : (ObjectNode)reuse;
            RowData row = (RowData)value;
            for (int i = 0; i < fieldCount; ++i) {
                String fieldName = fieldNames[i];
                Object field = RowData.get((RowData)row, (int)i, (LogicalType)fieldTypes[i]);
                node.set(fieldName, fieldConverters[i].convert(mapper, node.get(fieldName), field));
            }
            return node;
        };
    }

    private SerializationRuntimeConverter wrapIntoNullableConverter(SerializationRuntimeConverter converter) {
        return (mapper, reuse, object) -> {
            if (object == null) {
                return mapper.getNodeFactory().nullNode();
            }
            return converter.convert(mapper, reuse, object);
        };
    }

    private static interface SerializationRuntimeConverter
    extends Serializable {
        public JsonNode convert(ObjectMapper var1, JsonNode var2, Object var3);
    }
}

