/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.canal;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public final class CanalJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final String OP_INSERT = "INSERT";
    private static final String OP_UPDATE = "UPDATE";
    private static final String OP_DELETE = "DELETE";
    private final JsonRowDataDeserializationSchema jsonDeserializer;
    private final TypeInformation<RowData> resultTypeInfo;
    private final boolean ignoreParseErrors;
    private final int fieldCount;

    public CanalJsonDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean ignoreParseErrors, TimestampFormat timestampFormatOption) {
        this.resultTypeInfo = resultTypeInfo;
        this.ignoreParseErrors = ignoreParseErrors;
        this.fieldCount = rowType.getFieldCount();
        this.jsonDeserializer = new JsonRowDataDeserializationSchema(CanalJsonDeserializationSchema.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType)), resultTypeInfo, false, ignoreParseErrors, timestampFormatOption);
    }

    public RowData deserialize(byte[] message) throws IOException {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        block13: {
            try {
                RowData row = this.jsonDeserializer.deserialize(message);
                String type = row.getString(2).toString();
                if (OP_INSERT.equals(type)) {
                    ArrayData data = row.getArray(0);
                    for (int i = 0; i < data.size(); ++i) {
                        RowData insert = data.getRow(i, this.fieldCount);
                        insert.setRowKind(RowKind.INSERT);
                        out.collect((Object)insert);
                    }
                } else if (OP_UPDATE.equals(type)) {
                    ArrayData data = row.getArray(0);
                    ArrayData old = row.getArray(1);
                    for (int i = 0; i < data.size(); ++i) {
                        GenericRowData after = (GenericRowData)data.getRow(i, this.fieldCount);
                        GenericRowData before = (GenericRowData)old.getRow(i, this.fieldCount);
                        for (int f = 0; f < this.fieldCount; ++f) {
                            if (!before.isNullAt(f)) continue;
                            before.setField(f, after.getField(f));
                        }
                        before.setRowKind(RowKind.UPDATE_BEFORE);
                        after.setRowKind(RowKind.UPDATE_AFTER);
                        out.collect((Object)before);
                        out.collect((Object)after);
                    }
                } else if (OP_DELETE.equals(type)) {
                    ArrayData data = row.getArray(0);
                    for (int i = 0; i < data.size(); ++i) {
                        RowData insert = data.getRow(i, this.fieldCount);
                        insert.setRowKind(RowKind.DELETE);
                        out.collect((Object)insert);
                    }
                } else if (!this.ignoreParseErrors) {
                    throw new IOException(String.format("Unknown \"type\" value \"%s\". The Canal JSON message is '%s'", type, new String(message)));
                }
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) break block13;
                throw new IOException(String.format("Corrupt Canal JSON message '%s'.", new String(message)), t);
            }
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanalJsonDeserializationSchema that = (CanalJsonDeserializationSchema)o;
        return this.ignoreParseErrors == that.ignoreParseErrors && this.fieldCount == that.fieldCount && Objects.equals(this.jsonDeserializer, that.jsonDeserializer) && Objects.equals(this.resultTypeInfo, that.resultTypeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.jsonDeserializer, this.resultTypeInfo, this.ignoreParseErrors, this.fieldCount);
    }

    private static RowType createJsonRowType(DataType databaseSchema) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)DataTypes.ARRAY((DataType)databaseSchema)), DataTypes.FIELD((String)"old", (DataType)DataTypes.ARRAY((DataType)databaseSchema)), DataTypes.FIELD((String)"type", (DataType)DataTypes.STRING())}).getLogicalType();
    }
}

