/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.debezium;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

@Internal
public final class DebeziumJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final String OP_READ = "r";
    private static final String OP_CREATE = "c";
    private static final String OP_UPDATE = "u";
    private static final String OP_DELETE = "d";
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s message is null, if you are using Debezium Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    private final JsonRowDataDeserializationSchema jsonDeserializer;
    private final TypeInformation<RowData> resultTypeInfo;
    private final boolean schemaInclude;
    private final boolean ignoreParseErrors;

    public DebeziumJsonDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean schemaInclude, boolean ignoreParseErrors, TimestampFormat timestampFormatOption) {
        this.resultTypeInfo = resultTypeInfo;
        this.schemaInclude = schemaInclude;
        this.ignoreParseErrors = ignoreParseErrors;
        this.jsonDeserializer = new JsonRowDataDeserializationSchema(DebeziumJsonDeserializationSchema.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType), schemaInclude), resultTypeInfo, false, ignoreParseErrors, timestampFormatOption);
    }

    public RowData deserialize(byte[] message) throws IOException {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        block12: {
            if (message == null || message.length == 0) {
                return;
            }
            try {
                GenericRowData row = (GenericRowData)this.jsonDeserializer.deserialize(message);
                GenericRowData payload = this.schemaInclude ? (GenericRowData)row.getField(0) : row;
                GenericRowData before = (GenericRowData)payload.getField(0);
                GenericRowData after = (GenericRowData)payload.getField(1);
                String op = payload.getField(2).toString();
                if (OP_CREATE.equals(op) || OP_READ.equals(op)) {
                    after.setRowKind(RowKind.INSERT);
                    out.collect((Object)after);
                } else if (OP_UPDATE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                    }
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    after.setRowKind(RowKind.UPDATE_AFTER);
                    out.collect((Object)before);
                    out.collect((Object)after);
                } else if (OP_DELETE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                    }
                    before.setRowKind(RowKind.DELETE);
                    out.collect((Object)before);
                } else if (!this.ignoreParseErrors) {
                    throw new IOException(String.format("Unknown \"op\" value \"%s\". The Debezium JSON message is '%s'", op, new String(message)));
                }
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) break block12;
                throw new IOException(String.format("Corrupt Debezium JSON message '%s'.", new String(message)), t);
            }
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebeziumJsonDeserializationSchema that = (DebeziumJsonDeserializationSchema)o;
        return this.schemaInclude == that.schemaInclude && this.ignoreParseErrors == that.ignoreParseErrors && Objects.equals(this.jsonDeserializer, that.jsonDeserializer) && Objects.equals(this.resultTypeInfo, that.resultTypeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.jsonDeserializer, this.resultTypeInfo, this.schemaInclude, this.ignoreParseErrors);
    }

    private static RowType createJsonRowType(DataType databaseSchema, boolean schemaInclude) {
        DataType payload = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"before", (DataType)databaseSchema), DataTypes.FIELD((String)"after", (DataType)databaseSchema), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING())});
        if (schemaInclude) {
            return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"payload", (DataType)payload)}).getLogicalType();
        }
        return (RowType)payload.getLogicalType();
    }
}

