/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingInsertValue;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingInsertValuesToken;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.common.rule.DataNode;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.RouteContextAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.underlying.route.context.RouteContext;

public final class ShardingInsertValuesTokenGenerator
implements OptionalSQLTokenGenerator<InsertStatementContext>,
RouteContextAware {
    private RouteContext routeContext;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getValues().isEmpty();
    }

    public InsertValuesToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Collection insertValuesSegments = ((InsertStatement)insertStatementContext.getSqlStatement()).getValues();
        ShardingInsertValuesToken result = new ShardingInsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
        Iterator originalDataNodesIterator = null == this.routeContext || this.routeContext.getRouteResult().getOriginalDataNodes().isEmpty() ? null : this.routeContext.getRouteResult().getOriginalDataNodes().iterator();
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            List expressionSegments = each.getValueExpressions();
            List<DataNode> dataNodes = null == originalDataNodesIterator ? Collections.emptyList() : (Collection)originalDataNodesIterator.next();
            result.getInsertValues().add(new ShardingInsertValue(expressionSegments, dataNodes));
        }
        return result;
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = result > each.getStartIndex() ? each.getStartIndex() : result;
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = result < each.getStopIndex() ? each.getStopIndex() : result;
        }
        return result;
    }

    @Generated
    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

