/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.UseDefaultInsertColumnsToken;

public final class GeneratedKeyForUseDefaultInsertColumnsTokenGenerator
extends BaseGeneratedKeyTokenGenerator {
    @Override
    protected boolean isGenerateSQLToken(InsertStatement insertStatement) {
        return insertStatement.useDefaultColumns();
    }

    public UseDefaultInsertColumnsToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional insertColumnsSegment = ((InsertStatement)insertStatementContext.getSqlStatement()).getInsertColumns();
        Preconditions.checkState((boolean)insertColumnsSegment.isPresent());
        return new UseDefaultInsertColumnsToken(((InsertColumnsSegment)insertColumnsSegment.get()).getStopIndex(), this.getColumnNames(insertStatementContext));
    }

    private List<String> getColumnNames(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        Preconditions.checkState((boolean)generatedKey.isPresent());
        ArrayList<String> result = new ArrayList<String>(insertStatementContext.getColumnNames());
        result.remove(((GeneratedKeyContext)generatedKey.get()).getColumnName());
        result.add(((GeneratedKeyContext)generatedKey.get()).getColumnName());
        return result;
    }
}

