/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.sql.value.identifier.IdentifierValue;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.underlying.route.context.RouteMapper;
import org.apache.shardingsphere.underlying.route.context.RouteUnit;

public final class TableToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue identifier;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingRule shardingRule;

    public TableToken(int startIndex, int stopIndex, IdentifierValue identifier, SQLStatementContext sqlStatementContext, ShardingRule shardingRule) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.identifier = identifier;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingRule = shardingRule;
    }

    public String toString(RouteUnit routeUnit) {
        String actualTableName = this.getLogicAndActualTables(routeUnit).get(this.identifier.getValue().toLowerCase());
        actualTableName = null == actualTableName ? this.identifier.getValue().toLowerCase() : actualTableName;
        return Joiner.on((String)"").join((Object)this.identifier.getQuoteCharacter().getStartDelimiter(), (Object)actualTableName, new Object[]{this.identifier.getQuoteCharacter().getEndDelimiter()});
    }

    private Map<String, String> getLogicAndActualTables(RouteUnit routeUnit) {
        Collection tableNames = this.sqlStatementContext.getTablesContext().getTableNames();
        HashMap<String, String> result = new HashMap<String, String>(tableNames.size(), 1.0f);
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName().toLowerCase(), each.getActualName());
            result.putAll(this.shardingRule.getLogicAndActualTablesFromBindingTable(routeUnit.getDataSourceMapper().getLogicName(), each.getLogicName(), each.getActualName(), tableNames));
        }
        return result;
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

