/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.engine;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.spi.SPITimeService;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;

public final class InsertClauseShardingConditionEngine {
    private final ShardingRule shardingRule;

    public List<ShardingCondition> createShardingConditions(InsertStatementContext insertStatementContext, List<Object> parameters) {
        LinkedList<ShardingCondition> result = new LinkedList<ShardingCondition>();
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Collection<String> columnNames = this.getColumnNames(insertStatementContext);
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            result.add(this.createShardingCondition(tableName, columnNames.iterator(), each, parameters));
        }
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        if (generatedKey.isPresent() && ((GeneratedKeyContext)generatedKey.get()).isGenerated()) {
            ((GeneratedKeyContext)generatedKey.get()).getGeneratedValues().addAll(this.getGeneratedKeys(tableName, ((InsertStatement)insertStatementContext.getSqlStatement()).getValueListCount()));
            if (this.shardingRule.isShardingColumn(((GeneratedKeyContext)generatedKey.get()).getColumnName(), tableName)) {
                this.appendGeneratedKeyCondition((GeneratedKeyContext)generatedKey.get(), tableName, result);
            }
        }
        return result;
    }

    private Collection<String> getColumnNames(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        if (generatedKey.isPresent() && ((GeneratedKeyContext)generatedKey.get()).isGenerated()) {
            LinkedList<String> result = new LinkedList<String>(insertStatementContext.getColumnNames());
            result.remove(((GeneratedKeyContext)generatedKey.get()).getColumnName());
            return result;
        }
        return insertStatementContext.getColumnNames();
    }

    private ShardingCondition createShardingCondition(String tableName, Iterator<String> columnNames, InsertValueContext insertValueContext, List<Object> parameters) {
        ShardingCondition result = new ShardingCondition();
        SPITimeService timeService = new SPITimeService();
        for (ExpressionSegment each : insertValueContext.getValueExpressions()) {
            String columnName = columnNames.next();
            if (!this.shardingRule.isShardingColumn(columnName, tableName)) continue;
            if (each instanceof SimpleExpressionSegment) {
                result.getRouteValues().add((RouteValue)new ListRouteValue(columnName, tableName, Collections.singletonList(this.getRouteValue((SimpleExpressionSegment)each, parameters))));
                continue;
            }
            if (ExpressionConditionUtils.isNowExpression(each)) {
                result.getRouteValues().add((RouteValue)new ListRouteValue(columnName, tableName, Collections.singletonList(timeService.getTime())));
                continue;
            }
            if (!ExpressionConditionUtils.isNullExpression(each)) continue;
            throw new ShardingSphereException("Insert clause sharding column can't be null.", new Object[0]);
        }
        return result;
    }

    private Comparable<?> getRouteValue(SimpleExpressionSegment expressionSegment, List<Object> parameters) {
        Object result = expressionSegment instanceof ParameterMarkerExpressionSegment ? parameters.get(((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex()) : ((LiteralExpressionSegment)expressionSegment).getLiterals();
        Preconditions.checkArgument((boolean)(result instanceof Comparable), (Object)"Sharding value must implements Comparable.");
        return (Comparable)result;
    }

    private Collection<Comparable<?>> getGeneratedKeys(String tableName, int valueListCount) {
        return IntStream.range(0, valueListCount).mapToObj(i -> this.shardingRule.generateKey(tableName)).collect(Collectors.toCollection(LinkedList::new));
    }

    private void appendGeneratedKeyCondition(GeneratedKeyContext generatedKey, String tableName, List<ShardingCondition> shardingConditions) {
        Iterator generatedValuesIterator = generatedKey.getGeneratedValues().iterator();
        for (ShardingCondition each : shardingConditions) {
            each.getRouteValues().add((RouteValue)new ListRouteValue(generatedKey.getColumnName(), tableName, Collections.singletonList(generatedValuesIterator.next())));
        }
    }

    @Generated
    public InsertClauseShardingConditionEngine(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

