/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.engine;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RangeRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.sharding.route.engine.condition.AlwaysFalseRouteValue;
import org.apache.shardingsphere.sharding.route.engine.condition.AlwaysFalseShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGeneratorFactory;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;

public final class WhereClauseShardingConditionEngine {
    private final ShardingRule shardingRule;
    private final SchemaMetaData schemaMetaData;

    public List<ShardingCondition> createShardingConditions(SQLStatementContext sqlStatementContext, List<Object> parameters) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptyList();
        }
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>();
        Optional whereSegment = ((WhereAvailable)sqlStatementContext).getWhere();
        if (whereSegment.isPresent()) {
            result.addAll(this.createShardingConditions(sqlStatementContext, ((WhereSegment)whereSegment.get()).getAndPredicates(), parameters));
        }
        return result;
    }

    private Collection<ShardingCondition> createShardingConditions(SQLStatementContext sqlStatementContext, Collection<AndPredicate> andPredicates, List<Object> parameters) {
        LinkedList<ShardingCondition> result = new LinkedList<ShardingCondition>();
        for (AndPredicate each : andPredicates) {
            Map<Column, Collection<RouteValue>> routeValueMap = this.createRouteValueMap(sqlStatementContext, each, parameters);
            if (routeValueMap.isEmpty()) {
                return Collections.emptyList();
            }
            result.add(this.createShardingCondition(routeValueMap));
        }
        return result;
    }

    private Map<Column, Collection<RouteValue>> createRouteValueMap(SQLStatementContext sqlStatementContext, AndPredicate andPredicate, List<Object> parameters) {
        HashMap<Column, Collection<RouteValue>> result = new HashMap<Column, Collection<RouteValue>>();
        for (PredicateSegment each : andPredicate.getPredicates()) {
            Optional tableName = sqlStatementContext.getTablesContext().findTableName(each.getColumn(), this.schemaMetaData);
            if (!tableName.isPresent() || !this.shardingRule.isShardingColumn(each.getColumn().getIdentifier().getValue(), (String)tableName.get())) continue;
            Column column = new Column(each.getColumn().getIdentifier().getValue(), (String)tableName.get());
            Optional<RouteValue> routeValue = ConditionValueGeneratorFactory.generate(each.getRightValue(), column, parameters);
            if (!routeValue.isPresent()) continue;
            if (!result.containsKey(column)) {
                result.put(column, new LinkedList());
            }
            ((Collection)result.get(column)).add(routeValue.get());
        }
        return result;
    }

    private ShardingCondition createShardingCondition(Map<Column, Collection<RouteValue>> routeValueMap) {
        ShardingCondition result = new ShardingCondition();
        for (Map.Entry<Column, Collection<RouteValue>> entry : routeValueMap.entrySet()) {
            try {
                RouteValue routeValue = this.mergeRouteValues(entry.getKey(), entry.getValue());
                if (routeValue instanceof AlwaysFalseRouteValue) {
                    return new AlwaysFalseShardingCondition();
                }
                result.getRouteValues().add(routeValue);
            }
            catch (ClassCastException ex) {
                throw new ShardingSphereException("Found different types for sharding value `%s`.", new Object[]{entry.getKey()});
            }
        }
        return result;
    }

    private RouteValue mergeRouteValues(Column column, Collection<RouteValue> routeValues) {
        Collection<Comparable<?>> listValue = null;
        Range<Comparable<?>> rangeValue = null;
        for (RouteValue each : routeValues) {
            if (each instanceof ListRouteValue) {
                listValue = this.mergeListRouteValues(((ListRouteValue)each).getValues(), listValue);
                if (!listValue.isEmpty()) continue;
                return new AlwaysFalseRouteValue();
            }
            if (!(each instanceof RangeRouteValue)) continue;
            try {
                rangeValue = this.mergeRangeRouteValues(((RangeRouteValue)each).getValueRange(), rangeValue);
            }
            catch (IllegalArgumentException ex) {
                return new AlwaysFalseRouteValue();
            }
        }
        if (null == listValue) {
            return new RangeRouteValue(column.getName(), column.getTableName(), rangeValue);
        }
        if (null == rangeValue) {
            return new ListRouteValue(column.getName(), column.getTableName(), listValue);
        }
        return (listValue = this.mergeListAndRangeRouteValues(listValue, rangeValue)).isEmpty() ? new AlwaysFalseRouteValue() : new ListRouteValue(column.getName(), column.getTableName(), listValue);
    }

    private Collection<Comparable<?>> mergeListRouteValues(Collection<Comparable<?>> value1, Collection<Comparable<?>> value2) {
        if (null == value2) {
            return value1;
        }
        value1.retainAll(value2);
        return value1;
    }

    private Range<Comparable<?>> mergeRangeRouteValues(Range<Comparable<?>> value1, Range<Comparable<?>> value2) {
        return null == value2 ? value1 : value1.intersection(value2);
    }

    private Collection<Comparable<?>> mergeListAndRangeRouteValues(Collection<Comparable<?>> listValue, Range<Comparable<?>> rangeValue) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : listValue) {
            if (!rangeValue.contains(each)) continue;
            result.add(each);
        }
        return result;
    }

    @Generated
    public WhereClauseShardingConditionEngine(ShardingRule shardingRule, SchemaMetaData schemaMetaData) {
        this.shardingRule = shardingRule;
        this.schemaMetaData = schemaMetaData;
    }
}

