/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator.impl;

import com.google.common.collect.Range;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.core.strategy.route.value.RangeRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGenerator;
import org.apache.shardingsphere.sharding.route.spi.SPITimeService;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateBetweenRightValue;

public final class ConditionValueBetweenOperatorGenerator
implements ConditionValueGenerator<PredicateBetweenRightValue> {
    @Override
    public Optional<RouteValue> generate(PredicateBetweenRightValue predicateRightValue, Column column, List<Object> parameters) {
        Optional<Comparable> betweenRouteValue = new ConditionValue(predicateRightValue.getBetweenExpression(), parameters).getValue();
        Optional<Comparable> andRouteValue = new ConditionValue(predicateRightValue.getAndExpression(), parameters).getValue();
        if (betweenRouteValue.isPresent() && andRouteValue.isPresent()) {
            return Optional.of(new RangeRouteValue(column.getName(), column.getTableName(), Range.closed((Comparable)betweenRouteValue.get(), (Comparable)andRouteValue.get())));
        }
        Date date = new SPITimeService().getTime();
        if (!betweenRouteValue.isPresent() && ExpressionConditionUtils.isNowExpression(predicateRightValue.getBetweenExpression())) {
            betweenRouteValue = Optional.of(date);
        }
        if (!andRouteValue.isPresent() && ExpressionConditionUtils.isNowExpression(predicateRightValue.getAndExpression())) {
            andRouteValue = Optional.of(date);
        }
        return betweenRouteValue.isPresent() && andRouteValue.isPresent() ? Optional.of(new RangeRouteValue(column.getName(), column.getTableName(), Range.closed((Comparable)betweenRouteValue.get(), (Comparable)andRouteValue.get()))) : Optional.empty();
    }
}

