/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGenerator;
import org.apache.shardingsphere.sharding.route.spi.SPITimeService;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateInRightValue;

public final class ConditionValueInOperatorGenerator
implements ConditionValueGenerator<PredicateInRightValue> {
    @Override
    public Optional<RouteValue> generate(PredicateInRightValue predicateRightValue, Column column, List<Object> parameters) {
        LinkedList<Comparable> routeValues = new LinkedList<Comparable>();
        SPITimeService timeService = new SPITimeService();
        for (ExpressionSegment each : predicateRightValue.getSqlExpressions()) {
            Optional<Comparable> routeValue = new ConditionValue(each, parameters).getValue();
            if (routeValue.isPresent()) {
                routeValues.add(routeValue.get());
                continue;
            }
            if (!ExpressionConditionUtils.isNowExpression(each)) continue;
            routeValues.add(timeService.getTime());
        }
        return routeValues.isEmpty() ? Optional.empty() : Optional.of(new ListRouteValue(column.getName(), column.getTableName(), routeValues));
    }
}

