/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.complex;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.underlying.route.context.RouteMapper;
import org.apache.shardingsphere.underlying.route.context.RouteResult;
import org.apache.shardingsphere.underlying.route.context.RouteUnit;

public final class ShardingCartesianRoutingEngine
implements ShardingRouteEngine {
    private final Collection<RouteResult> routeResults;

    @Override
    public RouteResult route(ShardingRule shardingRule) {
        RouteResult result = new RouteResult();
        for (Map.Entry<String, Set<String>> entry : this.getDataSourceLogicTablesMap().entrySet()) {
            List<Set<String>> actualTableGroups = this.getActualTableGroups(entry.getKey(), entry.getValue());
            List<Set<RouteMapper>> routingTableGroups = this.toRoutingTableGroups(entry.getKey(), actualTableGroups);
            result.getRouteUnits().addAll(this.getRouteUnits(entry.getKey(), Sets.cartesianProduct(routingTableGroups)));
        }
        return result;
    }

    private Map<String, Set<String>> getDataSourceLogicTablesMap() {
        Collection<String> intersectionDataSources = this.getIntersectionDataSources();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(this.routeResults.size());
        for (RouteResult each : this.routeResults) {
            for (Map.Entry entry : each.getDataSourceLogicTablesMap(intersectionDataSources).entrySet()) {
                if (result.containsKey(entry.getKey())) {
                    ((Set)result.get(entry.getKey())).addAll((Collection)entry.getValue());
                    continue;
                }
                result.put((String)entry.getKey(), (Set<String>)entry.getValue());
            }
        }
        return result;
    }

    private Collection<String> getIntersectionDataSources() {
        HashSet<String> result = new HashSet<String>();
        for (RouteResult each : this.routeResults) {
            if (result.isEmpty()) {
                result.addAll(each.getActualDataSourceNames());
            }
            result.retainAll(each.getActualDataSourceNames());
        }
        return result;
    }

    private List<Set<String>> getActualTableGroups(String dataSourceName, Set<String> logicTables) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>(logicTables.size());
        for (RouteResult each : this.routeResults) {
            result.addAll(each.getActualTableNameGroups(dataSourceName, logicTables));
        }
        return result;
    }

    private List<Set<RouteMapper>> toRoutingTableGroups(String dataSource, List<Set<String>> actualTableGroups) {
        ArrayList<Set<RouteMapper>> result = new ArrayList<Set<RouteMapper>>(actualTableGroups.size());
        for (Set<String> each : actualTableGroups) {
            result.add(new HashSet(new ArrayList<String>(each).stream().map(input -> this.findRoutingTable(dataSource, (String)input)).collect(Collectors.toList())));
        }
        return result;
    }

    private RouteMapper findRoutingTable(String dataSource, String actualTable) {
        for (RouteResult each : this.routeResults) {
            Optional result = each.findTableMapper(dataSource, actualTable);
            if (!result.isPresent()) continue;
            return (RouteMapper)result.get();
        }
        throw new IllegalStateException(String.format("Cannot found routing table factor, data source: %s, actual table: %s", dataSource, actualTable));
    }

    private Collection<RouteUnit> getRouteUnits(String dataSource, Set<List<RouteMapper>> cartesianRoutingTableGroups) {
        LinkedHashSet<RouteUnit> result = new LinkedHashSet<RouteUnit>();
        for (List<RouteMapper> each : cartesianRoutingTableGroups) {
            result.add(new RouteUnit(new RouteMapper(dataSource, dataSource), each));
        }
        return result;
    }

    @Generated
    public ShardingCartesianRoutingEngine(Collection<RouteResult> routeResults) {
        this.routeResults = routeResults;
    }
}

